/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.weighting;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeWeights2ExampleSet
extends Operator {
    public AttributeWeights2ExampleSet(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        AttributeWeights weights = this.getInput(AttributeWeights.class);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        Attribute nameAttribute = AttributeFactory.createAttribute("Attribute", 1);
        Attribute weightAttribute = AttributeFactory.createAttribute("Weight", 4);
        attributes.add(nameAttribute);
        attributes.add(weightAttribute);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (String name : weights.getAttributeNames()) {
            double[] data = new double[]{nameAttribute.getMapping().mapString(name), weights.getWeight(name)};
            table.addDataRow(new DoubleArrayDataRow(data));
        }
        return new IOObject[]{table.createExampleSet()};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{AttributeWeights.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{ExampleSet.class};
    }
}

