/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.features.construction.AbstractFeatureConstruction;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeAggregationOperator
extends AbstractFeatureConstruction {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_AGGREGATION_ATTRIBUTES = "aggregation_attributes";
    public static final String PARAMETER_AGGREGATION_FUNCTION = "aggregation_function";
    public static final String PARAMETER_IGNORE_MISSINGS = "ignore_missings";
    public static final String PARAMETER_KEEP_ALL = "keep_all";

    public AttributeAggregationOperator(OperatorDescription description) {
        super(description);
    }

    private Attribute[] getAttributesArrayFromRegex(Attributes attributes, String regex) throws OperatorException {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        for (Attribute attribute : attributes) {
            Matcher matcher = pattern.matcher(attribute.getName());
            if (!matcher.matches()) continue;
            attributeList.add(attribute);
        }
        Attribute[] attributesArray = new Attribute[attributeList.size()];
        attributesArray = attributeList.toArray(attributesArray);
        return attributesArray;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute[] attributes = this.getAttributesArrayFromRegex(exampleSet.getAttributes(), this.getParameterAsString(PARAMETER_AGGREGATION_ATTRIBUTES));
        String functionName = AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[this.getParameterAsInt(PARAMETER_AGGREGATION_FUNCTION)];
        boolean ignoreMissings = this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS);
        AggregationFunction aggregationFunction = null;
        try {
            aggregationFunction = AbstractAggregationFunction.createAggregationFunction(functionName, ignoreMissings);
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        int i = 0;
        while (i < attributes.length) {
            if (!aggregationFunction.supportsAttribute(attributes[i])) {
                throw new UserError((Operator)this, 136, attributes[i].getName());
            }
            ++i;
        }
        Attribute newAttribute = AttributeFactory.createAttribute(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME), 4);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        double[] values = new double[attributes.length];
        for (Example example : exampleSet) {
            int i2 = 0;
            while (i2 < attributes.length) {
                values[i2] = example.getValue(attributes[i2]);
                ++i2;
            }
            example.setValue(newAttribute, aggregationFunction.calculate(values));
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ALL)) {
            int i3 = 0;
            while (i3 < attributes.length) {
                exampleSet.getAttributes().remove(attributes[i3]);
                ++i3;
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "Name of the resulting attributes.", false));
        types.add(new ParameterTypeString(PARAMETER_AGGREGATION_ATTRIBUTES, "Regular expression specifying the attributes that should be aggregated.", false));
        types.add(new ParameterTypeCategory(PARAMETER_AGGREGATION_FUNCTION, "Function for aggregating the attribute values.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, 6));
        types.add(new ParameterTypeBoolean(PARAMETER_IGNORE_MISSINGS, "Indicates if missings should be ignored and aggregation should be based only on existing values or not. In the latter case the aggregated value will be missing in the presence of missing values.", true));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ALL, "Indicates if the all old attributes should be kept.", true));
        return types;
    }
}

