/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.extraction;

import com.rapidminer.operator.UserError;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.TextExtractor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathExtractor
implements TextExtractor {
    private String query;
    private JDOMXPath xpathExpression;

    public XPathExtractor(String query, Map<String, String> nameSpaceMap) throws JaxenException {
        this.query = query;
        this.xpathExpression = new JDOMXPath(query);
        this.xpathExpression.addNamespace("h", "http://www.w3.org/1999/xhtml");
        for (String id : nameSpaceMap.keySet()) {
            this.xpathExpression.addNamespace(id, nameSpaceMap.get(id));
        }
    }

    public JDOMXPath getXPathExpression() {
        return this.xpathExpression;
    }

    public Iterator<String> findPatterns(Document dom) throws JaxenException, ExtractionException {
        LinkedList<String> result = new LinkedList<String>();
        XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
        List nodes = this.xpathExpression.selectNodes((Object)dom);
        for (Object obj : nodes) {
            StringWriter w = new StringWriter();
            try {
                if (obj instanceof Element) {
                    out.output((Element)obj, (Writer)w);
                } else if (obj instanceof Attribute) {
                    w.write(((Attribute)obj).getValue());
                } else {
                    out.output((Text)obj, (Writer)w);
                }
                result.add(w.getBuffer().toString());
            }
            catch (IOException e) {
                throw new ExtractionException("", e, new UserError(null, 401, e));
            }
        }
        return result.iterator();
    }

    public boolean equals(Object obj) {
        return this.query.equals(obj.toString());
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String toString() {
        return this.query;
    }
}

