/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.operator.ExampleTableOutputFilter;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.RapidMinerOutputFilter;
import com.rapidminer.operator.TextInput;
import com.rapidminer.operator.TextObject;
import com.rapidminer.parameter.ParameterType;
import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.config.WVTConfigurationFact;
import edu.udo.cs.wvtool.config.WVTConfigurationRule;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTFileInputList;
import edu.udo.cs.wvtool.main.WVTInputList;
import edu.udo.cs.wvtool.wordlist.WVTWordList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextObjectTextInput
extends TextInput {
    public static final String PARAMETER_TEXT = "text";

    public TextObjectTextInput(OperatorDescription description) {
        super(description);
    }

    @Override
    protected RapidMinerOutputFilter getOutputFilter(WVTWordList wordList, Attribute label) throws OperatorException {
        return new ExampleTableOutputFilter(label, wordList, this.getParameterAsBoolean("use_content_attributes"), this.getParameterAsInt("id_attribute_type"), null, null, this);
    }

    @Override
    protected Attribute getLabel() throws OperatorException {
        return null;
    }

    @Override
    protected WVTInputList createInputList() throws OperatorException {
        this.log("Creating WVTool input list from single text from parameter.");
        String contentType = this.getParameterAsString("default_content_type");
        String contentEncoding = this.getParameterAsString("default_content_encoding");
        String contentLanguage = this.getParameterAsString("default_content_language");
        WVTFileInputList list = new WVTFileInputList(0);
        String text = this.getInput(TextObject.class).getText();
        list.addEntry(new WVTDocumentInfo(text, contentType, contentEncoding, contentLanguage));
        return list;
    }

    @Override
    protected WVTConfiguration createConfiguration() throws OperatorException {
        WVTConfiguration config = new WVTConfiguration();
        this.log("Creating WVTool configuration including source as text loader...");
        config.setConfigurationRule("loader", (WVTConfigurationRule)new WVTConfigurationFact("edu.udo.cs.wvtool.generic.loader.SourceAsTextLoader"));
        return config;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.addAll(super.getParameterTypes());
        Iterator i = types.iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            if (!type.getKey().equals("loader")) continue;
            i.remove();
            break;
        }
        return types;
    }

    @Override
    public InputDescription getInputDescription(Class<?> cls) {
        if (TextObject.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }
}

