/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.wizards.PreviewListener;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.extraction.ExtractionException;
import com.rapidminer.operator.extraction.TextExtractionWrapper;
import com.rapidminer.operator.extraction.segmenter.DocumentSegmenter;
import com.rapidminer.operator.extraction.segmenter.DocumentSegmenterClass;
import com.rapidminer.parameter.UndefinedParameterError;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SegmenterPreviewer
extends JDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 3938814199445624978L;
    public static final String ERROR_MESSAGE = "You must specify a directory containing at least one text in \"texts\"";
    private JTextArea textAreaOriginal = new JTextArea();
    private JTextArea textAreaSegments;
    private JList selectorList = null;
    private String fileType = null;
    private DocumentSegmenter segmenter = null;

    public SegmenterPreviewer(PreviewListener previewListener) {
        super(RapidMinerGUI.getMainFrame(), "Segmenter Previewer", true);
        this.textAreaOriginal.setWrapStyleWord(true);
        this.textAreaOriginal.setLineWrap(true);
        this.textAreaOriginal.setMargin(new Insets(10, 10, 10, 10));
        this.textAreaSegments = new JTextArea();
        this.textAreaSegments.setWrapStyleWord(true);
        this.textAreaSegments.setLineWrap(true);
        this.textAreaSegments.setMargin(new Insets(10, 10, 10, 10));
        try {
            this.fileType = previewListener.getParameters().getParameter("content_type");
        }
        catch (UndefinedParameterError e1) {
            this.fileType = null;
        }
        try {
            this.segmenter = DocumentSegmenterClass.getSegmenterFromParameters(previewListener.getParameters());
        }
        catch (UserError e1) {
            this.segmenter = null;
            this.textAreaOriginal.setText("The query expression is not well defined.");
        }
        File baseDir = null;
        try {
            baseDir = previewListener.getProcess().resolveFileName(previewListener.getParameters().getParameter("texts"));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isFile() && !f.isHidden();
            }
        });
        this.selectorList = files != null && files.length > 0 ? new JList<File>(files) : new JList();
        this.selectorList.setSelectionMode(0);
        this.selectorList.addListSelectionListener(this);
        JButton okButton = new JButton("Close");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                SegmenterPreviewer.this.dispose();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.gridy = -1;
        gbcLabel.fill = 2;
        gbcLabel.weightx = 1.0;
        gbcLabel.weighty = 0.0;
        gbcLabel.insets = new Insets(10, 10, 10, 10);
        JLabel label = new JLabel("Select a document");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.selectorList), gbc);
        label = new JLabel("Original text");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.textAreaOriginal), gbc);
        label = new JLabel("Extracted segments");
        label.setFont(label.getFont().deriveFont(1));
        this.getContentPane().add((Component)label, gbcLabel);
        this.getContentPane().add((Component)new JScrollPane(this.textAreaSegments), gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(7, 7, 7, 7);
        this.getContentPane().add((Component)okButton, gbc);
        this.setSize(Math.max(640, (int)(0.66 * (double)this.getOwner().getWidth())), Math.max(480, (int)(0.66 * (double)this.getOwner().getHeight())));
        this.setLocationRelativeTo(this.getOwner());
        if (files != null && files.length > 0) {
            this.selectorList.setSelectedIndex(0);
        } else {
            this.textAreaOriginal.setText(ERROR_MESSAGE);
        }
    }

    private void showSegments(File f) {
        StringBuffer originalText = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new FileReader(f));
            String buf = null;
            while ((buf = in.readLine()) != null) {
                originalText.append(buf);
                originalText.append('\n');
            }
            this.textAreaOriginal.setText(originalText.toString());
            this.textAreaOriginal.setCaretPosition(0);
            int type = this.fileType != null ? TextExtractionWrapper.determineType(this.fileType) : TextExtractionWrapper.determineType(f);
            StringBuffer segmentsText = new StringBuffer();
            Iterator<String> segments = this.segmenter.getSegments(f, type);
            while (segments.hasNext()) {
                segmentsText.append("\n-----------------\n");
                segmentsText.append(segments.next());
            }
            this.textAreaSegments.setText(segmentsText.toString());
            this.textAreaSegments.setCaretPosition(0);
        }
        catch (FileNotFoundException e) {
            this.textAreaOriginal.setText("Could not load text from " + f);
        }
        catch (IOException e) {
            this.textAreaOriginal.setText("Could not load text from " + f);
        }
        catch (ExtractionException e) {
            this.textAreaSegments.setText("Could not extract any segments from original: " + e);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        File f = (File)this.selectorList.getModel().getElementAt(this.selectorList.getSelectedIndex());
        if (f != null) {
            this.showSegments(f);
        } else {
            this.textAreaOriginal.setText(ERROR_MESSAGE);
        }
    }
}

