/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.renderer.cluster;

import com.rapidminer.gui.renderer.AbstractTableModelTableRenderer;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.clustering.CentroidClusterModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class ClusterModelCentroidTableRenderer
extends AbstractTableModelTableRenderer {
    public TableModel getTableModel(Object renderable, IOContainer ioContainer) {
        CentroidClusterModel clusterModel = (CentroidClusterModel)renderable;
        if (clusterModel != null) {
            return new CentroidTableModel(clusterModel);
        }
        return null;
    }

    public String getName() {
        return "Centroid Table";
    }

    public boolean isAutoresize() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CentroidTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2196512073454635516L;
        private CentroidClusterModel model;

        public CentroidTableModel(CentroidClusterModel model) {
            this.model = model;
        }

        @Override
        public int getColumnCount() {
            return this.model.getNumberOfClusters() + 1;
        }

        @Override
        public int getRowCount() {
            return this.model.getAttributeNames().length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.model.getAttributeNames()[rowIndex];
            }
            return this.model.getCentroid(columnIndex - 1).getCentroid()[rowIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Double.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Attribute";
            }
            return "cluster_" + this.model.getCluster(columnIndex - 1).getClusterId();
        }
    }
}

