/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import be.ac.ulg.montefiore.run.jahmm.CentroidObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationVector
extends Observation
implements Cloneable,
CentroidFactory<ObservationVector> {
    final double[] value;

    public ObservationVector(int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException("Dimension must be strictly positive");
        }
        this.value = new double[dimension];
    }

    public ObservationVector(double[] value) {
        this(value.length);
        int i = 0;
        while (i < value.length) {
            this.value[i] = value[i];
            ++i;
        }
    }

    public int dimension() {
        return this.value.length;
    }

    public double[] values() {
        return (double[])this.value.clone();
    }

    public double value(int i) {
        return this.value[i];
    }

    @Override
    public Centroid<ObservationVector> factor() {
        return new CentroidObservationVector(this);
    }

    public ObservationVector plus(ObservationVector o) {
        if (this.dimension() != o.dimension()) {
            throw new IllegalArgumentException();
        }
        ObservationVector s = new ObservationVector(this.dimension());
        int i = 0;
        while (i < this.dimension()) {
            s.value[i] = this.value[i] + o.value[i];
            ++i;
        }
        return s;
    }

    public ObservationVector times(double c) {
        ObservationVector p = this.clone();
        int i = 0;
        while (i < this.dimension()) {
            int n = i++;
            p.value[n] = p.value[n] * c;
        }
        return p;
    }

    public ObservationVector minus(ObservationVector o) {
        if (this.dimension() != o.dimension()) {
            throw new IllegalArgumentException();
        }
        ObservationVector d = new ObservationVector(this.dimension());
        int i = 0;
        while (i < this.dimension()) {
            d.value[i] = this.value[i] - o.value[i];
            ++i;
        }
        return d;
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String s = "[";
        int i = 0;
        while (i < this.value.length) {
            s = String.valueOf(s) + " " + numberFormat.format(this.value[i]);
            ++i;
        }
        return String.valueOf(s) + " ]";
    }

    public ObservationVector clone() {
        return new ObservationVector(this.value);
    }
}

