/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.data;

import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.http.conn.ConnectTimeoutException;
import org.gcube.common.Utils;
import org.gcube.common.data.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordIterator
implements Iterator<Record> {
    private static Logger log = LoggerFactory.getLogger(RecordIterator.class);
    private int completeListSize;
    private String percentage;
    private String resumptionToken;
    private String from;
    private String until;
    private String set;
    private String metadataPrefix;
    private String baseUrl;
    private boolean hasResumptionToken;
    private Iterator<OMElement> getRecords;
    private OMElement documentElement = null;
    private OMElement elementType = null;
    Record record = null;

    public RecordIterator(String resumptionToken, String from, String until, String set, String metadataPrefix, String baseUrl) throws Exception {
        this.resumptionToken = resumptionToken;
        this.set = set;
        this.from = from;
        this.until = until;
        this.metadataPrefix = metadataPrefix == null ? "oai_dc" : metadataPrefix;
        this.baseUrl = baseUrl;
        Object documentElement = null;
        this.hasResumptionToken = false;
        this.getUrl();
    }

    private void getUrl() throws Exception {
        try {
            if (this.resumptionToken.isEmpty()) {
                if (this.from == null && this.until == null && this.set == null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix);
                } else if (this.from != null && this.until == null && this.set == null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&from=" + this.from);
                } else if (this.from == null && this.until != null && this.set == null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&until=" + this.from);
                } else if (this.from == null && this.until == null && this.set != null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&set=" + this.set);
                } else if (this.from != null && this.until != null && this.set == null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&from=" + this.from + "&until=" + this.until);
                } else if (this.from != null && this.until != null && this.set != null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&from=" + this.from + "&until=" + this.until + "&set=" + this.set);
                } else if (this.from == null && this.until != null && this.set != null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&until=" + this.until + "&set=" + this.set);
                } else if (this.from != null && this.until == null && this.set != null) {
                    this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&metadataPrefix=" + this.metadataPrefix + "&from=" + this.from + "&set=" + this.set);
                }
            } else {
                this.documentElement = Utils.getReaderFromHttpGet(this.baseUrl, "ListRecords&resumptionToken=" + URLEncoder.encode(this.resumptionToken, "UTF-8"));
            }
        }
        catch (ConnectTimeoutException e) {
            log.error("Connection timed out, retry to connect", (Throwable)e);
            this.getUrl();
        }
        catch (Exception e) {
            log.error("Opening http url ", (Throwable)e);
        }
        Iterator getListRecords = this.documentElement.getChildrenWithName(new QName("http://www.openarchives.org/OAI/2.0/", "ListRecords"));
        if (getListRecords.hasNext()) {
            this.getRecords = ((OMElement)getListRecords.next()).getChildElements();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.getRecords != null && this.getRecords.hasNext()) {
            this.elementType = this.getRecords.next();
            if (this.elementType.getLocalName().equals("resumptionToken")) {
                this.hasResumptionToken = true;
                this.resumptionToken = this.elementType.getText();
                int cursor = 0;
                this.completeListSize = 0;
                Iterator metadataPrefix = this.elementType.getAllAttributes();
                while (metadataPrefix.hasNext()) {
                    OMAttribute prefixElement = (OMAttribute)metadataPrefix.next();
                    if (prefixElement.getLocalName().equals("cursor")) {
                        cursor = Integer.parseInt(prefixElement.getAttributeValue());
                        continue;
                    }
                    if (!prefixElement.getLocalName().equals("completeListSize")) continue;
                    this.completeListSize = Integer.parseInt(prefixElement.getAttributeValue());
                }
                if (cursor != 0 && this.completeListSize != 0) {
                    this.percentage = this.getPercentage(cursor, this.completeListSize);
                    log.trace("Delivered " + this.percentage + "% records for " + this.baseUrl);
                } else {
                    log.trace("Already delivered " + cursor + "/" + this.completeListSize + " records for " + this.baseUrl);
                }
                return this.resumptionToken.length() > 0;
            }
            return true;
        }
        return false;
    }

    private String getPercentage(double cursor, double completeListSize2) {
        double percentuage = cursor * 100.0 / completeListSize2;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        String s = nf.format(percentuage);
        return s;
    }

    @Override
    public Record next() {
        try {
            if (this.elementType.getLocalName().equals("record")) {
                this.record = Utils.getRecord(this.elementType);
                this.record.setMetadataPrefix(this.metadataPrefix);
            } else if (this.elementType.getLocalName().equals("resumptionToken")) {
                this.iterator();
                if (this.hasNext()) {
                    this.next();
                }
            }
        }
        catch (OMException e) {
            log.error("Error getting next record ", (Throwable)e);
        }
        return this.record;
    }

    private RecordIterator iterator() {
        try {
            this.getUrl();
        }
        catch (Exception e) {
            log.error("Error opening new url ", (Throwable)e);
        }
        return this;
    }

    @Override
    public void remove() {
    }

    public int getCompleteListSize() {
        return this.completeListSize;
    }

    public String getPercentage() {
        return this.percentage;
    }
}

