/**
 * University of Illinois/NCSA Open Source License
 *
 * Copyright (c) 2001,2002 The Board of Trustees of the University of Illinois
 * All rights reserved.
 *
 * Developed by:  Open Archives Initiative Metadata Harvesting Project
 *                University of Illinois at Urbana-Champaign
 *                http://oai.grainger.uiuc.edu/
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal with the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 *  . Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimers.
 *  . Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimers in the
 *    documentation and/or other materials provided with the distribution.
 *  . Neither the names of Open Archives Initiative Metadata Harvesting
 *    Project, University of Illinois at Urbana-Champaign, nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this Software without specific prior written permission.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS WITH THE SOFTWARE.
 *
 * DC.Title:          OAIMetadataFormat
 * 
 * DC.Description:    Class representing an OAI MetadataFormat
 * 
 * DC.Contributor:    Yuping Tseng, ytseng1@uiuc.edu, University og Illinois at Urbana-Champaign
 * DC.Contributor:    Tom Habing, thabing@uiuc.edu, University of Illinois at Urbana-Champaign
 * 
 * DC:Rights:         University of Illinois/NCSA Open Source License 
 *  
 * DC.Relation:       For more information see http://oai.grainger.uiuc.edu/
 * 
 */
package org.gcube.common;

/**
 * This class represents an OAI Metadata Format.
 *
 * This object is returned by the OAIMetadataFormatList.getCurrentItem() method.
 */
public class OAIMetadataFormat {

 /**
  * Constructs an empty OAI metadata format
  */
 public OAIMetadataFormat() {
  boolValid = true;
 }


 /**
  * Returns true if the record list appears to be valid (well-formed, and if the Validation if Very Strict also valid according 
  *  to the XML Schemas); if the Validation is Loose and the record is not well-formed, false is returned. 
  */
 public boolean isMetadataFormatValid() {
   return boolValid;
 }

 protected void frndSetValid(boolean b) {
   boolValid = b;
 }

 /**
  * Returns the XML namespace of this metadata format.
  */
 public String getMetadataNamespace() {
   return strMetadataNamespace;
 }

 /**
  * Returns the prefix used for this metadata format. 
  */
 public String getMetadataPrefix() {
   return strMetadataPrefix;
 }

 /**
  * Returns the URL of the XML schema for this metadata format 
  */
 public String getSchema() {
   return strSchema;
 }

 protected void frndSetMetadataNamespace(String mn) {
   strMetadataNamespace = mn;
 }

 protected void frndSetMetadataPrefix(String mp) {
   strMetadataPrefix = mp;
 }

 protected void frndSetSchema(String s) {
   strSchema = s;
 }

 private String strMetadataPrefix;
 private String strSchema;
 private String strMetadataNamespace;
 private boolean boolValid;
}
