/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.home.workspace.acl.Capabilities;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WorkspaceFolderNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.WrongDestinationException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.resolver.UriResolverReaderParameter;
import org.gcube.common.homelibrary.jcr.shortner.UrlShortener;
import org.gcube.common.homelibrary.jcr.workspace.JCRAbstractWorkspaceFolder;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRAccessManager;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryAddACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryCreate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDelete;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryDeleteACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryModifyACL;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryPaste;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRenaming;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryRestore;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryShare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUnshare;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntryUpdate;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryAdd;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryCut;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingFolderEntryRemoval;
import org.gcube.common.homelibrary.jcr.workspace.lock.JCRLockManager;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRServlets;
import org.gcube.common.homelibrary.jcr.workspace.usermanager.JCRUserManager;
import org.gcube.common.homelibrary.jcr.workspace.util.HttpRequestUtil;
import org.gcube.common.homelibrary.jcr.workspace.util.StringUtil;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JCRWorkspaceItem
implements WorkspaceItem {
    protected JCRWorkspace workspace;
    public ItemDelegate delegate;
    private ItemDelegate parentDelegate;
    protected static Logger logger = LoggerFactory.getLogger(JCRWorkspaceItem.class);

    public JCRWorkspaceItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        this.workspace = workspace;
        this.delegate = delegate;
    }

    public JCRWorkspaceItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description) throws RepositoryException {
        Validate.notNull((Object)name, (String)"Name must be not null");
        Validate.notNull((Object)description, (String)"Description must be not null");
        this.workspace = workspace;
        this.delegate = delegate;
        delegate.setLastModifiedBy(workspace.getOwner().getPortalLogin());
        delegate.setDescription(description);
        delegate.setTitle(name);
        delegate.setLastAction(WorkspaceItemAction.CREATED);
        delegate.setOwner(workspace.getOwner().getPortalLogin());
        delegate.setProperties(new HashMap());
        delegate.setContent(new HashMap());
    }

    public String getId() throws InternalErrorException {
        return this.delegate.getId();
    }

    public User getOwner() {
        return new JCRUser("", this.delegate.getOwner());
    }

    public String getName() throws InternalErrorException {
        return this.delegate.getTitle();
    }

    public String getDescription() throws InternalErrorException {
        return this.delegate.getDescription();
    }

    public Calendar getCreationTime() throws InternalErrorException {
        return this.delegate.getCreationTime();
    }

    public Calendar getLastModificationTime() throws InternalErrorException {
        return this.delegate.getLastModificationTime();
    }

    public WorkspaceItemAction getLastAction() throws InternalErrorException {
        return this.delegate.getLastAction();
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public Properties getProperties() throws InternalErrorException {
        try {
            return new JCRProperties(this.delegate, this.workspace.getOwner().getPortalLogin());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String getPath() throws InternalErrorException {
        try {
            return this.getPath(this.delegate);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    protected String getPath(ItemDelegate item) throws InternalErrorException, RepositoryException {
        String nodePath = item.getPath();
        if (nodePath.contains("/Home/" + this.getOwner() + "/Workspace/Trash/")) {
            String path = nodePath.replace("/Home/" + this.getOwner() + "/Workspace/Trash/", "");
            String id = path.substring(path.indexOf(47) + 1);
            return "/Trash/" + id;
        }
        if (item.getId().equals(this.workspace.getRoot().getId())) {
            return this.workspace.getPathSeparator() + this.delegate.getTitle();
        }
        if (!item.isShared() && !nodePath.startsWith("/Share/")) {
            return this.workspace.getRelativePath(item.getPath());
        }
        JCRAbstractWorkspaceFolder folder = this.getParent(item);
        String path = folder.getPath() + this.workspace.getPathSeparator() + this.delegate.getTitle();
        return path;
    }

    public boolean isRoot() throws InternalErrorException {
        return this.getParent() == null;
    }

    public String getIdSharedFolder() throws InternalErrorException {
        return (String)this.delegate.getProperties().get(NodeProperty.SHARED_ROOT_ID);
    }

    public ItemDelegate save() throws RepositoryException {
        ItemDelegate item = null;
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            item = servlets.saveItem(this.delegate);
            if (item != null) {
                this.delegate.setId(item.getId());
                this.delegate.setPath(item.getPath());
                this.delegate.setCreationTime(item.getCreationTime());
                this.delegate.setLastModificationTime(item.getLastModificationTime());
                this.delegate.setProperties(item.getProperties());
            }
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        finally {
            servlets.releaseSession();
        }
        return item;
    }

    public void setDescription(String description) throws InternalErrorException {
        try {
            this.internalDescription(description);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void rename(String name) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.renameItem(this.getId(), name);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccountingEntry> getAccounting() {
        ArrayList<AccountingEntry> list = new ArrayList<AccountingEntry>();
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            JCRAccountingEntryCreate entry = new JCRAccountingEntryCreate(this.getId(), this.getOwner().getPortalLogin(), this.getCreationTime(), this.delegate.getTitle());
            list.add(entry);
            List<AccountingDelegate> accountingNode = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entryNode : accountingNode) {
                try {
                    switch (entryNode.getEntryType()) {
                        case CUT: {
                            list.add(new JCRAccountingFolderEntryCut(entryNode));
                            break;
                        }
                        case PASTE: {
                            list.add(new JCRAccountingEntryPaste(entryNode));
                            break;
                        }
                        case REMOVAL: {
                            list.add(new JCRAccountingFolderEntryRemoval(entryNode));
                            break;
                        }
                        case RENAMING: {
                            list.add(new JCRAccountingEntryRenaming(entryNode));
                            break;
                        }
                        case ADD: {
                            list.add(new JCRAccountingFolderEntryAdd(entryNode));
                            break;
                        }
                        case UPDATE: {
                            list.add(new JCRAccountingEntryUpdate(entryNode));
                            break;
                        }
                        case READ: {
                            list.add(new JCRAccountingEntryRead(entryNode));
                            break;
                        }
                        case SHARE: {
                            list.add(new JCRAccountingEntryShare(entryNode));
                            break;
                        }
                        case UNSHARE: {
                            list.add(new JCRAccountingEntryUnshare(entryNode));
                            break;
                        }
                        case DELETE: {
                            list.add(new JCRAccountingEntryDelete(entryNode));
                            break;
                        }
                        case RESTORE: {
                            list.add(new JCRAccountingEntryRestore(entryNode));
                            break;
                        }
                        case ADD_ACL: {
                            list.add(new JCRAccountingEntryAddACL(entryNode));
                            break;
                        }
                        case MODIFY_ACL: {
                            list.add(new JCRAccountingEntryModifyACL(entryNode));
                            break;
                        }
                        case DELETE_ACL: {
                            list.add(new JCRAccountingEntryDeleteACL(entryNode));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Accounting entry skipped " + entryNode.getEntryType().toString(), (Throwable)e);
                }
            }
            ArrayList<AccountingEntry> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            logger.error("Error to retrieve accounting entries ", (Throwable)e);
            ArrayList<AccountingEntry> arrayList = list;
            return arrayList;
        }
        finally {
            servlets.releaseSession();
        }
    }

    public JCRAbstractWorkspaceFolder getParent() throws InternalErrorException {
        try {
            return this.workspace.getParent(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isShared() throws InternalErrorException {
        return this.getType().equals((Object)WorkspaceItemType.SHARED_FOLDER) || this.delegate.getProperties().containsKey(NodeProperty.SHARED_ROOT_ID);
    }

    protected JCRAbstractWorkspaceFolder getParent(ItemDelegate node) throws InternalErrorException {
        try {
            return this.workspace.getParent(node);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public boolean isRoot(ItemDelegate delegate) throws RepositoryException, InternalErrorException {
        return this.getParentDelegate() == null;
    }

    public ItemDelegate getParentDelegate() throws InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            if (this.parentDelegate == null) {
                this.parentDelegate = servlets.getItemById(this.delegate.getParentId());
            }
        }
        catch (ItemNotFoundException | RepositoryException e) {
            throw new InternalErrorException(e);
        }
        finally {
            servlets.releaseSession();
        }
        return this.parentDelegate;
    }

    public ItemDelegate getDelegate() throws InternalErrorException {
        return this.delegate;
    }

    public void remove() throws InternalErrorException, InsufficientPrivilegesException {
        block13: {
            JCRLockManager lm = null;
            JCRServlets servlets = null;
            try {
                servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
                lm = servlets.getLockManager();
                if (!lm.isLocked(this.getId())) {
                    lm.lockItem(this.getId());
                    logger.trace("Moving to trash: " + this.delegate.getPath());
                    this.workspace.moveToTrash(servlets, this);
                    try {
                        JCRAccountingFolderEntryRemoval entry = new JCRAccountingFolderEntryRemoval(this.delegate.getParentId(), this.getOwner().getPortalLogin(), Calendar.getInstance(), this.getType(), this.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)this).getFolderItemType() : null, this.getName(), this.getType() == WorkspaceItemType.FOLDER_ITEM ? ((FolderItem)this).getMimeType() : null);
                        entry.save(servlets);
                    }
                    catch (Exception e) {
                        logger.error("Impossible to set Removal Accounting Entry to parent of " + this.delegate.getPath());
                    }
                    break block13;
                }
                throw new InternalErrorException("LockException: Node locked.");
            }
            catch (RepositoryException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (RemoteBackendException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WrongDestinationException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (ItemAlreadyExistException e) {
                throw new InternalErrorException((Throwable)e);
            }
            catch (WorkspaceFolderNotFoundException e) {
                throw new InternalErrorException((Throwable)e);
            }
            finally {
                lm.unlockItem(this.getId());
                servlets.releaseSession();
            }
        }
    }

    public void move(WorkspaceFolder destination) throws InternalErrorException, WrongDestinationException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            this.workspace.moveItem(this.getId(), destination.getId());
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceItem cloneItem(String cloneName) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        try {
            return this.workspace.cloneItem(this.getId(), cloneName);
        }
        catch (ItemNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WrongDestinationException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (WorkspaceFolderNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public ItemDelegate internalCopy(JCRServlets servlets, ItemDelegate nodeFolder, String newName) throws InternalErrorException, ItemAlreadyExistException, WrongDestinationException, RepositoryException {
        String pathNewNode = null;
        try {
            pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
            if (this.workspace.exists(Text.escapeIllegalJcrChars((String)newName), nodeFolder.getId())) {
                try {
                    WorkspaceFolder destinationFolder = (WorkspaceFolder)this.workspace.getWorkspaceItem(nodeFolder);
                    newName = destinationFolder.getUniqueName(newName, true);
                    pathNewNode = nodeFolder.getPath() + this.workspace.getPathSeparator() + Text.escapeIllegalJcrChars((String)newName);
                }
                catch (Exception e) {
                    logger.trace("impossible to convert item in WorkspaceItem");
                }
            }
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        try {
            servlets.copy(this.delegate.getPath(), pathNewNode);
            ItemDelegate newNode = servlets.getItemByPath(pathNewNode);
            newNode.setLastModificationTime(Calendar.getInstance());
            newNode.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            newNode.setTitle(Text.unescapeIllegalJcrChars((String)newName));
            newNode.setLastAction(WorkspaceItemAction.CLONED);
            servlets.saveItem(newNode);
            return newNode;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalMove(JCRServlets servlets, ItemDelegate destinationFolderNode, String remotePath) throws ItemAlreadyExistException, InternalErrorException, RepositoryException {
        try {
            logger.debug("Start internal move item with id " + this.getId() + " to destination item with id " + destinationFolderNode.getId());
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.MOVED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                try {
                    this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
                catch (Exception e1) {
                    logger.error("Remote path property is not in " + this.delegate.getPath());
                }
            }
            servlets.saveItem(this.delegate);
            servlets.move(this.delegate.getPath(), destinationFolderNode.getPath() + this.workspace.getPathSeparator() + this.delegate.getName());
        }
        catch (Exception e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalRename(JCRServlets servlets, String newName, String remotePath) throws ItemAlreadyExistException, InternalErrorException {
        String nodeNewName = Text.escapeIllegalJcrChars((String)newName);
        try {
            logger.debug("Internal rename item with id " + this.getId() + " to destination item with id " + this.delegate.getParentId());
            ItemDelegate parent = servlets.getItemById(this.delegate.getParentId());
            String newPath = parent.getPath() + this.workspace.getPathSeparator() + nodeNewName;
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            this.delegate.setLastAction(WorkspaceItemAction.RENAMED);
            try {
                this.delegate.getContent().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
            }
            catch (Exception e) {
                logger.info("remotePath will not be updated for item " + this.delegate.getPath());
            }
            this.delegate.setTitle(nodeNewName);
            try {
                servlets.move(this.delegate.getPath(), newPath);
                ItemDelegate modified = servlets.saveItem(this.delegate);
            }
            catch (Exception e) {
                logger.error("Impossible to save " + this.delegate.getPath() + ", " + e.toString());
                throw new InternalErrorException((Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Repository exception thrown by move operation", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void internalDescription(String newDescription) throws InternalErrorException {
        Validate.notNull((Object)newDescription, (String)"Description must be not null");
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            this.delegate.setDescription(newDescription);
            this.delegate.setLastModificationTime(Calendar.getInstance());
            this.delegate.setLastModifiedBy(this.workspace.getOwner().getPortalLogin());
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public boolean isMarkedAsRead() throws InternalErrorException {
        try {
            return this.hasReaders();
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasReaders() throws RepositoryException, InternalErrorException {
        JCRServlets servlets = null;
        int count = 0;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            List<AccountingDelegate> accounting = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entry : accounting) {
                if (!entry.equals((Object)AccountingEntryType.READ)) continue;
                ++count;
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.info("Node READERS has been added to " + this.delegate.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            servlets.releaseSession();
        }
        return false;
    }

    public List<AccountingEntryRead> getReaders() throws InternalErrorException {
        ArrayList<AccountingEntryRead> list = new ArrayList<AccountingEntryRead>();
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            List<AccountingDelegate> accountingNode = servlets.getAccountingById(this.getId());
            for (AccountingDelegate entry : accountingNode) {
                try {
                    if (!entry.equals((Object)AccountingEntryType.READ)) continue;
                    list.add(new JCRAccountingEntryRead(entry));
                }
                catch (Exception e) {
                    logger.info("Node ACCOUNTING not found");
                }
            }
            ArrayList<AccountingEntryRead> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public void setShareHistory(JCRServlets servlet, List<String> users, String author) throws InternalErrorException {
        try {
            this.setShare(servlet, users, author);
            this.setHistoryShareUnshare(servlet, this, AccountingEntryType.SHARE.getNodeTypeDefinition(), author, users);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setHistoryShareUnshare(JCRServlets servlet, WorkspaceItem item, String operation, String user, List<String> members) throws RepositoryException, InternalErrorException, ItemNotFoundException {
        for (WorkspaceItem child : item.getChildren()) {
            try {
                if (child.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM) || child.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                    if (operation.equals(AccountingEntryType.UNSHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)child).setUnshare(servlet, user);
                    } else if (operation.equals(AccountingEntryType.SHARE.getNodeTypeDefinition())) {
                        ((JCRWorkspaceItem)child).setShare(servlet, members, user);
                    }
                }
            }
            catch (Exception e) {
                throw new ItemNotFoundException(e.getMessage());
            }
            if (child.getChildren().size() <= 0) continue;
            this.setHistoryShareUnshare(servlet, child, operation, user, members);
        }
    }

    public void setUnshareHistory(JCRServlets servlets, String user) throws InternalErrorException {
        this.setUnshare(servlets, user);
        try {
            this.setHistoryShareUnshare(servlets, this, AccountingEntryType.UNSHARE.getNodeTypeDefinition(), user, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setShare(JCRServlets servlets, List<String> users, String author) throws InternalErrorException {
        logger.info("Add SHARE operation for user " + author + " to node " + this.delegate.getPath());
        try {
            JCRAccountingEntryShare entry = new JCRAccountingEntryShare(this.getId(), author, Calendar.getInstance(), this.getName(), users);
            entry.save(servlets);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setUnshare(JCRServlets servlets, String user) throws InternalErrorException {
        logger.info("Add UNSHARE operation for user " + user + " on item " + this.delegate.getPath());
        try {
            JCRAccountingEntryUnshare entry = new JCRAccountingEntryUnshare(this.getId(), user, Calendar.getInstance(), this.getName());
            entry.save(servlets);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void markAsRead(boolean read) throws InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            logger.info("Mark Node " + this.delegate.getPath() + " As Read ");
            String user = this.workspace.getOwner().getPortalLogin();
            if (read) {
                logger.info("Setting " + this.delegate.getTitle() + " as read in " + this.delegate.getPath());
                JCRAccountingEntryRead entry = new JCRAccountingEntryRead(this.getId(), user, Calendar.getInstance(), this.getName());
                entry.save(servlets);
                try {
                    logger.info("Mark Parent of Node " + this.delegate.getPath() + " As Read ");
                    JCRAccountingEntryRead entryParent = new JCRAccountingEntryRead(this.delegate.getParentId(), user, Calendar.getInstance(), this.delegate.getTitle());
                    entryParent.save(servlets);
                }
                catch (Exception e) {
                    logger.info("Error setting " + this.delegate.getTitle() + " as read in parent node");
                }
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public String getRemotePath() throws InternalErrorException {
        return (String)this.delegate.getContent().get(NodeProperty.REMOTE_STORAGE_PATH);
    }

    public void setRemotePath(JCRServlets servlets, String remotePath) throws InternalErrorException, RepositoryException {
        try {
            try {
                Map contentNode = this.delegate.getContent();
                if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                    contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
            }
            catch (Exception e) {
                try {
                    this.delegate.getProperties().put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                }
                catch (Exception e1) {
                    throw new InternalErrorException((Throwable)e1);
                }
            }
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setOwnerToCurrentUser(WorkspaceItem item) throws Exception {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            if (item.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM) || item.getType().equals((Object)WorkspaceItemType.FOLDER)) {
                ItemDelegate itemUnshared = servlets.getItemById(item.getId());
                itemUnshared.setOwner(this.workspace.getOwner().getPortalLogin());
                servlets.saveItem(itemUnshared);
            }
            List children = null;
            try {
                children = item.getChildren();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (children != null) {
                for (WorkspaceItem child : children) {
                    this.setOwnerToCurrentUser(child);
                }
            }
        }
        catch (InternalErrorException e1) {
            throw new InternalErrorException((Throwable)e1);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public List<String> getUsers() throws InternalErrorException {
        Map users = (Map)new XStream().fromXML((String)this.delegate.getProperties().get(NodeProperty.USERS));
        return new ArrayList<String>(users.keySet());
    }

    public boolean isFolder() throws InternalErrorException {
        return this.getType().equals((Object)WorkspaceItemType.FOLDER) || this.getType().equals((Object)WorkspaceItemType.SHARED_FOLDER);
    }

    public String getStorageID() throws InternalErrorException {
        logger.info("get Storage ID for item: " + this.getName());
        FolderItem folderItem = (FolderItem)this;
        String storageId = null;
        try {
            storageId = this.workspace.getStorage().getStorageId(folderItem.getRemotePath());
        }
        catch (Exception e) {
            throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
        }
        return storageId;
    }

    public String getPublicLink(boolean shortenUrl) throws InternalErrorException {
        logger.info("get PublicLink for item: " + this.getName());
        String publicLink = null;
        if (this.getType().equals((Object)WorkspaceItemType.FOLDER_ITEM)) {
            FolderItem folderItem = (FolderItem)this;
            try {
                publicLink = this.getPubliLinkForFolderItem(folderItem);
            }
            catch (Exception e) {
                throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
            }
        } else {
            logger.warn("ItemId: " + this.getId() + " is not a folder item, sent exception Public Link  unavailable");
            throw new InternalErrorException("Sorry, Public Link for selected file is unavailable");
        }
        return publicLink;
    }

    private String getPubliLinkForFolderItem(FolderItem folderItem) throws InternalErrorException {
        return this.workspace.getStorage().getPublicLink(folderItem.getRemotePath());
    }

    public String getPublicLinkForFolderItemId(String smpUri, FolderItem folderItem, boolean shortenUrl) throws InternalErrorException {
        logger.trace("get Public Link ");
        try {
            if (smpUri == null || smpUri.isEmpty()) {
                throw new Exception("Sorry, public link on " + folderItem.getName() + " is not available");
            }
            UriResolverReaderParameter uriResolver = new UriResolverReaderParameter(ScopeProvider.instance.get());
            String uriRequest = "";
            if (uriResolver != null && uriResolver.isAvailable()) {
                String itemName = StringUtil.removeSpecialCharacters(folderItem.getName());
                uriRequest = uriResolver.resolveAsUriRequest(smpUri, itemName = StringUtil.replaceAllWhiteSpace(itemName, "_"), folderItem.getMimeType(), true);
                if (!HttpRequestUtil.urlExists(uriRequest + "&validation=true")) {
                    throw new InternalErrorException("Sorry, The Public Link for selected file is unavailable");
                }
                if (shortenUrl) {
                    uriRequest = this.getShortUrl(uriRequest);
                }
                return uriRequest;
            }
            throw new InternalErrorException("Sorry, The Uri resolver service is temporarily unavailable. Please try again later");
        }
        catch (Exception e) {
            logger.error("Error getPublicLinkForFolderItemId for item: " + folderItem.getId(), (Throwable)e);
            throw new InternalErrorException(e.getMessage());
        }
    }

    public String getShortUrl(String longUrl) throws Exception {
        logger.trace("get short url for " + longUrl);
        UrlShortener shortener = new UrlShortener(ScopeProvider.instance.get());
        try {
            if (shortener != null && shortener.isAvailable()) {
                return shortener.shorten(longUrl);
            }
            return longUrl;
        }
        catch (Exception e) {
            logger.error("Error get short url for ", (Throwable)e);
            return longUrl;
        }
    }

    public boolean isTrashed() throws InternalErrorException {
        return this.getPath().startsWith("/Trash/");
    }

    public String getAbsolutePath() throws InternalErrorException {
        logger.trace("Getting absolute path of: " + this.delegate.getTitle());
        JCRServlets servlets = null;
        String path = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            ItemDelegate node = servlets.getItemById(this.getId());
            path = node.getPath();
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
        return path;
    }

    public boolean hasAccessRight(String user, String absPath) throws InternalErrorException {
        List<String> privileges;
        Map<String, List<String>> map;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            map = accessManager.getDeniedMap(absPath);
        }
        catch (Exception e) {
            throw new InternalErrorException("Impossible to retrieve privileges");
        }
        return !map.containsKey(user) || !(privileges = map.get(user)).contains("jcr:read");
    }

    public void deleteACL(List<String> users) throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = new JCRAccessManager();
        try {
            absPath = this.getAbsolutePath();
            accessManager.deleteAces(absPath, users);
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
    }

    public String getLastUpdatedBy() throws InternalErrorException {
        List<AccountingEntry> accounting = null;
        String updatedBy = null;
        try {
            accounting = this.getAccounting();
            int size = accounting.size();
            if (size > 0) {
                updatedBy = accounting.get(size - 1).getUser();
            }
        }
        catch (Exception e) {
            throw new InternalErrorException("Impossible to retrieve Last Updated By");
        }
        return updatedBy;
    }

    public ACLType getACLUser() throws InternalErrorException {
        return this.getACLByUser(this.workspace.getOwner().getPortalLogin());
    }

    protected ACLType getACLByUser(String user) throws InternalErrorException {
        return JCRPrivilegesInfo.getACLByUser(user, this.getAbsolutePath());
    }

    public Map<ACLType, List<String>> getACLOwner() throws InternalErrorException {
        String absPath = null;
        JCRAccessManager accessManager = null;
        Map<String, List<String>> aclMap = null;
        HashMap<ACLType, List<String>> map = new HashMap<ACLType, List<String>>();
        try {
            accessManager = new JCRAccessManager();
            absPath = this.getAbsolutePath();
            aclMap = accessManager.getEACL(absPath);
            Set<String> keys = aclMap.keySet();
            for (final String user : keys) {
                JCRUserManager um = new JCRUserManager();
                GCubeGroup group = null;
                try {
                    group = um.getGroup(user);
                    if (group != null && group.getMembers().isEmpty()) continue;
                    ACLType aclType = WorkspaceUtil.getACLTypeByKey(aclMap.get(user));
                    List users = null;
                    try {
                        users = (List)map.get(aclType);
                        users.add(user);
                        map.put(aclType, users);
                    }
                    catch (Exception e) {
                        map.put(aclType, (List<String>)new ArrayList<String>(){
                            private static final long serialVersionUID = 1L;
                            {
                                this.add(user);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("an error occurred setting ACL on: " + absPath);
        }
        return map;
    }

    public void setHidden(Boolean flag) throws InternalErrorException {
        JCRServlets servlets = null;
        try {
            servlets = new JCRServlets(this.workspace.getOwner().getPortalLogin());
            this.delegate.setHidden(flag.booleanValue());
            servlets.saveItem(this.delegate);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }

    public boolean isHidden() throws InternalErrorException {
        return this.delegate.isHidden();
    }
}

