/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.repository.external;

import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.util.Utils;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCUBEStorage {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);
    IClient storage;
    String portalLogin;
    String callerScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GCUBEStorage(String portalLogin) {
        logger.trace("Calling GCUBEStorage from user: " + portalLogin);
        this.portalLogin = portalLogin;
        this.callerScope = ScopeProvider.instance.get();
        try {
            String scope = Utils.getRootScope(this.callerScope);
            ScopeProvider.instance.set(scope);
            logger.trace("GCUBE Storage scope : " + scope);
            this.getStorage();
            Handler.activateProtocol();
        }
        catch (Exception e) {
            logger.error("GCUBE Storage initialization failed", (Throwable)e);
        }
        finally {
            if (this.callerScope != null) {
                ScopeProvider.instance.set(this.callerScope);
            }
        }
    }

    public IClient getStorage() {
        if (this.storage == null) {
            this.storage = new StorageClient("org.gcube.portlets.user", JCRRepository.serviceName, this.portalLogin, AccessType.SHARED, this.callerScope, false).getClient();
        }
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putStream(InputStream is, String remotePath, String mimeType) throws RemoteBackendException, IOException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + remotePath);
        String storageId = null;
        try {
            storageId = this.getStorage().put(true, mimeType).LFile(is).RFile(remotePath);
        }
        catch (Exception e) {
            logger.error("GCUBE Storage error in putStream operation", (Throwable)e);
        }
        finally {
            if (is != null) {
                is.close();
                logger.trace("GCUBE Storage inputStream closed");
            }
        }
        return storageId;
    }

    public String putStream(String old_remotePath, String new_remotePath, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage -putStream - remotePath: " + new_remotePath);
        return this.getStorage().put(true, mimeType).LFile(old_remotePath).RFile(new_remotePath);
    }

    public long getRemoteFileSize(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        long size = this.getStorage().getSize().RFile(remotePath);
        return size;
    }

    public void removeRemoteFile(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - removeRemoteFile - remotePath: " + remotePath);
        this.getStorage().remove().RFile(remotePath);
    }

    public long getRemoteFileSize(String remotePath, String serviceName) throws RemoteBackendException {
        logger.trace("GCUBE Storage getRemoteFileSize - storage.getSize().RFile(" + remotePath + ")");
        return this.getStorage().getSize().RFile(remotePath);
    }

    public long getDiskUsageByUser() throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume used by user: " + this.portalLogin + "");
        return Long.parseLong(this.getStorage().getTotalUserVolume());
    }

    public int getTotalItemsByUser() throws RemoteBackendException {
        logger.trace("GCUBE Storage - get tot items of user " + this.portalLogin + "");
        return Integer.parseInt(this.getStorage().getUserTotalItems());
    }

    public long getFolderTotalVolume(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return Long.parseLong(this.getStorage().getFolderTotalVolume().RDir(remotePath).toString());
    }

    public String getFolderLastUpdate(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return this.getStorage().getFolderLastUpdate().RDir(remotePath);
    }

    public int getFolderTotalItems(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - get volume (" + remotePath + ")");
        return Integer.parseInt(this.getStorage().getFolderTotalItems().RDir(remotePath).toString());
    }

    public InputStream getRemoteFile(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage -getRemoteFile - stream = storage.get().RFileAsInputStream(" + remotePath + ")");
        InputStream stream = null;
        stream = this.getStorage().get().RFileAsInputStream(remotePath);
        return stream;
    }

    public String getPublicLink(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        return this.getStorage().getHttpUrl().RFile(remotePath);
    }

    public String getStorageId(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - Generate Public Link for " + remotePath);
        MyFile file = this.getStorage().getMetaFile().RFile(remotePath);
        return file.getId();
    }

    public void moveRemoteFolder(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.moveDir().from(" + oldPath + ").to(" + newPath + ")");
        this.getStorage().moveDir().from(oldPath).to(newPath);
    }

    public void moveRemoteFile(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.moveFile().from(" + oldPath + ").to(" + newPath + ")");
        this.getStorage().moveFile().from(oldPath).to(newPath);
    }

    public void copyRemoteFile(String oldPath, String newPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.copyFile().from(" + oldPath + ").to(" + newPath + ")");
        this.getStorage().copyFile().from(oldPath).to(newPath);
    }

    public void createHardLink(String srcPath, String destPath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.linkFile().from(" + srcPath + ").to(" + destPath + ")");
        this.getStorage().linkFile().from(srcPath).to(destPath);
    }

    public void removeRemoteFolder(String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - storage.removeDir().RDir(" + remotePath + ")");
        this.getStorage().removeDir().RDir(remotePath);
    }

    public String putStream(InputStream is, String new_remotePath, String serviceName, String mimeType) throws RemoteBackendException {
        logger.trace("GCUBE Storage - putStream - remotePath: " + new_remotePath);
        this.getStorage().put(true, mimeType).LFile(is).RFile(new_remotePath);
        try {
            is.close();
            logger.trace("GCUBE Storage inputStream closed");
        }
        catch (IOException e) {
            logger.error("GCUBE Storage error during to close inputStream", (Throwable)e);
        }
        return this.getStorage().getUrl().RFile(new_remotePath);
    }

    public String getMetaInfo(String field, String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - getMetaInfo: field: " + field + "; remotePath: " + remotePath);
        return this.getStorage().getMetaInfo(field).RFile(remotePath);
    }

    public void setMetaInfo(String field, String value, String remotePath) throws RemoteBackendException {
        logger.trace("GCUBE Storage - getMetaInfo: field: " + field + "; remotePath: " + remotePath);
        this.getStorage().setMetaInfo(field, value).RFile(remotePath);
    }
}

