/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRProperties;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public abstract class JCRWorkspaceFolderItem
extends JCRWorkspaceItem
implements FolderItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String FOLDER_ITEM_TYPE = "hl:workspaceItemType";

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, ItemDelegate delegate) throws RepositoryException {
        super(workspace, delegate);
    }

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description) throws RepositoryException {
        super(workspace, delegate, name, description);
    }

    public JCRWorkspaceFolderItem(JCRWorkspace workspace, ItemDelegate delegate, String name, String description, Map<String, String> properties) throws RepositoryException {
        this(workspace, delegate, name, description);
        super.setMetadata(properties);
    }

    @Override
    public ItemDelegate save() throws RepositoryException {
        return super.save();
    }

    @Override
    public ItemDelegate save(InputStream is) throws RepositoryException {
        return super.save(is);
    }

    public WorkspaceItemType getType() {
        return WorkspaceItemType.FOLDER_ITEM;
    }

    public abstract FolderItemType getFolderItemType();

    public abstract long getLength() throws InternalErrorException;

    public abstract String getMimeType() throws InternalErrorException;

    public List<? extends WorkspaceItem> getChildren() throws InternalErrorException {
        return new ArrayList();
    }

    public void removeChild(WorkspaceItem child) {
    }

    @Override
    public Properties getProperties() throws InternalErrorException {
        try {
            return new JCRProperties(this.delegate, this.workspace.getOwner().getPortalLogin());
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void removeRemoteContent(Node node, WorkspaceItemType workspaceItemType) throws RepositoryException, RemoteBackendException {
        block5: {
            try {
                Node contentNode = node.getNode(CONTENT);
                if (!contentNode.hasProperty("hl:remotePath")) break block5;
                String remotePath = contentNode.getProperty("hl:remotePath").getString();
                try {
                    if (workspaceItemType == WorkspaceItemType.FOLDER) {
                        this.workspace.getStorage().removeRemoteFolder(remotePath);
                        break block5;
                    }
                    this.workspace.getStorage().removeRemoteFile(remotePath);
                }
                catch (Exception e) {
                    logger.warn(node.getName() + " payload not available", (Throwable)e);
                }
            }
            catch (javax.jcr.RepositoryException e) {
                logger.error("Content node jcr:content not found", (Throwable)e);
            }
        }
    }

    public void copyRemoteContent(JCRSession servlets, ItemDelegate node) throws RepositoryException, RemoteBackendException {
        try {
            Map contentNode = node.getContent();
            String remotePath = null;
            if (contentNode.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                remotePath = (String)contentNode.get(NodeProperty.REMOTE_STORAGE_PATH);
            } else if (contentNode.containsKey(NodeProperty.STORAGE_ID)) {
                remotePath = this.workspace.getStorage().getRemotePathByStorageId((String)contentNode.get(NodeProperty.STORAGE_ID));
            } else {
                throw new Exception("error performing copy (remotePath nor StorageId are set) ");
            }
            String newRemotePath = node.getPath();
            logger.debug("copy from remote path: " + remotePath + " to: " + newRemotePath);
            String storageId = this.workspace.getStorage().copyRemoteFile(remotePath, newRemotePath);
            contentNode.put(NodeProperty.REMOTE_STORAGE_PATH, newRemotePath);
            contentNode.put(NodeProperty.STORAGE_ID, storageId);
            logger.debug("copy from remote path: " + remotePath + " to: " + newRemotePath);
            node.setOwner(this.workspace.getOwner().getPortalLogin());
            contentNode.put(NodeProperty.DATA, Integer.toBinaryString(0));
            servlets.saveItem(node, true);
        }
        catch (Exception e) {
            logger.error("Content property jcr:content not found", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHardLink(ItemDelegate node, String hardLinkRemotePath) throws RepositoryException {
        logger.debug("hardLinkRemotePath: " + hardLinkRemotePath);
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            Map content = node.getContent();
            if (content.containsKey(NodeProperty.REMOTE_STORAGE_PATH)) {
                String remotePath = (String)content.get(NodeProperty.REMOTE_STORAGE_PATH);
                this.workspace.getStorage().createHardLink(remotePath, hardLinkRemotePath);
                content.put(NodeProperty.REMOTE_STORAGE_PATH, hardLinkRemotePath);
                servlets.saveItem(node, false);
            }
        }
        catch (Exception e) {
            logger.error("Content node jcr:content not found", (Throwable)e);
        }
        finally {
            servlets.releaseSession();
        }
    }
}

