/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface;

import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResourceControl {
    private static final Logger logger = LoggerFactory.getLogger(HttpResourceControl.class);

    public boolean isAvailableNetworkResource(String networkUrl, int trySleepTimeMs, int maxTry, String username, String password) {
        boolean find = false;
        int cont = 0;
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(networkUrl);
        if (username != null && password != null) {
            UsernamePasswordCredentials defaultCreds = new UsernamePasswordCredentials(username, password);
            httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)defaultCreds);
        }
        while (!find && cont < maxTry) {
            try {
                int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
                if (statusCode == 404) {
                    this.sleepAgain(cont++, networkUrl, trySleepTimeMs);
                }
                if (statusCode != 200) continue;
                find = true;
                logger.info("Found Network Resource..." + networkUrl);
            }
            catch (Exception e) {
                this.sleepAgain(cont++, networkUrl, trySleepTimeMs);
            }
        }
        getMethod.releaseConnection();
        if (!find) {
            logger.info("Exit... resource " + networkUrl + " not found");
            return false;
        }
        return true;
    }

    private void sleepAgain(int cont, String networkUrl, int trySleepTime) {
        logger.error("Exception - Try " + cont + " - network resource " + networkUrl + " not found ");
        try {
            logger.info("Wait " + trySleepTime + " ms");
            Thread.sleep(trySleepTime);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    public int failOverResource(ArrayList<String> listResourceUrl, int trySleepTime, int maxTry, String username, String password) {
        boolean isAvailableNetworkReosource = false;
        int index = 0;
        block0: while (!isAvailableNetworkReosource) {
            for (String url : listResourceUrl) {
                if (this.isAvailableNetworkResource(url, trySleepTime, maxTry, username, password)) {
                    isAvailableNetworkReosource = true;
                    continue block0;
                }
                ++index;
            }
        }
        if (index == listResourceUrl.size()) {
            return -1;
        }
        return index;
    }
}

