/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.discovery.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;

public class ResourceDiscoveryCacheManager {
    protected static Thread thread = new CleanQueriesThread();
    protected static ResourceDiscoveryCacheManager rdManager = new ResourceDiscoveryCacheManager();
    protected HashMap<String, List<DigitalObject>> queriesDocs = new HashMap();

    protected ResourceDiscoveryCacheManager() {
        thread.setDaemon(true);
        thread.start();
    }

    public static ResourceDiscoveryCacheManager getInstance() {
        return rdManager;
    }

    public List<DigitalObject> getPDFLocations(String mimeType, String searchTerm, ArrayList<String> collections) {
        String key = mimeType + "__" + searchTerm;
        for (int i = 0; i < collections.size(); ++i) {
            key = key + "__" + collections.get(i);
        }
        System.out.println("Asking for key: " + key);
        List<DigitalObject> pdfs = this.queriesDocs.get(key);
        if (pdfs == null) {
            return null;
        }
        return pdfs;
    }

    public void addPDFLocations(String searchTerm, String mimeType, ArrayList<String> collections, List<DigitalObject> pdfs) {
        String key = mimeType + "__" + searchTerm;
        for (int i = 0; i < collections.size(); ++i) {
            key = key + "__" + collections.get(i);
        }
        System.out.println("Caching results - the key is: " + key);
        this.queriesDocs.put(key, pdfs);
    }

    protected void finalize() throws Throwable {
        thread.interrupt();
        System.out.println(new Date(System.currentTimeMillis()) + " clean thread was interrupted");
        thread.join();
        System.out.println(new Date(System.currentTimeMillis()) + " clean thread was joint");
        super.finalize();
    }

    protected static class CleanQueriesThread
    extends Thread {
        protected CleanQueriesThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(86400000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    System.out.println(new Date(System.currentTimeMillis()) + " clean thread was interrupted (in clean thread)");
                    break;
                }
                Set<String> keys = ResourceDiscoveryCacheManager.rdManager.queriesDocs.keySet();
                Iterator<String> iter = keys.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block2;
                    String extSessionID = iter.next();
                    ResourceDiscoveryCacheManager.rdManager.queriesDocs.remove(extSessionID);
                }
                break;
            }
            System.out.println(new Date(System.currentTimeMillis()) + " clean thread was terminated");
        }
    }
}

