/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.search.library.model;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;
import java.net.URISyntaxException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.accesslogger.model.AdvancedSearchAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.BrowseAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.QuickSearchAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.SimpleSearchAccessLogEntry;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.NoSearchMasterEPRFoundException;
import org.gcube.application.framework.search.library.exception.QuerySubmissionSearchException;
import org.gcube.application.framework.search.library.exception.QuerySyntaxException;
import org.gcube.application.framework.search.library.exception.ReadingUserProfileException;
import org.gcube.application.framework.search.library.exception.SearchSystemPortRetrievalException;
import org.gcube.application.framework.search.library.exception.URIRetrievalFromISCacheException;
import org.gcube.application.framework.search.library.exception.gRS2CreationException;
import org.gcube.application.framework.search.library.impl.ResultSetConsumer;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.model.Criterion;
import org.gcube.application.framework.search.library.model.Field;
import org.gcube.application.framework.search.library.model.GeospatialInfo;
import org.gcube.application.framework.search.library.util.ArraysComparison;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.gcube.application.framework.search.library.util.Operator;
import org.gcube.application.framework.search.library.util.Order;
import org.gcube.application.framework.search.library.util.Point;
import org.gcube.application.framework.userprofiles.library.impl.UserProfile;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchResponse;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchSystemServicePortType;
import org.gcube.searchsystem.searchsystemservice.stubs.service.SearchMasterServiceAddressingLocator;
import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLRelation;
import search.library.util.cql.query.tree.GCQLSortNode;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

public class Query
implements Cloneable {
    private AccessLogger accessLogger = AccessLogger.getAccessLogger();
    protected List<Field> browsableFields;
    protected List<Criterion> criteria;
    protected List<Criterion> previousCriteria;
    protected boolean distinct = false;
    protected GeospatialInfo geospatialInfo;
    protected Operator operator;
    protected Order order;
    protected String queryDescription;
    protected List<String> languages;
    protected List<Field> searchableFields;
    protected String searchType = "noSearch";
    protected List<String> selectedCollections;
    private String sortBy;
    protected ResultSetConsumerI searchRSC = null;
    protected String queryString;
    protected String genericSearchType = "noSearch";
    protected final GCUBELog logger = new GCUBELog((Object)this);
    protected boolean setRelation;
    protected String relation;
    ArrayList<String> relationModifiers;
    ArrayList<String> indexModifiers;
    int selectedLanguage;
    private boolean semanticEnrichment = false;
    protected String browseBy;
    private String searchTerm = new String();
    private boolean ftsAvailable;
    List<Field> sortableFields;
    private GCQLNode previousQuery = null;
    private String previousQueryDescription = new String();
    protected static AtomicInteger SMid = new AtomicInteger();
    private String searchEPR;
    private String ftsId = new String();
    Field geoField;
    boolean hasResults = true;
    ArrayList<String> selectedPresentationFields;
    ArrayList<String> searchQueryTerms;
    private boolean rankingSupport = false;
    private boolean geoAvailable;

    public void setRanking(boolean rankSupport) {
        this.rankingSupport = rankSupport;
    }

    public void setHasResults(boolean existResults) {
        this.hasResults = existResults;
    }

    public boolean hasResults() {
        return this.hasResults;
    }

    public boolean isFtsAvailable() {
        this.logger.debug((Object)("Supports fts? -> " + this.ftsAvailable));
        return this.ftsAvailable;
    }

    public void setFtsAvailable(boolean ftsAvailable) {
        this.ftsAvailable = ftsAvailable;
    }

    public void setSemanticEnrichment(boolean semanticEnrichment) {
        this.semanticEnrichment = semanticEnrichment;
    }

    public boolean getSemanticEnrichment() {
        return this.semanticEnrichment;
    }

    public boolean isGeoAvailable() {
        return this.geoAvailable;
    }

    public void setGeoAvailable(boolean geoAvailable) {
        this.geoAvailable = geoAvailable;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        this.searchQueryTerms.clear();
    }

    public Query() {
        this.criteria = new ArrayList<Criterion>();
        this.previousCriteria = new ArrayList<Criterion>();
        this.operator = Operator.OR;
        this.selectedCollections = new ArrayList<String>();
        this.searchableFields = new ArrayList<Field>();
        this.browsableFields = new ArrayList<Field>();
        this.languages = new ArrayList<String>();
        this.order = Order.ASC;
        this.sortableFields = new ArrayList<Field>();
        this.sortBy = new String();
        this.browseBy = new String();
        this.selectedPresentationFields = new ArrayList();
        this.searchQueryTerms = new ArrayList();
    }

    public void addCriterion(Criterion criterion) {
        this.logger.debug((Object)("adding criterion id: " + criterion.getSearchFieldId() + " and value: " + criterion.getSearchFieldValue()));
        if (!(!criterion.getSearchFieldValue().contains(" ") || criterion.getSearchFieldValue().startsWith("\"") && criterion.getSearchFieldValue().endsWith("\""))) {
            String[] splitted = criterion.getSearchFieldValue().split(" ");
            for (int i = 0; i < splitted.length; ++i) {
                Criterion crit = new Criterion();
                crit.setSearchFieldId(criterion.getSearchFieldId());
                crit.setSearchFieldName(criterion.getSearchFieldName());
                crit.setSearchFieldValue(splitted[i]);
                this.criteria.add(crit);
                this.logger.debug((Object)("Criterion added: " + crit.getSearchFieldValue()));
            }
            return;
        }
        this.logger.debug((Object)("Criterion added: " + criterion.getSearchFieldValue()));
        this.criteria.add(criterion);
    }

    public void removeCriterion(int i) {
        this.criteria.remove(i);
    }

    public Query clone(boolean previous) {
        Query q = new Query();
        this.logger.debug((Object)("cloning - previous: " + previous));
        if (!previous) {
            String y;
            for (Criterion criterion : this.criteria) {
                q.criteria.add(criterion.clone());
            }
            for (String string : this.searchQueryTerms) {
                q.searchQueryTerms.add(new String(string));
            }
            for (String string : this.selectedCollections) {
                y = new String(string);
                q.selectedCollections.add(y);
            }
            for (Field field : this.searchableFields) {
                q.searchableFields.add(field.clone());
            }
            for (Field field : this.sortableFields) {
                q.sortableFields.add(field.clone());
            }
            for (Field field : this.browsableFields) {
                q.browsableFields.add(field.clone());
            }
            for (String string : this.selectedPresentationFields) {
                y = new String(string);
                q.selectedPresentationFields.add(y);
            }
            q.searchType = "noSearch";
            q.genericSearchType = "noSearch";
            q.ftsAvailable = this.ftsAvailable;
            q.geoAvailable = this.geoAvailable;
            q.semanticEnrichment = this.semanticEnrichment;
            for (int i = 0; i < this.languages.size(); ++i) {
                q.languages.add(new String(this.languages.get(i)));
            }
            q.selectedLanguage = this.selectedLanguage;
            this.previousQuery = null;
            this.previousQueryDescription = new String();
            q.ftsId = this.ftsId;
            q.rankingSupport = this.rankingSupport;
            if (this.geoField != null) {
                q.geoField = this.geoField.clone();
            }
        } else {
            String y;
            this.logger.debug((Object)("do i have criteria? : " + this.criteria.size() + " " + this.previousCriteria.size()));
            for (Criterion criterion : this.criteria) {
                this.logger.debug((Object)(criterion.getSearchFieldName() + " " + criterion.getSearchFieldValue()));
                if (criterion.getSearchFieldValue().equals("")) continue;
                q.previousCriteria.add(criterion.clone());
            }
            for (String string : this.selectedCollections) {
                y = new String(string);
                q.selectedCollections.add(y);
            }
            for (String string : this.selectedPresentationFields) {
                y = new String(string);
                q.selectedPresentationFields.add(y);
            }
            q.searchType = "previousSearch";
            q.genericSearchType = this.searchType;
            if (this.searchType.equals("simpleSearch")) {
                Criterion newCrit = new Criterion();
                newCrit.setSearchFieldId(this.ftsId);
                newCrit.setSearchFieldName("Any");
                newCrit.setSearchFieldValue(this.searchTerm);
                q.previousCriteria.add(newCrit);
            }
            for (Field field : this.searchableFields) {
                q.searchableFields.add(field.clone());
            }
            for (Field field : this.sortableFields) {
                q.sortableFields.add(field.clone());
            }
            for (Field field : this.browsableFields) {
                q.browsableFields.add(field.clone());
            }
            q.ftsAvailable = this.ftsAvailable;
            q.semanticEnrichment = this.semanticEnrichment;
            for (int i = 0; i < this.languages.size(); ++i) {
                q.languages.add(new String(this.languages.get(i)));
            }
            q.selectedLanguage = this.selectedLanguage;
            q.previousQuery = this.previousQuery;
            q.previousQueryDescription = new String(this.previousQueryDescription);
            q.ftsId = this.ftsId;
            if (this.geoField != null) {
                q.geoField = this.geoField.clone();
            }
        }
        q.distinct = this.distinct;
        if (this.geospatialInfo != null && this.geospatialInfo.getBounds() != null) {
            q.geospatialInfo = this.geospatialInfo.clone();
        }
        q.operator = this.operator;
        q.order = this.order;
        q.queryDescription = this.queryDescription;
        q.queryString = this.queryString;
        q.sortBy = new String(this.sortBy);
        q.browseBy = new String(this.browseBy);
        if (this.searchTerm != null) {
            q.searchTerm = new String(this.searchTerm);
        }
        return q;
    }

    public void setLanguage(int language) {
        this.selectedLanguage = language;
    }

    public void setPresentationFields(ArrayList<String> presentationFields) {
        this.selectedPresentationFields = presentationFields;
    }

    private void findAvailableLanguages(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        SearchHelper sh = new SearchHelper(session);
        CollectionInfo firstCol = null;
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            ArrayList<String> allLanguages = new ArrayList<String>();
            this.logger.debug((Object)"Finding Available Languages");
            this.logger.debug((Object)("The number of selected collections is: " + this.selectedCollections.size()));
            List<String> realCollections = this.getSelectedRealCollections(session);
            firstCol = sh.findCollectionInfo(realCollections.get(0));
            allLanguages.addAll(firstCol.getLanguages());
            this.logger.debug((Object)("initially languages are: " + allLanguages.size()));
            this.logger.debug((Object)("Real selected Collections: " + realCollections.size()));
            CollectionInfo col = null;
            for (int i = 1; i < realCollections.size(); ++i) {
                col = sh.findCollectionInfo(realCollections.get(i));
                ArrayList<String> colLanguages = col.getLanguages();
                for (int j = 0; j < firstCol.getLanguages().size(); ++j) {
                    if (colLanguages.contains(firstCol.getLanguages().get(j))) continue;
                    int ind = allLanguages.indexOf(firstCol.getLanguages().get(j));
                    if (ind >= 0) {
                        allLanguages.remove(ind);
                        continue;
                    }
                    this.logger.debug((Object)("Element: " + firstCol.getLanguages().get(j) + "wasn't found in allLanguages collection!"));
                }
            }
            this.languages.clear();
            this.languages = allLanguages;
        } else {
            this.languages.clear();
        }
        this.logger.debug((Object)("Number of languages: " + this.languages.size()));
    }

    private void findAvailableSearchFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        int i;
        this.logger.debug((Object)"Find available search fields");
        if (this.selectedCollections.size() == 0 || this.selectedLanguage == -1 || this.languages.size() == 0) {
            this.searchableFields = new ArrayList<Field>();
            this.browsableFields = new ArrayList<Field>();
            this.logger.debug((Object)"No selected collections or no languages - returning");
            return;
        }
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = sh.getAvailableCollections();
        ArrayList<Field> searchableFields = new ArrayList<Field>();
        List<String> realCollections = this.getSelectedRealCollections(session);
        this.logger.debug((Object)("Number of selected real collections: " + realCollections.size()));
        CollectionInfo firstCol = sh.findCollectionInfo(realCollections.get(0));
        this.logger.debug((Object)"Found collection - printing info: ");
        this.logger.debug((Object)firstCol.getName());
        searchableFields.addAll(firstCol.getIndices());
        this.logger.debug((Object)("For collection: " + firstCol.getId() + " adding indices: " + searchableFields.size()));
        ArrayList<Field> clone = new ArrayList<Field>();
        for (i = 0; i < searchableFields.size(); ++i) {
            clone.add(((Field)searchableFields.get(i)).clone());
        }
        this.logger.debug((Object)("clone has: " + clone.size()));
        for (i = 1; i < realCollections.size(); ++i) {
            block2: for (int j = 0; j < searchableFields.size(); ++j) {
                int k;
                this.logger.debug((Object)("Checking or field: " + ((Field)searchableFields.get(j)).getLabel() + " inside collection: " + realCollections.get(i)));
                CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(i));
                boolean found = false;
                for (k = 0; k < colInfo.getIndices().size(); ++k) {
                    this.logger.debug((Object)("Comparing fields: " + colInfo.getIndices().get(k).getId() + " " + colInfo.getIndices().get(k).getLabel() + " with " + searchableFields.get(j).getId() + " " + searchableFields.get(j).getLabel()));
                    if (!colInfo.getIndices().get(k).getId().equals(searchableFields.get(j).getId())) continue;
                    found = true;
                    this.logger.debug((Object)"FOUND!");
                    break;
                }
                if (found) continue;
                for (k = 0; k < clone.size(); ++k) {
                    if (!((Field)clone.get(k)).getId().equals(searchableFields.get(j).getId())) continue;
                    this.logger.debug((Object)"REMOVING");
                    clone.remove(k);
                    continue block2;
                }
            }
        }
        this.logger.debug((Object)("clone has now: " + clone.size()));
        searchableFields.clear();
        for (i = 0; i < clone.size(); ++i) {
            ArrayList<String> langs = ((Field)clone.get(i)).getLanguages();
            this.logger.debug((Object)("The number of field languages is: " + langs.size()));
            this.logger.debug((Object)("Number of languages: " + this.languages.size()));
            this.logger.debug((Object)("Selected language: " + this.selectedLanguage));
            if (!langs.contains(this.languages.get(this.selectedLanguage))) {
                this.logger.debug((Object)"Adding Field");
                searchableFields.add((Field)clone.get(i));
                continue;
            }
            this.logger.debug((Object)"Not adding field");
        }
        this.searchableFields = searchableFields;
        this.logger.debug((Object)("Finally the number is: " + searchableFields.size()));
    }

    private void findAvailableBrowseFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        int i;
        this.logger.debug((Object)"Find available browse fields");
        if (this.selectedCollections.size() == 0 || this.selectedLanguage == -1) {
            this.searchableFields = new ArrayList<Field>();
            this.browsableFields = new ArrayList<Field>();
            return;
        }
        SearchHelper sh = new SearchHelper(session);
        ArrayList<Field> browsableFields = new ArrayList<Field>();
        List<String> realCollections = this.getSelectedRealCollections(session);
        this.logger.debug((Object)("Number of selected real collections: " + realCollections.size()));
        CollectionInfo firstCol = sh.findCollectionInfo(realCollections.get(0));
        browsableFields.addAll(firstCol.getBrowsableFields());
        this.logger.debug((Object)("For collection: " + firstCol.getId() + " adding browse fields: " + browsableFields.size()));
        ArrayList<Field> clone = new ArrayList<Field>();
        for (i = 0; i < browsableFields.size(); ++i) {
            clone.add(((Field)browsableFields.get(i)).clone());
        }
        this.logger.debug((Object)("clone has: " + clone.size()));
        for (i = 1; i < realCollections.size(); ++i) {
            block2: for (int j = 0; j < browsableFields.size(); ++j) {
                int k;
                this.logger.debug((Object)("Checking or field: " + ((Field)browsableFields.get(j)).getLabel() + " inside collection: " + realCollections.get(i)));
                CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(i));
                boolean found = false;
                for (k = 0; k < colInfo.getBrowsableFields().size(); ++k) {
                    this.logger.debug((Object)("Comparing fields: " + colInfo.getBrowsableFields().get(k).getId() + " " + colInfo.getBrowsableFields().get(k).getLabel() + " with " + browsableFields.get(j).getId() + " " + browsableFields.get(j).getLabel()));
                    if (!colInfo.getBrowsableFields().get(k).getId().equals(browsableFields.get(j).getId())) continue;
                    found = true;
                    this.logger.debug((Object)"FOUND!");
                    break;
                }
                if (found) continue;
                for (k = 0; k < clone.size(); ++k) {
                    if (!((Field)clone.get(k)).getId().equals(browsableFields.get(j).getId())) continue;
                    this.logger.debug((Object)"REMOVING");
                    clone.remove(k);
                    continue block2;
                }
            }
        }
        this.logger.debug((Object)("clone has now: " + clone.size()));
        browsableFields.clear();
        browsableFields = clone;
        this.browsableFields = browsableFields;
        this.logger.debug((Object)("Finally the number is: " + this.browsableFields.size()));
    }

    private void findAvailableSortFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        if (this.selectedCollections == null || this.selectedCollections.size() == 0) {
            this.searchableFields = new ArrayList<Field>();
            return;
        }
        session.removeAttribute("session_snippet_attr");
        session.removeAttribute("session_title_attr");
        session.removeAttribute("sessionDetailedResult");
        try {
            List<String> presentables = this.findPresentableFields(session);
        }
        catch (Exception e) {
            this.logger.error((Object)"******************************************************findpresentableFields method thrown an exception. Going to get all presentables", (Throwable)e);
            try {
                List<String> presentables = this.findAllPresentableFields(session);
                for (Field x : this.searchableFields) {
                    if (!x.isSortable || !presentables.contains(x.id)) continue;
                    this.sortableFields.add(x);
                }
            }
            catch (ResourceRegistryException e1) {
                this.logger.error((Object)"Resource registry exception", (Throwable)e1);
            }
        }
    }

    public List<String> getSelectedRealCollections(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        this.logger.debug((Object)"Inside get selected real collections.");
        ArrayList<String> cols = new ArrayList<String>();
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> allCollections = sh.getAvailableCollections();
        Set<CollectionInfo> groups = allCollections.keySet();
        this.logger.debug((Object)("number of selected collections: " + this.selectedCollections.size()));
        for (String a : this.selectedCollections) {
            CollectionInfo colInfo = sh.findCollectionInfo(a);
            this.logger.debug((Object)("Collection: " + a));
            if (a.equals("all_collections") || this.selectedCollections.contains("all_collections")) {
                this.logger.debug((Object)"all_collections");
                for (CollectionInfo group : groups) {
                    this.logger.debug((Object)("Iterrating group!: " + group.getName()));
                    for (int i = 0; i < allCollections.get(group).size(); ++i) {
                        cols.add(allCollections.get(group).get(i).getId());
                    }
                }
                this.logger.debug((Object)("number of returned collections: " + cols.size()));
                return cols;
            }
            if (colInfo.isCollectionGroup) {
                this.logger.debug((Object)"collection group");
                for (CollectionInfo group : groups) {
                    if (!group.getId().equals(colInfo.getId())) continue;
                    ArrayList<CollectionInfo> realCols = allCollections.get(group);
                    for (int i = 0; i < realCols.size(); ++i) {
                        cols.add(realCols.get(i).getId());
                    }
                }
                continue;
            }
            this.logger.debug((Object)"real collection");
            for (CollectionInfo group : groups) {
                for (int i = 0; i < allCollections.get(group).size(); ++i) {
                    this.logger.debug((Object)("Comparing: " + allCollections.get(group).get(i).getId() + " with " + a));
                    if (!allCollections.get(group).get(i).getId().equals(a) || cols.contains(a)) continue;
                    cols.add(a);
                }
            }
        }
        this.logger.debug((Object)("number of returned collections: " + cols.size()));
        return cols;
    }

    public List<Field> getAvailableBrowseFields() {
        return this.browsableFields;
    }

    public List<Field> getAvailableSearchFields() {
        return this.searchableFields;
    }

    public List<Field> getAvailableSortFields() {
        return this.sortableFields;
    }

    public List<String> getAvailableLanguages() {
        return this.languages;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public GeospatialInfo getGeosatial() {
        return this.geospatialInfo;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getQueryDescription() {
        return this.queryDescription;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public List<String> getSelectedCollections() {
        return this.selectedCollections;
    }

    public String getSelectedLanguage() {
        return this.languages.get(this.selectedLanguage);
    }

    public void reset() {
        this.criteria.clear();
        this.operator = Operator.OR;
        this.order = Order.ASC;
        this.distinct = false;
        this.searchQueryTerms.clear();
    }

    public void selectCollections(List<String> newCollections, boolean selected, ASLSession session) {
        try {
            for (int i = 0; i < newCollections.size(); ++i) {
                this.logger.debug((Object)("new collections:**" + newCollections.get(i) + "**"));
                if (selected && !this.selectedCollections.contains(newCollections.get(i))) {
                    this.logger.debug((Object)("adding:**" + newCollections.get(i) + "**"));
                    this.selectedCollections.add(newCollections.get(i));
                } else if (!selected && this.selectedCollections.contains(newCollections.get(i))) {
                    this.logger.debug((Object)("removing:**" + newCollections.get(i) + "**"));
                    this.selectedCollections.remove(newCollections.get(i));
                }
                this.criteria.clear();
                this.searchQueryTerms.clear();
            }
            this.logger.debug((Object)"Going to update the information for the selected collections");
            this.findAvailableFts(session);
            this.findAvailableGeospatial(session);
            this.findAvailableLanguages(session);
            this.findAvailableSearchFields(session);
            this.findAvailableBrowseFields(session);
            this.findAvailableSortFields(session);
            this.logger.debug((Object)("Number of searchable fields found -> " + this.searchableFields.size()));
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception:", (Throwable)e);
        }
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setGeospatial(GeospatialInfo geospatial) {
        this.logger.debug((Object)"Setting geospatial info.");
        this.geospatialInfo = geospatial;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public boolean setSelectedLanguage(String lang, ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        this.reset();
        if (!this.languages.contains(lang)) {
            return false;
        }
        this.selectedLanguage = this.languages.indexOf(lang);
        this.findAvailableSearchFields(session);
        return true;
    }

    public void updateCriterionId(int i, String id) {
        this.logger.debug((Object)("Updating criterion: " + i + ", previous id was: " + this.criteria.get(i).getSearchFieldId() + ", new is: " + id));
        this.criteria.get(i).setSearchFieldId(id);
    }

    public void updateCriterionName(int i, String name) {
        this.logger.debug((Object)("Updating criterion: " + i + ", previous name was: " + this.criteria.get(i).getSearchFieldName() + ", new is: " + name));
        this.criteria.get(i).setSearchFieldName(name);
    }

    public void updateCriterionValue(int i, String value) {
        this.logger.debug((Object)("Updating criterion: " + i + ", previous value was: " + this.criteria.get(i).getSearchFieldName() + ", new is: " + value));
        if (!(!value.contains(" ") || value.startsWith("\"") && value.endsWith("\""))) {
            String[] splitted = value.split(" ");
            this.criteria.get(i).setSearchFieldValue(splitted[0]);
            for (int j = 1; j < splitted.length; ++j) {
                Criterion crit = new Criterion();
                crit.setSearchFieldId(this.criteria.get(i).getSearchFieldId());
                crit.setSearchFieldName(this.criteria.get(i).getSearchFieldName());
                crit.setSearchFieldValue(splitted[j]);
                this.criteria.add(crit);
            }
            return;
        }
        this.criteria.get(i).setSearchFieldValue(value);
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getGenericSearchType() {
        return this.genericSearchType;
    }

    public List<String> getSelectedCollectionNames(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        ArrayList<String> collectionNames = new ArrayList<String>();
        SearchHelper sh = new SearchHelper(session);
        for (String colId : realCollections) {
            CollectionInfo colInf = sh.findCollectionInfo(colId);
            if (colInf == null) continue;
            collectionNames.add(colInf.getName());
        }
        return collectionNames;
    }

    public void setGenericSearchType(String genType) {
        this.genericSearchType = genType;
    }

    public void setSetRelation(boolean set) {
        this.setRelation = set;
    }

    public void setBrowseBy(String browseByField) {
        this.browseBy = browseByField;
    }

    public String getBrowseByField() {
        return this.browseBy;
    }

    public ResultSetConsumerI search(ASLSession session, boolean simple) throws URIRetrievalFromISCacheException, URISyntaxException, gRS2CreationException, QuerySyntaxException, NoSearchMasterEPRFoundException, InitialBridgingNotCompleteException, InternalErrorException {
        this.logger.debug((Object)"About to create Query");
        this.searchType = simple ? "simpleSearch" : "advancedSearch";
        ResultSetConsumer.removeSessionVariables(session);
        String[] query = this.createSearchQuery(session, simple);
        this.queryDescription = query[1];
        this.logger.debug((Object)"The Search Query is: ///////////////////////////////////////////////////////");
        this.logger.debug((Object)query[0]);
        this.logger.debug((Object)"/////////////////////////////////////////////////////////////////////////");
        EndpointReference[] searchMasters = this.findSearchMasterEPR(session);
        if (searchMasters == null || searchMasters.length == 0) {
            this.logger.debug((Object)"No Search Masters Found");
            throw new NoSearchMasterEPRFoundException();
        }
        this.logger.debug((Object)("Number of Search Master EPRs: " + searchMasters.length));
        for (int i = 0; i < searchMasters.length; ++i) {
            try {
                long startTime = System.currentTimeMillis();
                this.logger.debug((Object)"////////////////////////Parsing query again!!!///////////////////////////////");
                this.searchEPR = this.submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
                long endTime = System.currentTimeMillis();
                long diff = endTime - startTime;
                this.logger.debug((Object)("Portal Benchmarking - Time to get RSEpr from SearchMaster: " + diff));
            }
            catch (URI.MalformedURIException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (SearchSystemPortRetrievalException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (QuerySubmissionSearchException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            if (this.searchEPR != null) {
                this.logger.debug((Object)("The rs EPR returned is: " + this.searchEPR));
                session.setAttribute("rsEPR", (Object)this.searchEPR);
                this.searchRSC = new ResultSetConsumer(this.searchEPR, this.searchType);
                this.searchRSC.setGenericSearchType(this.genericSearchType);
                long time = System.currentTimeMillis();
                this.logger.debug((Object)("Portal Benchmarking - ResultSetConsumer is ready now: " + time));
                return this.searchRSC;
            }
            this.logger.debug((Object)"No RS epr found - it is null.");
        }
        return null;
    }

    public ResultSetConsumerI genericSearch(ASLSession session, List<String> terms) throws URIRetrievalFromISCacheException, URISyntaxException, gRS2CreationException, QuerySyntaxException, NoSearchMasterEPRFoundException, InitialBridgingNotCompleteException, InternalErrorException {
        this.logger.debug((Object)"About to create Query");
        this.searchType = "genericSearch";
        ResultSetConsumer.removeSessionVariables(session);
        String[] query = this.createGenericSearchQuery(session, terms);
        this.queryDescription = query[1];
        this.logger.debug((Object)"The Search Query is: ///////////////////////////////////////////////////////");
        this.logger.debug((Object)query[0]);
        this.logger.debug((Object)"/////////////////////////////////////////////////////////////////////////");
        EndpointReference[] searchMasters = this.findSearchMasterEPR(session);
        if (searchMasters == null || searchMasters.length == 0) {
            this.logger.debug((Object)"No Search Masters Found");
            throw new NoSearchMasterEPRFoundException();
        }
        this.logger.debug((Object)("Number of Search Master EPRs: " + searchMasters.length));
        for (int i = 0; i < searchMasters.length; ++i) {
            try {
                long startTime = System.currentTimeMillis();
                this.logger.debug((Object)"////////////////////////Parsing query again!!!///////////////////////////////");
                this.searchEPR = this.submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
                long endTime = System.currentTimeMillis();
                long diff = endTime - startTime;
                this.logger.debug((Object)("Portal Benchmarking - Time to get RSEpr from SearchMaster: " + diff));
            }
            catch (URI.MalformedURIException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (SearchSystemPortRetrievalException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (QuerySubmissionSearchException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            if (this.searchEPR != null) {
                this.logger.debug((Object)("The rs EPR returned is: " + this.searchEPR));
                session.setAttribute("rsEPR", (Object)this.searchEPR);
                this.searchRSC = new ResultSetConsumer(this.searchEPR, this.searchType);
                this.searchRSC.setGenericSearchType(this.genericSearchType);
                long time = System.currentTimeMillis();
                this.logger.debug((Object)("Portal Benchmarking - ResultSetConsumer is ready now: " + time));
                return this.searchRSC;
            }
            this.logger.debug((Object)"No RS epr found - it is null.");
        }
        return null;
    }

    public ResultSetConsumerI browse(ASLSession session) throws URISyntaxException, gRS2CreationException, URIRetrievalFromISCacheException, InitialBridgingNotCompleteException, InternalErrorException {
        this.searchType = !this.distinct ? "browse" : "browseFields";
        ResultSetConsumer.removeSessionVariables(session);
        String[] query = this.createBrowseQuery(session);
        this.queryDescription = query[1];
        this.logger.debug((Object)"The browse Query is: ///////////////////////////////////////////////////////");
        this.logger.debug((Object)query[0]);
        this.logger.debug((Object)"/////////////////////////////////////////////////////////////////////////");
        EndpointReference[] searchMasters = this.findSearchMasterEPR(session);
        for (int i = 0; i < searchMasters.length; ++i) {
            try {
                this.searchEPR = this.submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
            }
            catch (URI.MalformedURIException e) {
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (SearchSystemPortRetrievalException e) {
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (QuerySubmissionSearchException e) {
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            if (this.searchEPR != null) {
                session.setAttribute("rsEPR", (Object)this.searchEPR);
                this.searchRSC = new ResultSetConsumer(this.searchEPR, this.searchType);
                this.searchRSC.setGenericSearchType(this.genericSearchType);
                SearchHelper sh = new SearchHelper(session);
                String[][] colInfos = new String[this.selectedCollections.size()][2];
                for (int c = 0; c < this.selectedCollections.size(); ++c) {
                    CollectionInfo colInfo = sh.findCollectionInfo(this.selectedCollections.get(c));
                    colInfos[c][0] = colInfo.getName();
                    colInfos[c][1] = colInfo.getId();
                }
                String browseByName = new String();
                for (int b = 0; b < this.browsableFields.size(); ++b) {
                    if (!this.browseBy.equals(this.browsableFields.get(b).getId())) continue;
                    browseByName = this.browsableFields.get(b).getLabel();
                }
                BrowseAccessLogEntry browseEntry = new BrowseAccessLogEntry(colInfos, browseByName, this.distinct);
                this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)browseEntry);
                return this.searchRSC;
            }
            this.logger.debug((Object)"No search epr found.");
        }
        return null;
    }

    public ResultSetConsumerI quickSearch(ASLSession session, String keyword) throws URIRetrievalFromISCacheException, URISyntaxException, gRS2CreationException {
        this.searchType = "quickSearch";
        this.logger.debug((Object)"Inside quick search!");
        ResultSetConsumer.removeSessionVariables(session);
        this.logger.debug((Object)"Trying to create quick query");
        String[] query = this.createQuickQuery(session, keyword);
        this.queryDescription = query[1];
        this.logger.debug((Object)"/////////////////////////////////////////////////////////////////////////");
        this.logger.debug((Object)("Quick Query: " + query[0]));
        this.logger.debug((Object)"/////////////////////////////////////////////////////////////////////////");
        EndpointReference[] searchMasters = this.findSearchMasterEPR(session);
        for (int i = 0; i < searchMasters.length; ++i) {
            try {
                this.searchEPR = this.submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
            }
            catch (URI.MalformedURIException e) {
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (SearchSystemPortRetrievalException e) {
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (QuerySubmissionSearchException e) {
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            if (this.searchEPR != null) {
                this.logger.debug((Object)("The searchEPR returned is: " + this.searchEPR));
                session.setAttribute("rsEPR", (Object)this.searchEPR);
                this.searchRSC = new ResultSetConsumer(this.searchEPR, this.searchType);
                this.searchRSC.setGenericSearchType(this.genericSearchType);
                QuickSearchAccessLogEntry quickEntry = new QuickSearchAccessLogEntry(keyword);
                this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)quickEntry);
                return this.searchRSC;
            }
            this.logger.debug((Object)"No search epr found.");
        }
        return null;
    }

    public String[] testSearchQuery(ASLSession session, boolean simple, boolean browse, String quick) throws InitialBridgingNotCompleteException, InternalErrorException {
        this.logger.debug((Object)"About to create Query for testing: ");
        String[] query = new String[2];
        if (!quick.equals("")) {
            query = this.createQuickQuery(session, quick);
        } else if (!browse) {
            try {
                query = this.createSearchQuery(session, simple);
            }
            catch (QuerySyntaxException e) {
                this.logger.error((Object)"Exception:", (Throwable)e);
            }
        } else {
            query = this.createBrowseQuery(session);
        }
        return query;
    }

    public ResultSetConsumerI genericSearch(ASLSession session, String query) throws URIRetrievalFromISCacheException, URISyntaxException, gRS2CreationException, NoSearchMasterEPRFoundException {
        EndpointReference[] searchMasters = this.findSearchMasterEPR(session);
        if (searchMasters == null || searchMasters.length == 0) {
            this.logger.debug((Object)"No Search Masters Found");
            throw new NoSearchMasterEPRFoundException();
        }
        this.logger.debug((Object)("Number of Search Master EPRs: " + searchMasters.length));
        for (int i = 0; i < searchMasters.length; ++i) {
            try {
                long startTime = System.currentTimeMillis();
                this.searchEPR = this.submitSearch(query, searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
                long endTime = System.currentTimeMillis();
                long diff = endTime - startTime;
                this.logger.debug((Object)("Portal Benchmarking - Time to get RSEpr from SearchMaster: " + diff));
            }
            catch (URI.MalformedURIException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (SearchSystemPortRetrievalException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            catch (QuerySubmissionSearchException e) {
                this.logger.error((Object)"An error occured while submitting search!", (Throwable)e);
                session.setAttribute("searchException", (Object)("An internal error occurred while executing your query:<br>" + e.getMessage()));
            }
            if (this.searchEPR != null) {
                this.logger.debug((Object)("The rs EPR returned is: " + this.searchEPR));
                session.setAttribute("rsEPR", (Object)this.searchEPR);
                this.searchRSC = new ResultSetConsumer(this.searchEPR, this.searchType);
                this.searchRSC.setGenericSearchType(this.genericSearchType);
                long time = System.currentTimeMillis();
                this.logger.debug((Object)("Portal Benchmarking - ResultSetConsumer is ready now: " + time));
                return this.searchRSC;
            }
            this.logger.debug((Object)"No RS epr found - it is null.");
        }
        return null;
    }

    private void findAvailableFts(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        this.ftsAvailable = false;
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            SearchHelper searchH = new SearchHelper(session);
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = searchH.getAvailableCollections();
            this.logger.debug((Object)"Inside findAvailableFTS");
            for (int i = 0; i < selectedRealCollections.size(); ++i) {
                this.logger.debug((Object)"Trying to find collection info");
                CollectionInfo colInfo = FindFieldsInfo.findCollectionInfo(selectedRealCollections.get(i), collections);
                if (colInfo == null) continue;
                if (!colInfo.isFts()) {
                    this.ftsAvailable = false;
                    this.logger.debug((Object)"no available fts");
                    break;
                }
                this.ftsId = colInfo.getFtsId();
                this.logger.debug((Object)("Col Info fts!: " + this.ftsId));
                this.ftsAvailable = true;
            }
        } else {
            this.ftsAvailable = false;
        }
    }

    private void findAvailableGeospatial(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            SearchHelper searchH = new SearchHelper(session);
            HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = searchH.getAvailableCollections();
            this.logger.debug((Object)"Inside findAvailableGeospatial");
            for (int i = 0; i < selectedRealCollections.size(); ++i) {
                this.logger.debug((Object)"Trying to find collection info");
                CollectionInfo colInfo = FindFieldsInfo.findCollectionInfo(selectedRealCollections.get(i), collections);
                if (colInfo == null) continue;
                if (!colInfo.isGeospatial()) {
                    this.geoAvailable = false;
                    break;
                }
                this.geoAvailable = true;
                this.geoField = colInfo.getGeospatialField();
            }
        } else {
            this.geoAvailable = false;
        }
    }

    protected String[] createSearchQuery(ASLSession session, boolean simple) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException {
        GCQLSortNode sort_node;
        GCQLNode termsNode;
        SearchHelper sh = new SearchHelper(session);
        ArrayList<String> externalCollections = sh.getExternalCollections();
        List<String> realCollections = this.getSelectedRealCollections(session);
        String[][] collectionsTable = new String[realCollections.size()][2];
        for (int c = 0; c < realCollections.size(); ++c) {
            CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(c));
            if (externalCollections.contains(colInfo.getId())) {
                collectionsTable[c][0] = colInfo.getName() + "_externalCollection";
                collectionsTable[c][1] = colInfo.getId();
                continue;
            }
            collectionsTable[c][0] = colInfo.getName();
            collectionsTable[c][1] = colInfo.getId();
        }
        String[] q = new String[2];
        GCQLNode projectionNode = null;
        GCQLNode sortNode = null;
        if (!this.searchType.equals("previousSearch")) {
            projectionNode = this.getPresentationPart(session);
            if (this.sortBy != null && !this.sortBy.equals("")) {
                this.logger.debug((Object)"Sortby node");
                sortNode = this.getSortByPart(session);
            }
        }
        if ((termsNode = this.getCriteriaPart(session, simple)) == null && (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null)) {
            throw new QuerySyntaxException("No criteria specified");
        }
        GCQLNode collectionsPart = this.getCollectionsQueryPart(session);
        if (this.searchType.equals("previousSearch")) {
            GCQLProjectNode projectNode = (GCQLProjectNode)this.previousQuery;
            GCQLNode subtree = projectNode.subtree;
            GCQLSortNode sortInitialNode = null;
            GCQLNode tree = null;
            if (subtree instanceof GCQLSortNode) {
                sortInitialNode = (GCQLSortNode)subtree;
                tree = sortInitialNode.subtree;
            } else {
                tree = subtree;
            }
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = tree;
            andNode.right = termsNode;
            if (sortInitialNode != null) {
                sortInitialNode.subtree = andNode;
                projectNode.subtree = sortInitialNode;
            } else {
                projectNode.subtree = andNode;
            }
            this.queryString = projectNode.toCQL();
            this.queryDescription = this.getQueryDescriptionForPreviousQuery(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            return q;
        }
        if (simple) {
            GCQLSortNode sort_node2;
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = termsNode;
            andNode.right = collectionsPart;
            GCQLProjectNode projNode = null;
            if (projectionNode != null) {
                projNode = (GCQLProjectNode)projectionNode;
                if (sortNode != null) {
                    this.logger.debug((Object)"Simple sortby");
                    sort_node2 = (GCQLSortNode)sortNode;
                    sort_node2.subtree = andNode;
                    projNode.subtree = sort_node2;
                } else {
                    projNode.subtree = andNode;
                }
            } else if (sortNode != null) {
                this.logger.debug((Object)"Simple sortby");
                sort_node2 = (GCQLSortNode)sortNode;
                sort_node2.subtree = andNode;
            }
            this.queryString = projNode != null ? projNode.toCQL() : (sortNode != null ? sortNode.toCQL() : andNode.toCQL());
            if (this.rankingSupport) {
                String searchTerms = new String();
                int totalSearchTerms = this.searchQueryTerms.size();
                if (totalSearchTerms > 1) {
                    searchTerms = searchTerms + "\"";
                }
                for (int i = 0; i < totalSearchTerms - 1; ++i) {
                    searchTerms = searchTerms + this.searchQueryTerms.get(i) + " ";
                }
                searchTerms = searchTerms + this.searchQueryTerms.get(totalSearchTerms - 1);
                if (totalSearchTerms > 1) {
                    searchTerms = searchTerms + "\"";
                }
                this.queryString = this.queryString + " fuse " + searchTerms;
            }
            this.queryDescription = this.getQueryDescriptionForSimple(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            SimpleSearchAccessLogEntry simpleEntry = new SimpleSearchAccessLogEntry(collectionsTable, this.searchTerm);
            this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)simpleEntry);
            return q;
        }
        if (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null) {
            GCQLSortNode sort_node3;
            GCQLNode languageNode = this.getLanguageQueryPart(session);
            GCQLAndNode andNode1 = new GCQLAndNode();
            andNode1.left = collectionsPart;
            andNode1.right = languageNode;
            GCQLAndNode andNode2 = new GCQLAndNode();
            andNode2.left = termsNode;
            andNode2.right = andNode1;
            GCQLProjectNode projNode = null;
            if (projectionNode != null) {
                projNode = (GCQLProjectNode)projectionNode;
                if (sortNode != null) {
                    this.logger.debug((Object)"Advanced sortBy");
                    sort_node3 = (GCQLSortNode)sortNode;
                    sort_node3.subtree = andNode2;
                    projNode.subtree = sort_node3;
                } else {
                    projNode.subtree = andNode2;
                }
            } else if (sortNode != null) {
                sort_node3 = (GCQLSortNode)sortNode;
                sort_node3.subtree = andNode2;
            }
            this.queryString = projNode != null ? projNode.toCQL() : (sortNode != null ? sortNode.toCQL() : andNode2.toCQL());
            this.queryDescription = this.getQueryDescriptionForAdvanced(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            String[][] criteriaTable = new String[this.criteria.size()][2];
            for (int m = 0; m < this.criteria.size(); ++m) {
                criteriaTable[m][0] = this.criteria.get(m).getSearchFieldName();
                this.logger.info((Object)criteriaTable[m][0]);
                criteriaTable[m][1] = this.criteria.get(m).getSearchFieldValue();
                this.logger.info((Object)criteriaTable[m][1]);
            }
            String oper = this.operator == Operator.AND ? "AND" : "OR";
            AdvancedSearchAccessLogEntry advancedEntry = new AdvancedSearchAccessLogEntry(collectionsTable, criteriaTable, oper);
            this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)advancedEntry);
            return q;
        }
        SearchHelper s_h = new SearchHelper(session);
        CollectionInfo colInfo = null;
        ArrayList<GCQLNode> geoNodes = new ArrayList<GCQLNode>();
        for (int i = 0; i < realCollections.size(); ++i) {
            colInfo = s_h.findCollectionInfo(realCollections.get(i));
            if (!colInfo.isGeospatial()) continue;
            GCQLNode geoNd = this.getGeoQueryPart(session, colInfo.getId());
            geoNodes.add(geoNd);
        }
        GCQLNode geoQueryPart = null;
        if (geoNodes.size() > 1) {
            GCQLOrNode previousNode = null;
            for (int i = 0; i < geoNodes.size() - 1; ++i) {
                if (previousNode == null) {
                    previousNode = new GCQLOrNode();
                    previousNode.left = (GCQLNode)geoNodes.get(i);
                    previousNode.right = (GCQLNode)geoNodes.get(i + 1);
                    continue;
                }
                GCQLOrNode orNd = new GCQLOrNode();
                orNd.left = previousNode;
                orNd.right = (GCQLNode)geoNodes.get(i + 1);
                previousNode = orNd;
            }
            geoQueryPart = previousNode;
        } else {
            geoQueryPart = (GCQLNode)geoNodes.get(0);
        }
        GCQLAndNode andNode3 = null;
        if (this.criteria != null && this.criteria.size() != 0) {
            andNode3 = new GCQLAndNode();
            andNode3.left = geoQueryPart;
            andNode3.right = termsNode;
        }
        GCQLProjectNode projNode = null;
        if (projectionNode != null) {
            projNode = (GCQLProjectNode)projectionNode;
            if (sortNode != null) {
                sort_node = (GCQLSortNode)sortNode;
                sort_node.subtree = andNode3 != null ? andNode3 : geoQueryPart;
                projNode.subtree = sort_node;
            } else {
                projNode.subtree = andNode3 != null ? andNode3 : geoQueryPart;
            }
        } else if (sortNode != null) {
            sort_node = (GCQLSortNode)sortNode;
            sort_node.subtree = andNode3 != null ? andNode3 : geoQueryPart;
        }
        if (projNode != null) {
            this.queryString = projNode.toCQL();
        } else if (sortNode != null) {
            this.queryString = sortNode.toCQL();
        } else if (andNode3 != null) {
            this.queryString = andNode3.toCQL();
        } else if (geoQueryPart != null) {
            this.queryString = geoQueryPart.toCQL();
        }
        this.queryDescription = this.getQueryDescriptionForGeospatial(session);
        q[0] = this.queryString;
        q[1] = this.queryDescription;
        return q;
    }

    private String[] createGenericSearchQuery(ASLSession session, List<String> terms) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException {
        GCQLSortNode sort_node;
        GCQLNode termsNode;
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections = sh.getAvailableCollections();
        Iterator<Map.Entry<CollectionInfo, ArrayList<CollectionInfo>>> iterator = availableCollections.entrySet().iterator();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        while (iterator.hasNext()) {
            Map.Entry<CollectionInfo, ArrayList<CollectionInfo>> entry = iterator.next();
            for (CollectionInfo collection : entry.getValue()) {
                if (!collection.isFts()) continue;
                names.add(collection.getName());
                ids.add(collection.getId());
                this.ftsId = collection.getFtsId();
            }
        }
        String[][] collectionsTable = new String[names.size()][2];
        for (int i = 0; i < names.size(); ++i) {
            collectionsTable[i][0] = (String)names.get(i);
            collectionsTable[i][1] = (String)ids.get(i);
        }
        String[] q = new String[2];
        GCQLNode projectionNode = null;
        GCQLNode sortNode = null;
        if (!this.searchType.equals("previousSearch")) {
            projectionNode = this.getPresentationPart(session);
            if (this.sortBy != null && !this.sortBy.equals("")) {
                this.logger.debug((Object)"Sortby node");
                sortNode = this.getSortByPart(session);
            }
        }
        if ((termsNode = this.getGenericCriterialPart(session, terms)) == null && (this.geospatialInfo == null || this.geospatialInfo.getBounds() == null)) {
            throw new QuerySyntaxException("No criteria specified");
        }
        this.logger.info((Object)("Printing criterial part " + termsNode.toCQL()));
        GCQLNode collectionsPart = this.getCollectionsGenericQueryPart(session);
        if (this.searchType.equals("previousSearch")) {
            GCQLProjectNode projectNode = (GCQLProjectNode)this.previousQuery;
            GCQLNode subtree = projectNode.subtree;
            GCQLSortNode sortInitialNode = null;
            GCQLNode tree = null;
            if (subtree instanceof GCQLSortNode) {
                sortInitialNode = (GCQLSortNode)subtree;
                tree = sortInitialNode.subtree;
            } else {
                tree = subtree;
            }
            GCQLAndNode andNode = new GCQLAndNode();
            andNode.left = tree;
            andNode.right = termsNode;
            if (sortInitialNode != null) {
                sortInitialNode.subtree = andNode;
                projectNode.subtree = sortInitialNode;
            } else {
                projectNode.subtree = andNode;
            }
            this.queryString = projectNode.toCQL();
            this.queryDescription = this.getQueryDescriptionForPreviousQuery(session);
            q[0] = this.queryString;
            q[1] = this.queryDescription;
            return q;
        }
        GCQLAndNode andNode = new GCQLAndNode();
        andNode.left = termsNode;
        andNode.right = collectionsPart;
        GCQLProjectNode projNode = null;
        if (projectionNode != null) {
            projNode = (GCQLProjectNode)projectionNode;
            if (sortNode != null) {
                this.logger.debug((Object)"Simple sortby");
                sort_node = (GCQLSortNode)sortNode;
                sort_node.subtree = andNode;
                projNode.subtree = sort_node;
            } else {
                projNode.subtree = andNode;
            }
        } else if (sortNode != null) {
            this.logger.debug((Object)"Simple sortby");
            sort_node = (GCQLSortNode)sortNode;
            sort_node.subtree = andNode;
        }
        this.queryString = projNode != null ? projNode.toCQL() : (sortNode != null ? sortNode.toCQL() : andNode.toCQL());
        this.queryDescription = this.getQueryDescriptionForSimple(session);
        q[0] = this.queryString;
        q[1] = this.queryDescription;
        SimpleSearchAccessLogEntry simpleEntry = new SimpleSearchAccessLogEntry(collectionsTable, this.searchTerm);
        this.accessLogger.logEntry(session.getUsername(), session.getScopeName(), (AccessLogEntry)simpleEntry);
        return q;
    }

    protected String[] createBrowseQuery(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String[] q = new String[2];
        GCQLNode projectionNode = null;
        if (this.distinct) {
            this.logger.debug((Object)"getting distinct");
            projectionNode = this.getPresentationPartDistinct(session);
            this.logger.debug((Object)"Got presentation part browse distinct");
        } else {
            projectionNode = this.getPresentationPart(session);
            this.logger.debug((Object)"Got presentation part browse");
        }
        GCQLNode browseNode = this.getBrowseCriteriaPart(session);
        GCQLNode collectionsPart = this.getCollectionsQueryPart(session);
        GCQLAndNode andNode = new GCQLAndNode();
        andNode.left = browseNode;
        andNode.right = collectionsPart;
        if (projectionNode != null) {
            GCQLProjectNode projNode = (GCQLProjectNode)projectionNode;
            projNode.subtree = andNode;
            q[0] = projNode.toCQL();
        } else {
            q[0] = andNode.toCQL();
        }
        q[1] = this.getQueryDescriptionForBrowse(session);
        return q;
    }

    protected String[] createQuickQuery(ASLSession session, String keyword) {
        String[] q = new String[2];
        this.logger.debug((Object)("quick trying to get presentation part keyword is: " + keyword));
        GCQLNode projectionNode = this.getPresentationPart(session);
        this.logger.debug((Object)"Quick got presentation part");
        GCQLNode quickNode = this.getQuickCriterionPart(session, keyword);
        this.logger.debug((Object)"Quick got criteria part");
        if (projectionNode != null) {
            GCQLProjectNode projNode = (GCQLProjectNode)projectionNode;
            projNode.subtree = quickNode;
            q[0] = projNode.toCQL();
        } else {
            q[0] = quickNode.toCQL();
        }
        q[1] = this.getQueryDescriptionForQuick(session, keyword);
        return q;
    }

    protected String getQueryDescriptionForSimple(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = "\"" + this.searchTerm + "\" in collection(s): ";
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        SearchHelper sh = new SearchHelper(session);
        for (int i = 0; i < selectedRealCollections.size(); ++i) {
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
            queryDescr = queryDescr + colInfo.getName() + ", ";
        }
        queryDescr = queryDescr.substring(0, queryDescr.length() - 2);
        if (this.sortBy != null && !this.sortBy.equals("")) {
            this.logger.debug((Object)("The sort by is simple: " + this.sortBy));
            queryDescr = queryDescr + ". Sort the results by: " + this.findSortFieldName(this.sortBy);
        }
        return queryDescr;
    }

    protected String getQueryDescriptionForQuick(ASLSession session, String keyword) {
        String queryDescr = "Search for: \"" + keyword + "\"  in all collections";
        return queryDescr;
    }

    private String findSortFieldName(String sortById) {
        for (Field x : this.sortableFields) {
            this.logger.debug((Object)("comparing sortby: " + x.getId() + " with " + sortById));
            if (!x.getId().trim().equals(sortById.trim())) continue;
            return x.getName();
        }
        return "";
    }

    protected String getQueryDescriptionForBrowse(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = "Browse by: " + this.findSearchFieldName(this.browseBy.trim()) + " in collection(s): ";
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        SearchHelper sh = new SearchHelper(session);
        for (int i = 0; i < selectedRealCollections.size(); ++i) {
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
            queryDescr = queryDescr + colInfo.getName() + ", ";
        }
        queryDescr = queryDescr.substring(0, queryDescr.length() - 2);
        return queryDescr;
    }

    protected String getQueryDescriptionForAdvanced(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = new String();
        for (int i = 0; i < this.criteria.size(); ++i) {
            this.logger.debug((Object)("Criterion name: " + this.criteria.get(i).getSearchFieldId()));
            queryDescr = queryDescr + this.findSearchFieldName(this.criteria.get(i).getSearchFieldId());
            queryDescr = queryDescr + " = \"" + this.criteria.get(i).getSearchFieldValue();
            queryDescr = this.operator == Operator.OR ? queryDescr + "\" or " : queryDescr + "\" and ";
        }
        this.logger.debug((Object)queryDescr);
        queryDescr = this.operator == Operator.OR ? queryDescr.substring(0, queryDescr.length() - 4) : queryDescr.substring(0, queryDescr.length() - 5);
        queryDescr = queryDescr + " in collection(s): ";
        SearchHelper sh = new SearchHelper(session);
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        for (int i = 0; i < selectedRealCollections.size(); ++i) {
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
            queryDescr = queryDescr + colInfo.getName() + ", ";
        }
        queryDescr = queryDescr + "in " + this.languages.get(this.selectedLanguage) + " language.";
        if (this.sortBy != null && !this.sortBy.equals("")) {
            this.logger.debug((Object)("The sortby field is: " + this.sortBy));
            queryDescr = queryDescr + " Sort the results by: " + this.findSortFieldName(this.sortBy);
        }
        return queryDescr;
    }

    protected String getQueryDescriptionForGeospatial(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        if (this.criteria != null && this.criteria.size() != 0) {
            return this.getQueryDescriptionForAdvanced(session);
        }
        return "GeospatialSearch";
    }

    protected String getQueryDescriptionForPreviousQuery(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        String queryDescr = this.previousQueryDescription + ", and" + this.getQueryDescriptionForAdvanced(session);
        return queryDescr;
    }

    private String findSearchFieldName(String sfId) {
        for (Field x : this.searchableFields) {
            this.logger.debug((Object)("Compare criterion: " + x.getId().trim() + " with  " + sfId.trim()));
            if (x.getId().trim().equals(sfId.trim())) {
                this.logger.debug((Object)("The name is: " + x.getName() + " and the label: " + x.getLabel()));
                return x.getName();
            }
            this.logger.debug((Object)"Not equal!");
        }
        return "";
    }

    protected GCQLNode getCollectionsQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        GCQLTermNode collectionNode = new GCQLTermNode();
        collectionNode.setIndex("gDocCollectionID");
        collectionNode.setRelation(colRelation);
        collectionNode.setTerm(realCollections.get(0));
        if (realCollections.size() == 1) {
            return collectionNode;
        }
        GCQLOrNode previousOrNode = null;
        for (int i = 1; i < realCollections.size(); ++i) {
            GCQLTermNode newColNode = new GCQLTermNode();
            newColNode.setIndex("gDocCollectionID");
            newColNode.setRelation(colRelation);
            newColNode.setTerm(realCollections.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = collectionNode;
                previousOrNode.right = newColNode;
                continue;
            }
            GCQLOrNode newOrNode = new GCQLOrNode();
            newOrNode.right = previousOrNode;
            newOrNode.left = newColNode;
            previousOrNode = newOrNode;
        }
        return previousOrNode;
    }

    protected GCQLNode getCollectionsGenericQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        SearchHelper sh = new SearchHelper(session);
        HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections = sh.getAvailableCollections();
        ArrayList<String> allCollections = new ArrayList<String>();
        Iterator<CollectionInfo> iter = availableCollections.keySet().iterator();
        while (iter.hasNext()) {
            ArrayList<CollectionInfo> group = availableCollections.get(iter.next());
            for (int i = 0; i < group.size(); ++i) {
                if (!group.get(i).isFts()) continue;
                allCollections.add(group.get(i).getId());
            }
        }
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        GCQLTermNode collectionNode = new GCQLTermNode();
        collectionNode.setIndex("gDocCollectionID");
        collectionNode.setRelation(colRelation);
        collectionNode.setTerm((String)allCollections.get(0));
        if (allCollections.size() == 1) {
            return collectionNode;
        }
        GCQLOrNode previousOrNode = null;
        for (int i = 1; i < allCollections.size(); ++i) {
            GCQLTermNode newColNode = new GCQLTermNode();
            newColNode.setIndex("gDocCollectionID");
            newColNode.setRelation(colRelation);
            newColNode.setTerm((String)allCollections.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = collectionNode;
                previousOrNode.right = newColNode;
                continue;
            }
            GCQLOrNode newOrNode = new GCQLOrNode();
            newOrNode.right = previousOrNode;
            newOrNode.left = newColNode;
            previousOrNode = newOrNode;
        }
        return previousOrNode;
    }

    protected GCQLNode getGeoQueryPart(ASLSession session, String collectionId) {
        GCQLTermNode geoNode = new GCQLTermNode();
        geoNode.setIndex(this.geoField.getId());
        GCQLRelation geoRel = new GCQLRelation();
        geoRel.setBase("geosearch");
        Modifier inclusionMod = new Modifier("inclusion", "=", "1");
        Modifier collectionMod = new Modifier("colID", "=", collectionId);
        Modifier languageMod = new Modifier("lang", "=", this.languages.get(this.selectedLanguage));
        Modifier rankerMod = new Modifier("ranker", "=", "\"GenericRanker false\"");
        Modifier refinerMod = new Modifier("refiner", "=", "\"TimeSpanRefiner false " + this.geospatialInfo.getStartingDateString() + " " + this.geospatialInfo.getEndingDateString() + "\"");
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        modifiers.add(collectionMod);
        modifiers.add(languageMod);
        modifiers.add(inclusionMod);
        modifiers.add(rankerMod);
        modifiers.add(refinerMod);
        geoRel.setModifiers(modifiers);
        geoNode.setRelation(geoRel);
        String coordinates = new String();
        Point[] points = this.geospatialInfo.getBounds();
        for (int i = 0; i < points.length; ++i) {
            double x = points[i].getLongitude();
            double y = points[i].getLatitude();
            coordinates = coordinates + String.valueOf(x) + " " + String.valueOf(y) + " ";
        }
        coordinates = "\"" + coordinates.substring(0, coordinates.length() - 1) + "\"";
        geoNode.setTerm(coordinates);
        return geoNode;
    }

    protected GCQLNode getGeoCollectionsQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        int i;
        List<String> realCollections = this.getSelectedRealCollections(session);
        GCQLRelation colRelation = new GCQLRelation();
        colRelation.setBase("==");
        SearchHelper s_h = new SearchHelper(session);
        GCQLTermNode collectionNode = null;
        for (i = 0; i < realCollections.size(); ++i) {
            CollectionInfo colInfo = s_h.findCollectionInfo(realCollections.get(i));
            if (!colInfo.isGeospatial()) continue;
            collectionNode = new GCQLTermNode();
            collectionNode.setIndex("gDocCollectionID");
            collectionNode.setRelation(colRelation);
            collectionNode.setTerm(realCollections.get(i));
            break;
        }
        if (collectionNode == null) {
            return null;
        }
        GCQLOrNode previousOrNode = null;
        while (i < realCollections.size()) {
            CollectionInfo colInfo = s_h.findCollectionInfo(realCollections.get(i));
            if (colInfo.isGeospatial()) {
                GCQLTermNode newColNode = new GCQLTermNode();
                newColNode.setIndex("gDocCollectionID");
                newColNode.setRelation(colRelation);
                newColNode.setTerm(realCollections.get(i));
                if (previousOrNode == null) {
                    previousOrNode = new GCQLOrNode();
                    previousOrNode.left = collectionNode;
                    previousOrNode.right = newColNode;
                } else {
                    GCQLOrNode newOrNode = new GCQLOrNode();
                    newOrNode.right = previousOrNode;
                    newOrNode.left = newColNode;
                    previousOrNode = newOrNode;
                }
            }
            ++i;
        }
        if (previousOrNode == null) {
            return collectionNode;
        }
        return previousOrNode;
    }

    protected GCQLNode getGenericCriterialPart(ASLSession session, List<String> terms) throws QuerySyntaxException {
        this.logger.debug((Object)("Inside getGenericCriterialPart - the search type is: " + this.searchType));
        int size = terms.size();
        if (size < 1) {
            throw new QuerySyntaxException("Empty term list given");
        }
        GCQLRelation fieldRelation = new GCQLRelation();
        fieldRelation.setBase("=");
        GCQLTermNode criterionNode = new GCQLTermNode();
        criterionNode.setIndex(this.ftsId);
        criterionNode.setRelation(fieldRelation);
        criterionNode.setTerm(terms.get(0));
        if (size == 1) {
            return criterionNode;
        }
        GCQLOrNode previousOrNode = null;
        for (int i = 1; i < size; ++i) {
            GCQLTermNode newCriterionNode = new GCQLTermNode();
            newCriterionNode.setIndex(this.ftsId);
            newCriterionNode.setRelation(fieldRelation);
            newCriterionNode.setTerm(terms.get(i));
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = criterionNode;
                previousOrNode.right = newCriterionNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newCriterionNode;
                previousOrNode = newOrNode;
            }
            this.searchQueryTerms.add(terms.get(i));
        }
        return previousOrNode;
    }

    protected GCQLNode getCriteriaPart(ASLSession session, boolean simple) {
        this.logger.debug((Object)("Inside getCriteriaPart - the search type is: " + this.searchType));
        this.searchQueryTerms.clear();
        if (!simple) {
            if (this.previousCriteria != null && this.previousCriteria.size() != 0) {
                for (int i = 0; i < this.previousCriteria.size(); ++i) {
                    this.criteria.add(this.previousCriteria.get(i).clone());
                    this.searchQueryTerms.add(this.previousCriteria.get(i).getSearchFieldValue());
                }
                this.previousCriteria.clear();
                this.operator = Operator.AND;
            } else {
                this.logger.debug((Object)"no previous criteria set");
            }
            if (this.criteria != null && this.criteria.size() != 0) {
                GCQLRelation fieldRelation = new GCQLRelation();
                fieldRelation.setBase("=");
                GCQLTermNode criterionNode = new GCQLTermNode();
                criterionNode.setIndex(this.criteria.get(0).getSearchFieldId());
                criterionNode.setRelation(fieldRelation);
                criterionNode.setTerm(this.criteria.get(0).getSearchFieldValue());
                this.searchQueryTerms.add(this.criteria.get(0).getSearchFieldValue());
                if (this.criteria.size() == 1) {
                    if (this.criteria.get(0).getSearchFieldValue() == null || this.criteria.get(0).getSearchFieldValue().equals("")) {
                        return null;
                    }
                    return criterionNode;
                }
                if (this.operator.equals((Object)Operator.AND)) {
                    GCQLAndNode previousAndNode = null;
                    for (int i = 1; i < this.criteria.size(); ++i) {
                        if (this.criteria.get(i).getSearchFieldValue() == null || this.criteria.get(i).getSearchFieldValue().equals("")) continue;
                        GCQLTermNode newCriterionNode = new GCQLTermNode();
                        newCriterionNode.setIndex(this.criteria.get(i).getSearchFieldId());
                        newCriterionNode.setRelation(fieldRelation);
                        newCriterionNode.setTerm(this.criteria.get(i).getSearchFieldValue());
                        this.searchQueryTerms.add(this.criteria.get(i).getSearchFieldValue());
                        if (previousAndNode == null) {
                            previousAndNode = new GCQLAndNode();
                            previousAndNode.left = criterionNode;
                            previousAndNode.right = newCriterionNode;
                            continue;
                        }
                        GCQLAndNode newAndNode = new GCQLAndNode();
                        newAndNode.right = previousAndNode;
                        newAndNode.left = newCriterionNode;
                        previousAndNode = newAndNode;
                    }
                    return previousAndNode;
                }
                GCQLOrNode previousOrNode = null;
                for (int i = 1; i < this.criteria.size(); ++i) {
                    if (this.criteria.get(i).getSearchFieldValue() == null || this.criteria.get(i).getSearchFieldValue().equals("")) continue;
                    GCQLTermNode newCriterionNode = new GCQLTermNode();
                    if (this.criteria.get(i).getSearchFieldName().equals("Any")) {
                        newCriterionNode.setIndex(this.ftsId);
                    } else {
                        newCriterionNode.setIndex(this.criteria.get(i).getSearchFieldId());
                    }
                    newCriterionNode.setRelation(fieldRelation);
                    newCriterionNode.setTerm(this.criteria.get(i).getSearchFieldValue());
                    this.searchQueryTerms.add(this.criteria.get(i).getSearchFieldValue());
                    if (previousOrNode == null) {
                        previousOrNode = new GCQLOrNode();
                        previousOrNode.left = criterionNode;
                        previousOrNode.right = newCriterionNode;
                        continue;
                    }
                    GCQLOrNode newOrNode = new GCQLOrNode();
                    newOrNode.right = previousOrNode;
                    newOrNode.left = newCriterionNode;
                    previousOrNode = newOrNode;
                }
                return previousOrNode;
            }
            return null;
        }
        if (!this.searchTerm.contains(" ") || this.searchTerm.startsWith("\"") && this.searchTerm.endsWith("\"")) {
            GCQLRelation fieldRelation = new GCQLRelation();
            fieldRelation.setBase("=");
            GCQLTermNode criterionNode = new GCQLTermNode();
            this.logger.debug((Object)("The fts id is: " + this.ftsId));
            criterionNode.setIndex(this.ftsId);
            criterionNode.setRelation(fieldRelation);
            criterionNode.setTerm(this.searchTerm);
            this.searchQueryTerms.add(this.searchTerm);
            return criterionNode;
        }
        String[] searchTerms = this.searchTerm.split("\\s+");
        GCQLRelation fieldRelation = new GCQLRelation();
        fieldRelation.setBase("=");
        GCQLTermNode criterionNode = new GCQLTermNode();
        criterionNode.setIndex(this.ftsId);
        criterionNode.setRelation(fieldRelation);
        criterionNode.setTerm(searchTerms[0]);
        this.searchQueryTerms.add(searchTerms[0]);
        GCQLOrNode previousOrNode = null;
        for (int i = 1; i < searchTerms.length; ++i) {
            GCQLTermNode newCriterionNode = new GCQLTermNode();
            newCriterionNode.setIndex(this.ftsId);
            newCriterionNode.setRelation(fieldRelation);
            newCriterionNode.setTerm(searchTerms[i]);
            if (previousOrNode == null) {
                previousOrNode = new GCQLOrNode();
                previousOrNode.left = criterionNode;
                previousOrNode.right = newCriterionNode;
            } else {
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newCriterionNode;
                previousOrNode = newOrNode;
            }
            this.searchQueryTerms.add(searchTerms[i]);
        }
        return previousOrNode;
    }

    protected GCQLNode getQuickCriterionPart(ASLSession session, String keyword) {
        GCQLRelation fieldRelation = new GCQLRelation();
        fieldRelation.setBase("=");
        this.logger.debug((Object)"Quick getting criterion");
        GCQLTermNode criterionNode = new GCQLTermNode();
        String quickField = "";
        try {
            quickField = (String)session.getAttribute("quickFieldId");
            if (quickField == null) {
                this.logger.debug((Object)"Quick got presentation part from registry");
                List alFields = gr.uoa.di.madgik.rr.element.search.Field.getFieldsWithName((boolean)false, (String)"allIndexes");
                if (alFields != null && alFields.size() != 0) {
                    criterionNode.setIndex(((gr.uoa.di.madgik.rr.element.search.Field)alFields.get(0)).getID());
                    session.setAttribute("quickFieldId", (Object)criterionNode.getIndex());
                }
                this.logger.debug((Object)"Quick got it");
            } else {
                criterionNode.setIndex(quickField);
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error((Object)"Exception:", (Throwable)e);
        }
        criterionNode.setRelation(fieldRelation);
        if (!keyword.contains(" ") || keyword.startsWith("\"") && keyword.endsWith("\"")) {
            criterionNode.setTerm(keyword);
            return criterionNode;
        }
        if (keyword.contains(" ")) {
            String[] searchTerms = keyword.split(" ");
            criterionNode.setTerm(searchTerms[0]);
            GCQLOrNode previousOrNode = null;
            for (int i = 1; i < searchTerms.length; ++i) {
                GCQLTermNode newCriterionNode = new GCQLTermNode();
                newCriterionNode.setIndex(criterionNode.getIndex());
                newCriterionNode.setRelation(criterionNode.getRelation());
                newCriterionNode.setTerm(searchTerms[i]);
                if (previousOrNode == null) {
                    previousOrNode = new GCQLOrNode();
                    previousOrNode.left = criterionNode;
                    previousOrNode.right = newCriterionNode;
                    continue;
                }
                GCQLOrNode newOrNode = new GCQLOrNode();
                newOrNode.right = previousOrNode;
                newOrNode.left = newCriterionNode;
                previousOrNode = newOrNode;
            }
            return previousOrNode;
        }
        criterionNode.setTerm(keyword);
        return criterionNode;
    }

    protected GCQLNode getBrowseCriteriaPart(ASLSession session) {
        GCQLRelation browseFieldRelation = new GCQLRelation();
        browseFieldRelation.setBase("==");
        GCQLTermNode newCriterionNode = new GCQLTermNode();
        newCriterionNode.setIndex(this.browseBy);
        newCriterionNode.setRelation(browseFieldRelation);
        newCriterionNode.setTerm("\"*\"");
        return newCriterionNode;
    }

    protected GCQLNode getLanguageQueryPart(ASLSession session) {
        GCQLTermNode languageNode = new GCQLTermNode();
        languageNode.setIndex("gDocCollectionLang");
        GCQLRelation languageRelation = new GCQLRelation();
        languageRelation.setBase("==");
        languageNode.setRelation(languageRelation);
        languageNode.setTerm(this.languages.get(this.selectedLanguage));
        return languageNode;
    }

    protected List<String> findAllPresentableFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException, ResourceRegistryException {
        SearchHelper sh = new SearchHelper(session);
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        ArrayList<String> allFields = new ArrayList<String>();
        CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(0));
        ArrayList<String> commonFields = new ArrayList<String>();
        ArrayList<Field> fields = colInfo.getPresentationFields();
        for (int i = 0; i < fields.size(); ++i) {
            commonFields.add(fields.get(i).getId());
        }
        ArrayList<String> tempFields = new ArrayList<String>();
        tempFields.addAll(commonFields);
        allFields.addAll(commonFields);
        for (int i = 0; i < commonFields.size(); ++i) {
            for (int j = 1; j < selectedRealCollections.size(); ++j) {
                int place;
                colInfo = sh.findCollectionInfo(selectedRealCollections.get(j));
                fields = colInfo.getPresentationFields();
                ArrayList<String> prFields = new ArrayList<String>();
                for (int k = 0; k < fields.size(); ++k) {
                    prFields.add(fields.get(k).getId());
                }
                for (int p = 0; p < prFields.size(); ++p) {
                    if (allFields.contains(prFields.get(p))) continue;
                    this.logger.debug((Object)("PrFields: Adding - " + (String)prFields.get(p) + " to prFields"));
                    allFields.add((String)prFields.get(p));
                }
                if (prFields.contains(commonFields.get(i)) || (place = tempFields.indexOf(commonFields.get(i))) == -1) continue;
                tempFields.remove(place);
                this.logger.debug((Object)("Removing from tempFields - " + commonFields.get(i)));
            }
        }
        commonFields = tempFields;
        if (commonFields == null || commonFields.size() == 0) {
            this.logger.debug((Object)"PrFields: No common fields - adding all fields");
            commonFields = allFields;
        }
        session.setAttribute("presentationFields", commonFields);
        Boolean isDetailedResult = true;
        for (int n = 0; n < commonFields.size(); ++n) {
            String id = (String)commonFields.get(n);
            String name = QueryHelper.GetFieldNameById((String)id);
            if (name.trim().equals("S")) {
                session.setAttribute("session_snippet_attr", (Object)id);
                isDetailedResult = false;
                continue;
            }
            if (!name.trim().equals("title")) continue;
            session.setAttribute("session_title_attr", (Object)id);
            isDetailedResult = false;
        }
        session.setAttribute("sessionDetailedResult", (Object)isDetailedResult);
        return commonFields;
    }

    protected List<String> findPresentableFields(ASLSession session) throws Exception {
        this.logger.debug((Object)"PrFields: Inside method");
        HashMap<String, ArrayList<String>> collectionsFields = (HashMap<String, ArrayList<String>>)session.getAttribute("collectionsPresentableFields");
        SearchHelper sh = new SearchHelper(session);
        List<String> selectedRealCollections = this.getSelectedRealCollections(session);
        ArrayList<String> allFields = new ArrayList<String>();
        if (collectionsFields == null) {
            ArrayList flds = (ArrayList)session.getAttribute("presentationFields");
            try {
                if (flds == null) {
                    collectionsFields = this.readUserProfile(session);
                }
            }
            catch (Exception e) {
                this.logger.debug((Object)"Didn't manage to read user profile", (Throwable)e);
                throw e;
            }
            if (collectionsFields != null) {
                session.setAttribute("collectionsPresentableFields", collectionsFields);
            } else {
                this.logger.debug((Object)"The collection's fields from the profile are null - about to ask for all");
            }
        }
        if (collectionsFields != null && collectionsFields.size() == 0) {
            this.logger.debug((Object)"get all presentation fields");
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(0));
            ArrayList<String> commonFields = new ArrayList<String>();
            ArrayList<Field> fields = colInfo.getPresentationFields();
            for (int i = 0; i < fields.size(); ++i) {
                commonFields.add(fields.get(i).getId());
            }
            ArrayList<String> tempFields = new ArrayList<String>();
            tempFields.addAll(commonFields);
            allFields.addAll(commonFields);
            this.logger.debug((Object)("PrFields: Initial num allFields: " + allFields.size()));
            for (int i = 0; i < commonFields.size(); ++i) {
                for (int j = 1; j < selectedRealCollections.size(); ++j) {
                    int place;
                    colInfo = sh.findCollectionInfo(selectedRealCollections.get(j));
                    fields = colInfo.getPresentationFields();
                    ArrayList<String> prFields = new ArrayList<String>();
                    for (int k = 0; k < fields.size(); ++k) {
                        prFields.add(fields.get(k).getId());
                    }
                    for (int p = 0; p < prFields.size(); ++p) {
                        if (allFields.contains(prFields.get(p))) continue;
                        this.logger.debug((Object)("PrFields: Adding to all fields: " + (String)prFields.get(p)));
                        allFields.add((String)prFields.get(p));
                    }
                    if (prFields.contains(commonFields.get(i)) || (place = tempFields.indexOf(commonFields.get(i))) == -1) continue;
                    this.logger.debug((Object)("PrFields: Removing from  tempfields: " + commonFields.get(i)));
                    tempFields.remove(place);
                }
            }
            commonFields = tempFields;
            if (commonFields == null || commonFields.size() == 0) {
                this.logger.debug((Object)"PrFields - No common fields Adding all fields");
                commonFields = allFields;
            }
            this.logger.debug((Object)("final num: " + commonFields.size()));
            session.setAttribute("presentationFields", commonFields);
            Boolean isDetailedResult = true;
            for (int n = 0; n < commonFields.size(); ++n) {
                String id = (String)commonFields.get(n);
                String name = QueryHelper.GetFieldNameById((String)id);
                if (name.trim().equals("S")) {
                    session.setAttribute("session_snippet_attr", (Object)id);
                    isDetailedResult = false;
                    continue;
                }
                if (!name.trim().equals("title")) continue;
                session.setAttribute("session_title_attr", (Object)id);
                isDetailedResult = false;
            }
            session.setAttribute("sessionDetailedResult", (Object)isDetailedResult);
            return commonFields;
        }
        if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
            int i;
            if (collectionsFields == null) {
                this.logger.debug((Object)"collectionsFields is null");
            }
            ArrayList<String> commonFields = new ArrayList<String>();
            CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(0));
            ArrayList<Field> prFields = colInfo.getPresentationFields();
            for (int i2 = 0; i2 < prFields.size(); ++i2) {
                commonFields.add(prFields.get(i2).getId());
            }
            allFields.addAll(commonFields);
            ArrayList tempFields = new ArrayList();
            for (i = 0; i < commonFields.size(); ++i) {
                tempFields.add(commonFields.get(i));
            }
            for (i = 0; i < commonFields.size(); ++i) {
                for (int j = 1; j < selectedRealCollections.size(); ++j) {
                    int place;
                    ArrayList<String> fields = collectionsFields.get(selectedRealCollections.get(j));
                    if (fields == null) {
                        fields = new ArrayList();
                        colInfo = sh.findCollectionInfo(selectedRealCollections.get(j));
                        prFields = colInfo.getPresentationFields();
                        for (int k = 0; k < prFields.size(); ++k) {
                            fields.add(prFields.get(k).getId());
                        }
                    }
                    for (int p = 0; p < fields.size(); ++p) {
                        if (allFields.contains(fields.get(p))) continue;
                        this.logger.debug((Object)("PrFields: Adding to all Fields: " + fields.get(p)));
                        allFields.add(fields.get(p));
                    }
                    if (fields.contains(commonFields.get(i)) || (place = tempFields.indexOf(commonFields.get(i))) == -1) continue;
                    tempFields.remove(place);
                }
            }
            commonFields = tempFields;
            if (commonFields == null || commonFields.size() == 0) {
                commonFields = allFields;
                this.logger.debug((Object)"PrFields: No common fields found - adding all fields");
            }
            session.setAttribute("presentationFields", commonFields);
            Boolean isDetailedResult = true;
            for (int n = 0; n < commonFields.size(); ++n) {
                String id = (String)commonFields.get(n);
                String name = QueryHelper.GetFieldNameById((String)id);
                if (name.trim().equals("S")) {
                    session.setAttribute("session_snippet_attr", (Object)id);
                    isDetailedResult = false;
                    continue;
                }
                if (!name.trim().equals("title")) continue;
                session.setAttribute("session_title_attr", (Object)id);
                isDetailedResult = false;
            }
            session.setAttribute("sessionDetailedResult", (Object)isDetailedResult);
            return commonFields;
        }
        return new ArrayList<String>();
    }

    protected List<String> findPresentableFields_NEWONE(ASLSession session) throws Exception {
        this.logger.debug((Object)"Inside method getPresentableFields()");
        SearchHelper sh = new SearchHelper(session);
        List<String> selectedCollections = this.getSelectedRealCollections(session);
        ArrayList<Object> common = new ArrayList();
        HashMap<String, ArrayList<String>> collectionsPresentableFields = null;
        collectionsPresentableFields = (HashMap<String, ArrayList<String>>)session.getAttribute("collectionsPresentableFields");
        if (collectionsPresentableFields == null) {
            try {
                collectionsPresentableFields = this.readUserProfile(session);
            }
            catch (Exception e) {
                common = this.askForAllPresentables(selectedCollections, sh);
                throw e;
            }
        }
        if (collectionsPresentableFields != null) {
            common = ArraysComparison.getCommonFields(collectionsPresentableFields, selectedCollections);
            this.logger.debug((Object)("NIK__common: " + common.toString()));
        } else {
            this.logger.debug((Object)"NIK__The collection's fields from the profile are null - about to ask for all");
            common = this.askForAllPresentables(selectedCollections, sh);
        }
        session.setAttribute("presentationFields", common);
        return common;
    }

    protected ArrayList<String> askForAllPresentables(List<String> selectedCollections, SearchHelper sh) throws InitialBridgingNotCompleteException, InternalErrorException {
        HashMap<String, ArrayList<String>> collectionsPresentableFields = new HashMap<String, ArrayList<String>>();
        ArrayList<Object> common = new ArrayList();
        ArrayList<Object> fields = new ArrayList();
        for (int i = 0; i < selectedCollections.size(); ++i) {
            fields = sh.findCollectionInfo(selectedCollections.get(i)).getPresentationFields();
            ArrayList<String> fieldsID = new ArrayList<String>();
            for (int f = 0; f < fields.size(); ++f) {
                fieldsID.add(((Field)fields.get(f)).getId());
            }
            collectionsPresentableFields.put(selectedCollections.get(i), fieldsID);
        }
        this.logger.debug((Object)"NIK__Recomputed the collectionsPresentableFields");
        this.logger.debug((Object)("NIK__collectionsPresentableFieldsSession: " + collectionsPresentableFields.toString()));
        common = ArraysComparison.getCommonFields(collectionsPresentableFields, selectedCollections);
        this.logger.debug((Object)("NIK__Common fields are: " + common.toString()));
        return common;
    }

    protected GCQLNode getSortByPart(ASLSession session) {
        GCQLSortNode sortNode = new GCQLSortNode();
        ModifierSet modSet = new ModifierSet(this.sortBy);
        if (this.order == Order.ASC) {
            modSet.addModifier("sort.ascending");
        } else {
            modSet.addModifier("sort.descending ");
        }
        sortNode.addSortIndex(modSet);
        return sortNode;
    }

    protected GCQLNode getPresentationPart(ASLSession session) {
        GCQLProjectNode projectNode = new GCQLProjectNode();
        if (this.searchType.equals("quickSearch")) {
            ModifierSet modfSet = new ModifierSet("*");
            projectNode.addProjectIndex(modfSet);
            session.removeAttribute("presentationFields");
            return projectNode;
        }
        if (this.searchType.equals("genericSearch")) {
            ModifierSet modfSet = new ModifierSet("*");
            projectNode.addProjectIndex(modfSet);
            session.removeAttribute("presentationFields");
            return projectNode;
        }
        ArrayList fields = new ArrayList();
        if (this.searchType.equals("browse")) {
            this.logger.debug((Object)"SearchType: Browse  -- get all available presentation fields");
            fields = (ArrayList)session.getAttribute("presentationFields");
        } else if (!this.semanticEnrichment) {
            if (session.getAttribute("session_snippet_attr") != null) {
                this.logger.debug((Object)("snippet field '" + (String)session.getAttribute("session_snippet_attr") + "' is available, project this"));
                fields.add((String)session.getAttribute("session_snippet_attr"));
            }
            if (session.getAttribute("session_title_attr") != null) {
                this.logger.debug((Object)("title field '" + session.getAttribute("session_title_attr") + "' is available, project this"));
                fields.add((String)session.getAttribute("session_title_attr"));
            }
        }
        if (fields.isEmpty()) {
            this.logger.debug((Object)"use all the available presentable fields");
            if (this.selectedPresentationFields.size() == 0) {
                this.logger.debug((Object)"profile presentation fields are empty, getting all the available");
                fields = (ArrayList)session.getAttribute("presentationFields");
            } else {
                this.logger.debug((Object)"using profile presentation fields");
                fields = this.selectedPresentationFields;
                this.selectedPresentationFields.clear();
            }
        }
        ArrayList<String> fieldStrings = new ArrayList<String>();
        this.logger.debug((Object)("Presentation num: " + fields.size()));
        for (String field : fields) {
            ModifierSet modfSet = new ModifierSet(field);
            projectNode.addProjectIndex(modfSet);
            fieldStrings.add(field);
        }
        if (this.searchType.equals("browse")) {
            if (!fieldStrings.contains(this.browseBy)) {
                ModifierSet modfSet = new ModifierSet(this.browseBy);
                projectNode.addProjectIndex(modfSet);
                fields.add(this.browseBy);
                session.setAttribute("presentationFields", (Object)fields);
            }
        } else if (this.searchType.equals("advancedSearch")) {
            for (int i = 0; i < this.criteria.size(); ++i) {
                if (fieldStrings.contains(this.criteria.get(i).getSearchFieldId())) continue;
                ModifierSet modfSet = new ModifierSet(this.criteria.get(i).getSearchFieldId());
                projectNode.addProjectIndex(modfSet);
                fields.add(this.criteria.get(i).getSearchFieldId());
                session.setAttribute("presentationFields", (Object)fields);
            }
        }
        if (fields.size() != 0) {
            return projectNode;
        }
        return null;
    }

    protected GCQLNode getPresentationPartDistinct(ASLSession session) {
        GCQLProjectNode projectNode = new GCQLProjectNode();
        this.logger.debug((Object)"PresentationPart - browse distinct");
        ArrayList<String> fields = new ArrayList<String>();
        this.logger.debug((Object)"PresentationPart browse");
        ModifierSet modfSet = new ModifierSet(this.browseBy);
        modfSet.addModifier("distinct");
        fields.add(this.browseBy);
        projectNode.addProjectIndex(modfSet);
        session.setAttribute("presentationFields", fields);
        if (fields.size() != 0) {
            return projectNode;
        }
        return null;
    }

    private HashMap<String, ArrayList<String>> readUserProfile(ASLSession session) throws ReadingUserProfileException {
        try {
            this.logger.debug((Object)"Inside readUserProfile");
            UserProfile userProf = new UserProfile(session);
            HashMap userPresentationFields = userProf.getPresentationFields(session.getUsername());
            if (userPresentationFields != null) {
                session.setAttribute("collectionsPresentableFields", (Object)userPresentationFields);
                this.logger.debug((Object)("size map: " + userPresentationFields.size()));
            }
            return userPresentationFields;
        }
        catch (Exception e) {
            throw new ReadingUserProfileException(e);
        }
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.logger.debug((Object)"Setting sort by");
        this.sortBy = sortBy;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public ResultSetConsumerI getSearchResults(ASLSession session) {
        return this.searchRSC;
    }

    public List<String> getSelectedCollectionsNames(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
        List<String> realCollections = this.getSelectedRealCollections(session);
        ArrayList<String> collectionNames = new ArrayList<String>();
        SearchHelper sh = new SearchHelper(session);
        for (String colId : realCollections) {
            CollectionInfo colInf = sh.findCollectionInfo(colId);
            if (colInf == null) continue;
            collectionNames.add(colInf.getName());
        }
        return collectionNames;
    }

    protected EndpointReference[] findSearchMasterEPR(ASLSession session) throws URIRetrievalFromISCacheException {
        EndpointReference[] searchMasters = null;
        this.logger.debug((Object)"Looking for a Search Master epr");
        try {
            searchMasters = RIsManager.getInstance().getISCache(session.getScope()).getEPRsFor("Search", "SearchSystemService", SrvType.SIMPLE.name());
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            throw new URIRetrievalFromISCacheException(e);
        }
        return searchMasters;
    }

    protected String submitSearch(String query, String searchMasterURI, ASLSession session) throws URI.MalformedURIException, SearchSystemPortRetrievalException, QuerySubmissionSearchException {
        SearchSystemServicePortType searchMaster;
        EndpointReferenceType serviceEPR = new EndpointReferenceType();
        serviceEPR.setAddress((AttributedURI)new Address(searchMasterURI));
        SearchMasterServiceAddressingLocator serviceLocator = new SearchMasterServiceAddressingLocator();
        GCQLQueryTreeManager.parseGCQLString((String)query);
        try {
            searchMaster = serviceLocator.getSearchSystemServicePortTypePort(serviceEPR);
        }
        catch (ServiceException e) {
            this.logger.error((Object)"Error while retrieving Search Master epr.", (Throwable)e);
            throw new SearchSystemPortRetrievalException(e);
        }
        try {
            searchMaster = (SearchSystemServicePortType)ServiceContextManager.applySecurity((Remote)searchMaster, (ASLSession)session);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
        }
        this.logger.debug((Object)("Query will be submitted to: " + searchMasterURI));
        SearchResponse ret = null;
        try {
            ret = searchMaster.search(query);
        }
        catch (GCUBERetryEquivalentFault e) {
            this.logger.error((Object)"Error while submitting search query", (Throwable)e);
            throw new QuerySubmissionSearchException(e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"Error while submitting search query", (Throwable)e);
            throw new QuerySubmissionSearchException(e);
        }
        this.logger.debug((Object)("The rs epr is: " + ret.getResultSetEpr()));
        return ret.getResultSetEpr();
    }

    public ArrayList<String> getSearchQueryTerms() {
        return this.searchQueryTerms;
    }
}

