/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.resource.impl;

import java.rmi.RemoteException;
import java.util.List;
import org.gcube.application.framework.core.security.PortalSecurityManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.resource.MetadataCollectionI;
import org.gcube.application.framework.resource.model.ISMetadataCollection;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.informationsystem.publisher.ISPublisherException;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.security.GCUBESecurityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataCollection
implements MetadataCollectionI {
    protected static ISPublisher publisher = null;
    protected static ISClient client = null;
    ASLSession session;

    public MetadataCollection(String extrenalSessionID, String username) {
        this.session = SessionManager.getInstance().getASLSession(extrenalSessionID, username);
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (client == null) {
            try {
                client = (ISClient)GHNContext.getImplementation(ISClient.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                client = null;
            }
        }
    }

    public MetadataCollection(ASLSession session) {
        this.session = session;
        try {
            publisher = (ISPublisher)GHNContext.getImplementation(ISPublisher.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (client == null) {
            try {
                client = (ISClient)GHNContext.getImplementation(ISClient.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                client = null;
            }
        }
    }

    @Override
    public List<ISMetadataCollection> getMetadataCollectionById(String id) throws RemoteException {
        return null;
    }

    @Override
    public List<ISMetadataCollection> getMetadataCollectionByType(String type) throws RemoteException {
        return null;
    }

    @Override
    public void remove(String id) throws RemoteException {
        try {
            publisher.removeGCUBEResource(id, "MetadataCollection", this.session.getScope(), (GCUBESecurityManager)new PortalSecurityManager(this.session));
        }
        catch (ISPublisherException e) {
            e.printStackTrace();
            throw new RemoteException();
        }
    }

    @Override
    public void update(ISMetadataCollection toUpdate) throws RemoteException {
        try {
            GCUBEMCollectionQuery query = (GCUBEMCollectionQuery)client.getQuery(GCUBEMCollectionQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", toUpdate.getId())});
            List resourceList = client.execute((ISQuery)query, this.session.getScope());
            GCUBEMCollection resource = (GCUBEMCollection)resourceList.get(0);
            resource.setDescription(toUpdate.getDescription());
            resource.setCreator(toUpdate.getCreator());
            resource.setName(toUpdate.getName());
            resource.setUserCollection(toUpdate.isUserCollection());
            resource.setEditable(toUpdate.isEditable());
            resource.setNumberOfMembers(toUpdate.getNumberOfMembers());
            publisher.updateGCUBEResource((GCUBEResource)resource, this.session.getScope(), (GCUBESecurityManager)new PortalSecurityManager(this.session));
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new RemoteException("Unable to find the selected resource by id");
        }
        catch (ISClient.ISUnsupportedQueryException e) {
            e.printStackTrace();
            throw new RemoteException("Unsupported query exception");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RemoteException("Instatation exception");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RemoteException("Illegal Access Exception");
        }
        catch (ISClient.ISMalformedQueryException e) {
            e.printStackTrace();
            throw new RemoteException("Malformed Query Exception");
        }
        catch (ISException e) {
            e.printStackTrace();
            throw new RemoteException("ISException");
        }
    }
}

