/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.contentmanagement.content.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentManager {
    private static final Logger logger = LoggerFactory.getLogger(ContentManager.class);
    protected static Thread thread = new CleanContentThread();
    protected static ContentManager contentManager = new ContentManager();
    protected InputStream rafile = null;

    protected ContentManager() {
        thread.setDaemon(true);
        thread.start();
    }

    public static ContentManager getInstance() {
        return contentManager;
    }

    public String getObject(DigitalObject d_o, String elementType) throws IllegalStateException, IOException {
        return d_o.getContent();
    }

    protected void finalize() throws Throwable {
        thread.interrupt();
        logger.info(new Date(System.currentTimeMillis()) + " clean thread was interrupted");
        thread.join();
        logger.info(new Date(System.currentTimeMillis()) + " clean thread was joint");
        super.finalize();
    }

    protected static class CleanContentThread
    extends Thread {
        protected CleanContentThread() {
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception:", (Throwable)e);
                    logger.info(new Date(System.currentTimeMillis()) + " clean content thread was interrupted (in clean content thread)");
                    break;
                }
                File dir = new File(System.getProperty("java.io.tmpdir") + "/content/");
                File[] filePaths = dir.listFiles();
                HashMap<File, Long> filesMap = new HashMap<File, Long>();
                HashMap tempMap = new HashMap();
                logger.info("In content thread size: " + filePaths.length);
                for (int i = 0; i < filePaths.length; ++i) {
                    filesMap.put(filePaths[i], new Long(filePaths[i].lastModified()));
                }
                for (File tmpFile : filesMap.keySet()) {
                    tempMap.put(tmpFile, filesMap.get(tmpFile));
                }
                ArrayList mapKeys = new ArrayList(tempMap.keySet());
                ArrayList mapValues = new ArrayList(tempMap.values());
                LinkedHashMap sortedMap = new LinkedHashMap();
                TreeSet sortedSet = new TreeSet(mapValues);
                Object[] sortedArray = sortedSet.toArray();
                int size = sortedArray.length;
                for (int i = 0; i < size; ++i) {
                    sortedMap.put(mapKeys.get(mapValues.indexOf(sortedArray[i])), (Long)sortedArray[i]);
                }
                int k = 0;
                mapKeys = new ArrayList(((HashMap)sortedMap).keySet());
                int i = 0;
                while (true) {
                    if (i >= mapKeys.size() || k >= 10) continue block2;
                    logger.info("Deleting file: " + mapKeys.get(i));
                    ((File)mapKeys.get(i)).delete();
                    ++k;
                    ++i;
                }
                break;
            }
        }
    }
}

