package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.http.error.messages.HTTPErrorMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Servlet implementation class ContentInfo
 */
public class ContentInfo extends HttpServlet {
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(ContentInfo.class);
	
	private static final long serialVersionUID = 1L;
	
	private static final String operationID = "ShowContentInfos";
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public ContentInfo() {
        super();
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		//-- Check if the user is authenticated
		AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall(request, operationID);
		if (!authenticationResp.isAuthenticated()) {
			response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
			return;
		}

		String username = authenticationResp.getUserId();
//		if (request.getParameter("contentIdentification") == null || request.getParameter("contentIdentification").equals("")) {
//			response.sendError(400, "No content object identification given");
//			return;
//		}
//		JSONObject jsonO = null;
//		try {
//			jsonO = (JSONObject) JSONSerializer.toJSON(request.getParameter("contentIdentification"));
//		} catch (Exception e) {
//			response.sendError(400, HTTPErrorMessages.WrongJSONInput("contentIdentification"));
//		}
//		if (request.getParameter("contentIdentification") == null) {
//			response.sendError(400, "contentIdentification parameter must be in JSON format");
//			return;
//		}
//		String colId = jsonO.getString("CID");
//		String oid = jsonO.getString("OID");
		
		String documentURI = request.getParameter("documentURI");
		
		
		ASLSession aslSession = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
		DigitalObject digObj = new DigitalObject(aslSession, documentURI);
		String mime = "";
		long length = 0;
		
		// Get the mime type
		mime = digObj.getMimeType();
		// Get the length
		length = digObj.getLength();
		// Get the name
		//TODO this should not be the collection name
		String name = digObj.getCollectionName();
		
		String oid = digObj.getObjectId();
		String colId = digObj.getCollectionID();
		
		if (name.equals("unknown") && mime.equals("unknown/unknown") && (length == 0 || length == -1)) {
			response.sendError(400, "Wrong content object id given - Everything is unknown!");
			return;
		}
		
		/**********************/
		/* Create the JSON response Object */
		if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("") ||request.getParameter("responseType").equals("json")) {
			response.setContentType("application/json");

			JSONObject responseObject = new JSONObject();
			responseObject.put("OID", oid);
			responseObject.put("CID", colId);
			responseObject.put("Name", name);
			responseObject.put("MimeType", mime);
			responseObject.put("Length", length);

			PrintWriter out = response.getWriter();
			out.print(responseObject);
			out.flush();
			out.close();
		}
		/**********************/
		else {
			DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
			DocumentBuilder docBuilder = null;
			try {
				docBuilder = dbfac.newDocumentBuilder();
			} catch (ParserConfigurationException exep) {
				logger.error("Exception:", exep);
			} 

			Document doc = docBuilder.newDocument();
			Element root = doc.createElement("ContentInfos");
			doc.appendChild(root);

			Element nameEl = doc.createElement("Name");
			nameEl.setTextContent(name);
			root.appendChild(nameEl);

			Element oidEl = doc.createElement("ObjectId");
			oidEl.setTextContent(oid);
			root.appendChild(oidEl);

			Element mimeEl = doc.createElement("MimeType");
			mimeEl.setTextContent(mime); 
			root.appendChild(mimeEl);

			Element lengthEl = doc.createElement("Length");
			lengthEl.setTextContent(String.valueOf(length));
			root.appendChild(lengthEl);

			response.setContentType("text/xml");
			PrintWriter out = response.getWriter();
			String xmlToStr = "";	
			StringWriter writer = new StringWriter();
			try {
				DOMSource domSource =new DOMSource(doc);
				StreamResult result = new StreamResult(writer);
				TransformerFactory tf = TransformerFactory.newInstance();
				Transformer transformer = tf.newTransformer();
				transformer.transform(domSource, result);
			} catch (Exception exep) {
				logger.error("Exception:", exep);
			}

			xmlToStr = writer.toString();
			logger.info(xmlToStr);
			out.write(xmlToStr);

			out.close();
		}
		
	} 

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
