package org.gcube.application.framework.http.content.access;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.contentmanagement.util.ElementTypeConstants;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Servlet implementation class MetadataViewer
 */
public class MetadataViewer extends HttpServlet {
	
	/** The logger. */
	private static final Logger logger = LoggerFactory.getLogger(MetadataViewer.class);
	
	private static final long serialVersionUID = 1L;
	
	private static final String operationID = "GetMetadata";

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public MetadataViewer() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		/*HttpSession session = request.getSession();
		//-- Check if the user is authenticated
		AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall(request, operationID);
		if (!authenticationResp.isAuthenticated()) {
			response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
			return;
		}

		String username = authenticationResp.getUserId();
		
		String metadataCollection = request.getParameter("MetadataCollection");
		String moId = request.getParameter("MID");
		String cid = request.getParameter("CID");
		String oid = request.getParameter("OID");
		String documentURI = request.getParameter("documentURI");
		String schema = request.getParameter("schema");
		String language = request.getParameter("language");
		String xmlMetadata = new String();

		ASLSession aslSession = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);

		if (metadataCollection != null){

			try {
				StorageManagement sms = StorageManagement.getInstance(aslSession);

				String metadataOID = sms.getRandomMetadataOID(metadataCollection);
				xmlMetadata = sms.getContentFromSMS(metadataOID);
			} catch (Exception e) {
				logger.error("Exception:", e);
				response.sendError(400, "Error retrieving Metadata Object");
				return;
			}

		} else {
			if (cid == null && documentURI == null) {
				response.sendError(400, "No collection id given");
				return;
			}
			if (oid == null && documentURI == null) {
				response.sendError(400, "No object id given");
				return;
			}
			if ((moId == null || moId.equals("")) && documentURI == null) {
				if (schema == null || schema.equals("") || language == null || language.equals("")) {
					response.sendError(400, "Specify metadata collection id or schema and language");
					return;
				}
			}

			DigitalObject digObj = null;
			if (documentURI != null) {
				digObj = new DigitalObject(aslSession, documentURI, true);
				digObj.setElementType(ElementTypeConstants.metadata);
			}

			else
				digObj = new DigitalObject(aslSession, oid, cid);


			if (moId != null) {
				try {
					xmlMetadata = digObj.getMetadataFromMetadataID(moId);
					logger.info("xmlMetadata is: " + xmlMetadata);
				} catch (Exception e) {
					response.sendError(400, "Wrong metadata collection id given");
					return;
				}
			}

			if (schema != null) {
				try {
					xmlMetadata = digObj.getMetadata(schema, language);
				} catch (Exception e) {
					response.sendError(400, "Wrong schema - language given");
					return;
				}
			}
			
			if (documentURI != null) {
				xmlMetadata = convertStreamToString(digObj.getObject(ElementTypeConstants.metadata));
			}
		}
		response.setContentType("text/xml;charset=UTF-8");
		PrintWriter out = response.getWriter();
		out.write(xmlMetadata);
		out.close();  */
	} 
	
	
	private String convertStreamToString(InputStream is)
            throws IOException {
        /*
         * To convert the InputStream to String we use the
         * Reader.read(char[] buffer) method. We iterate until the
         * Reader return -1 which means there's no more data to
         * read. We use the StringWriter class to produce the string.
         */
        if (is != null) {
            Writer writer = new StringWriter();
 
            char[] buffer = new char[1024];
            try {
                Reader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                int n;
                while ((n = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, n);
                }
            } finally {
                is.close();
            }
            return writer.toString();
        } else {       
            return "";
        }
    }

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
