/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentViewer
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ContentViewer.class);
    private static final long serialVersionUID = 1L;
    private static final String operationID = "GetContent";
    private static final int maxChar = 1024;

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        if (request.getParameter("contentIdentification") == null || request.getParameter("contentIdentification").equals("")) {
            response.sendError(400, "No content object identification given");
            return;
        }
        try {
            String oid = request.getParameter("OID");
            logger.info("The CID passed is: " + oid);
            ASLSession session = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
            DigitalObject digObj = new DigitalObject(session, oid, null);
            String mime = "";
            long length = 0L;
            mime = digObj.getMimeType();
            length = digObj.getLength();
            String name = digObj.getCollectionName();
            response.addHeader("content_name", name);
            response.addHeader("contentID", oid);
            logger.info("The content type is: " + mime);
            response.setContentType(mime);
            response.addHeader("Content-Length", "0");
        }
        catch (Exception e) {
            response.sendError(500);
            return;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        try {
            String save = request.getParameter("save");
            String uri = request.getParameter("documentURI");
            logger.info("The document URI: " + uri);
            if (uri == null || uri.equals("")) {
                response.sendError(404);
                return;
            }
            ServletOutputStream out = response.getOutputStream();
            ASLSession session = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
            DigitalObject digObj = new DigitalObject(session, uri);
            String mime = "";
            long length = 0L;
            String name = "";
            String elementType = request.getParameter("elementType");
            if (elementType == null) {
                elementType = new String();
            }
            digObj.setType(elementType);
            mime = digObj.getMimeType();
            length = digObj.getLength();
            name = digObj.getCollectionName();
            String oid = digObj.getObjectId();
            response.addHeader("content_name", name);
            response.addHeader("Content-Name", name);
            response.addHeader("contentID", oid);
            if (mime == null) {
                response.addHeader("content-disposition", "attachment; filename=" + name);
                response.setContentType("unknown/unknown");
            } else if (mime.contains("text/uri-list")) {
                response.setContentType("text/html");
                out.write("<html> <head> <meta http-equiv=\"Refresh\" content=\"0;url=".getBytes());
            } else if (mime.contains("application")) {
                response.setHeader("Content-Disposition", "attachment");
            } else {
                logger.info("The content type is: " + mime);
                logger.info("The content name is: " + name);
                response.setContentType(mime);
                if (length > 0L) {
                    response.setContentLength((int)length);
                }
                response.addHeader("content_name", name);
                response.addHeader("Content-Name", name);
                if (save != null && save.equals("true")) {
                    response.addHeader("content-disposition", "attachment; filename=" + name);
                }
            }
            byte[] buf = new byte[1024];
            logger.info("About to get object");
            InputStream in = digObj.getObject();
            logger.info("Got the object " + in.toString());
            IOUtils.copy((InputStream)in, (OutputStream)out);
            if (mime != null && mime.contains("text/uri-list")) {
                out.write("\" /> </head></html>".getBytes());
            }
            char[] newarr = new String(buf).toCharArray();
            String content = new String(buf);
            logger.info("Content to string: " + content);
            logger.info("Printing outToString: " + out.toString());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

