/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.content.access;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.gcube.application.framework.sms.StorageManagement;

public class MetadataViewer
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String operationID = "GetMetadata";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        String metadataCollection = request.getParameter("MetadataCollection");
        String moId = request.getParameter("MID");
        String cid = request.getParameter("CID");
        String oid = request.getParameter("OID");
        String documentURI = request.getParameter("documentURI");
        String schema = request.getParameter("schema");
        String language = request.getParameter("language");
        String xmlMetadata = new String();
        ASLSession aslSession = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
        if (metadataCollection != null) {
            try {
                StorageManagement sms = StorageManagement.getInstance((ASLSession)aslSession);
                String metadataOID = sms.getRandomMetadataOID(metadataCollection);
                xmlMetadata = sms.getContentFromSMS(metadataOID);
            }
            catch (Exception e) {
                e.printStackTrace();
                response.sendError(400, "Error retrieving Metadata Object");
                return;
            }
        }
        if (cid == null && documentURI == null) {
            response.sendError(400, "No collection id given");
            return;
        }
        if (oid == null && documentURI == null) {
            response.sendError(400, "No object id given");
            return;
        }
        if ((moId == null || moId.equals("")) && documentURI == null && (schema == null || schema.equals("") || language == null || language.equals(""))) {
            response.sendError(400, "Specify metadata collection id or schema and language");
            return;
        }
        DigitalObject digObj = null;
        if (documentURI != null) {
            digObj = new DigitalObject(aslSession, documentURI, true);
            digObj.setElementType("metadata");
        } else {
            digObj = new DigitalObject(aslSession, oid, cid);
        }
        if (moId != null) {
            try {
                xmlMetadata = digObj.getMetadataFromMetadataID(moId);
                System.out.println("xmlMetadata is: " + xmlMetadata);
            }
            catch (Exception e) {
                response.sendError(400, "Wrong metadata collection id given");
                return;
            }
        }
        if (schema != null) {
            try {
                xmlMetadata = digObj.getMetadata(schema, language);
            }
            catch (Exception e) {
                response.sendError(400, "Wrong schema - language given");
                return;
            }
        }
        if (documentURI != null) {
            xmlMetadata = this.convertStreamToString(digObj.getObject("metadata"));
        }
        response.setContentType("text/xml;charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(xmlMetadata);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

