/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.http.content.access;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.gcube.application.framework.contentmanagement.content.impl.DigitalObject;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.http.anonymousaccess.management.AuthenticationResponse;
import org.gcube.application.framework.http.anonymousaccess.management.CallAuthenticationManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentInfo
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String operationID = "ShowContentInfos";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AuthenticationResponse authenticationResp = CallAuthenticationManager.authenticateCall((HttpServletRequest)request, (String)operationID);
        if (!authenticationResp.isAuthenticated()) {
            response.sendError(401, authenticationResp.getUnauthorizedErrorMessage());
            return;
        }
        String username = authenticationResp.getUserId();
        String documentURI = request.getParameter("documentURI");
        ASLSession aslSession = SessionManager.getInstance().getASLSession(request.getSession().getId(), username);
        DigitalObject digObj = new DigitalObject(aslSession, documentURI, true);
        String mime = "";
        long length = 0L;
        mime = digObj.getMimeType();
        length = digObj.getLength();
        String name = digObj.getName();
        String oid = digObj.getObjectId();
        String colId = digObj.getCollectionID();
        if (name.equals("unknown") && mime.equals("unknown/unknown") && (length == 0L || length == -1L)) {
            response.sendError(400, "Wrong content object id given - Everything is unknown!");
            return;
        }
        if (request.getParameter("responseType") == null || request.getParameter("responseType").equals("") || request.getParameter("responseType").equals("json")) {
            response.setContentType("application/json");
            JSONObject responseObject = new JSONObject();
            responseObject.put((Object)"OID", (Object)oid);
            responseObject.put((Object)"CID", (Object)colId);
            responseObject.put((Object)"Name", (Object)name);
            responseObject.put((Object)"MimeType", (Object)mime);
            responseObject.put((Object)"Length", (Object)length);
            PrintWriter out = response.getWriter();
            out.print(responseObject);
            out.flush();
            out.close();
        } else {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = dbfac.newDocumentBuilder();
            }
            catch (ParserConfigurationException exep) {
                exep.printStackTrace();
            }
            Document doc = docBuilder.newDocument();
            Element root = doc.createElement("ContentInfos");
            doc.appendChild(root);
            Element nameEl = doc.createElement("Name");
            nameEl.setTextContent(name);
            root.appendChild(nameEl);
            Element oidEl = doc.createElement("ObjectId");
            oidEl.setTextContent(oid);
            root.appendChild(oidEl);
            Element mimeEl = doc.createElement("MimeType");
            mimeEl.setTextContent(mime);
            root.appendChild(mimeEl);
            Element lengthEl = doc.createElement("Length");
            lengthEl.setTextContent(String.valueOf(length));
            root.appendChild(lengthEl);
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            String xmlToStr = "";
            StringWriter writer = new StringWriter();
            try {
                DOMSource domSource = new DOMSource(doc);
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
            xmlToStr = writer.toString();
            System.out.println(xmlToStr);
            out.write(xmlToStr);
            out.close();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

