/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.accesslogger.library.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.gcube.application.framework.accesslogger.library.AccessLoggerI;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.accesslogger.model.TemplateModel;

public class AccessLogger
implements AccessLoggerI {
    private static Logger logger = Logger.getLogger(AccessLogger.class);
    private static final String dateFormat = "yyyyMMdd";
    private static final String logFileName = "accessLog";
    private static final String fileSeparator = File.separator;
    private static final String path = System.getProperty("java.io.tmpdir") + fileSeparator + "accessLogs";
    private BufferedWriter out = null;
    private Date lastWrittenDate = null;
    private static AccessLogger accessLogger = new AccessLogger();
    private MessageHandlingThread queueWorker = new MessageHandlingThread();
    private LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue();

    private AccessLogger() {
        try {
            logger.debug((Object)"Constructing a new access logger. Create a new file if it does not exist for the current date");
            this.lastWrittenDate = new Date();
            SimpleDateFormat dFormat = new SimpleDateFormat(dateFormat);
            String parsedDate = dFormat.format(this.lastWrittenDate).toString();
            String logFileFullName = path + fileSeparator + logFileName + parsedDate + ".log";
            new File(path).mkdirs();
            File file = new File(logFileFullName);
            file.createNewFile();
            FileWriter fstream = new FileWriter(file, true);
            this.out = new BufferedWriter(fstream);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to initialize access log.", (Throwable)e);
        }
        this.queueWorker.start();
    }

    public static AccessLogger getAccessLogger() {
        return accessLogger;
    }

    @Override
    public void logEntry(String username, String vre, AccessLogEntry entry) {
        Date currentDate = new Date();
        TemplateModel tempModel = new TemplateModel(username, vre, entry.getType(), entry.getLogMessage(), currentDate);
        String logLineMsg = tempModel.createEntryLine();
        this.messageQueue.offer(logLineMsg);
    }

    private BufferedWriter getFileWriter() throws Exception {
        String lastWrittenDate;
        SimpleDateFormat dFormat = new SimpleDateFormat(dateFormat);
        Date currDate = new Date();
        String currentDate = dFormat.format(currDate).toString();
        if (!currentDate.equals(lastWrittenDate = dFormat.format(this.lastWrittenDate).toString())) {
            logger.debug((Object)("Date is: " + currentDate));
            String logFileFullName = path + fileSeparator + logFileName + currentDate + ".log";
            new File(path).mkdirs();
            File file = new File(logFileFullName);
            file.createNewFile();
            FileWriter fstream = new FileWriter(file, true);
            this.out.close();
            this.out = new BufferedWriter(fstream);
        }
        return this.out;
    }

    private class MessageHandlingThread
    extends Thread {
        public MessageHandlingThread() {
            logger.debug((Object)"Creating a message handling object in order to handle the message queue");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String messageLine = (String)AccessLogger.this.messageQueue.take();
                        BufferedWriter wr = AccessLogger.this.getFileWriter();
                        wr.write(messageLine);
                        wr.flush();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"An exception was thrown while trying to get the buffer writer.");
                    continue;
                }
                break;
            }
        }
    }
}

