/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.accesslogger.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class TemplateModel {
    private Date date;
    private String user;
    private String vre;
    private String entryType;
    private String message;
    private static final String delimiterCharacters = " -> ";
    private static final String separateCharacters = ", ";
    private static final String USER = "USER";
    private static final String VRE = "VRE";
    private static final String ENTRY_TYPE = "ENTRY_TYPE";
    private static final String MESSAGE = "MESSAGE";
    private static final String dateFormat = "yyyy-MM-dd kk:mm:ss";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static Logger logger = Logger.getLogger(TemplateModel.class);

    public TemplateModel(String user, String vre, String entryType, String message, Date currentDate) {
        this.date = currentDate;
        this.user = user;
        this.vre = vre;
        this.message = message;
        this.entryType = entryType;
    }

    public String createEntryLine() {
        String entryLine = "";
        SimpleDateFormat dFormat = new SimpleDateFormat(dateFormat);
        try {
            String dateAndTime = dFormat.format(this.date).toString();
            entryLine = entryLine + dateAndTime + separateCharacters + VRE + delimiterCharacters + this.vre + separateCharacters + USER + delimiterCharacters + this.user + separateCharacters + ENTRY_TYPE + delimiterCharacters + this.entryType + separateCharacters + MESSAGE + delimiterCharacters + this.message + SEPARATOR;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.debug((Object)"A new entry line has been created. The entry is: ");
        logger.debug((Object)entryLine);
        return entryLine;
    }
}

