# -*- coding: utf-8 -*-

import os
import glob

class GridOcrError(Exception):
    pass

##
# Input file option names.
##

# Generic options
##

"""The character used to specify lines with options."""
CFG_OPT = '@'

"""The character used to specify lines with comments."""
CFG_COMMENT = '#'

"""The character used to separate option name from its value."""
CFG_SEPARATOR = '='

"""
Character before a uri specifying, that it's an INPUT file for a job.
With no character specified it defaults to input-output.
"""
CFG_URI_INPUT = '<'
"""
Character before a uri specifying, that it's an OUTPUT file for a job.
With no character specified it defaults to input-output.
"""
CFG_URI_OUTPUT = '>'

"""
Specifies the URI to the script that is to be executed in the next submitted job.
Usage: @ script = uri
"""
OPT_SCRIPT = 'script'

"""
Specifies the URI to the software package that should be send together with the job.
It is the responsibility of the script to unpack the package so that is can use the
software contained within
Usage: @ package = uri
"""
OPT_PACKAGE = 'package'

"""
This option specifies
Usage: @ grid = grid_prefix
"""
OPT_GRID = 'grid'

"""
This option specifies command line arguments to pass to the script.
Usage: @ arguments = args
"""
OPT_ARGUMENTS = 'arguments'

"""
This option specifies the name for a group of jobs. The name will be a prefix of names
of all submitted jobs.
Usage: @ jobgroup = name
"""
OPT_JOBGROUP = 'jobgroup'

"""
This command used to indicate, that a job should be submitted right now, submitting
the buffer of documents from the previous job-send.
The remaining documents will also be sent as a job at the end of the input file.
Usage: @ submit
"""
CMD_SUBMIT = 'submit'

# D4Science specific options
##

"""
The execution scope which should be used for the next D4Science grid submission.
Usage: @ scope = scope_name
"""
OPT_SCOPE = 'scope'

"""
The user proxy to be used for a GridAdapter job.
Usage: @ proxy = path/to/proxy
"""
OPT_PROXY = 'proxy'

"""
The virtual organisation to use for the GridAdapter job.
Usage: @ vo = vo_name
"""
OPT_VO = 'vo'

# Lxbatch specific options
##

"""
The Lxbatch queue to which the next job should be submitted.
Usage: @ queue = queue_name
"""
OPT_QUEUE = 'queue'

# GRID PREFIXES
##
CFG_D4SCIENCEJDL_SUFFIX = 'd4science_jdl'
CFG_D4SCIENCEGRID_SUFFIX = 'd4science_grid'
CFG_LXBATCH_SUFFIX = 'lxbatch'

# General configuration
##
CFG_TMPDIR = '.tmp/'
CFG_PATH_CONFIG = os.path.expanduser('~/.gridsubmit')
CFG_INPUT_EXT = '.job'
CFG_OUTPUT_EXT = '.out'
CFG_FAIL_EXT = '.fail'
CFG_STDOUT_EXT = '.stdout'
CFG_STDERR_EXT = '.stderr'
CFG_TMP_EXT = '.tmp'


# D4Science configuration
##
CFG_JAVA_CMD = 'java'
CFG_PATH_WSCLIENT = '/home/jullass/proj/cern/ext/wsclient'
CFG_PATH_GLOBUS = '/home/jullass/proj/cern/ext/gCore'
CFG_EXEC_EXT = '.exec'
ret = ["%s" % CFG_PATH_GLOBUS,
       "%s/config" % CFG_PATH_GLOBUS,
       "%s/build/classes" % CFG_PATH_GLOBUS]
ret.extend(glob.glob("%s/lib/*.jar" % CFG_PATH_GLOBUS))
ret.extend(glob.glob("%s/lib/*.jar" % CFG_PATH_WSCLIENT))
CFG_D4SCIENCE_CLASSPATH = os.pathsep.join(ret) 

# Lxbatch configuration
##
CFG_PATH_AFSSCRAPSPACE = '/afs/cern.ch/user/j/jsompols/w0'
CFG_BSUB_CMD = '/usr/bin/bsub'
