#!/bin/sh

echo "JDL OCR single start."
echo "uname"
uname -a
cat /etc/redhat-release

echo "which pdfopt"
which pdfopt

#if Ocropus does not exists under GLOBUS_LOCATION, we will extract the .tar.gz.gz file whose name is passed as parameter $1
if [ ! -z  "$1"  ]; then
	echo     ""
	echo 	 "Ocropus was sent and will be extracted,run the job and removed again (input tar.gz.gz file: $1 )"
        tar -xzf $1
	export OCROPUS_PATH=./ocropus-0.3.1-i386
	ls -la
#if Ocropus is supposed to be installed on the node
else
        echo ""
     	echo "Ocropus is already installed on node."
	#a workaround of problems with ocropus being under GLOBUS_LOCATION: we just copy it in cwd
	cp -r $GLOBUS_LOCATION/ocropus-0.3.1-i386 .
	export OCROPUS_PATH=./ocropus-0.3.1-i386
        ls -la
fi


PYTHON_MAIN=$OCROPUS_PATH/run.py

export OCROSCRIPTS=$OCROPUS_PATH/share/ocropus/scripts
export OCRODATA=$OCROPUS_PATH/share/ocropus
export TESSDATA_PREFIX=$OCROPUS_PATH/share/
export LD_LIBRARY_PATH=$OCROPUS_PATH/lib
export PYTHONPATH=$OCROPUS_PATH/python
if [ -z "$PYTHONPATH" ] ; then
  export PYTHONPATH=$OCROPUS_PATH/python:$PYTHONPATH
else
  export PYTHONPATH=$OCROPUS_PATH/python
fi

echo "OCR starting...    (executing $PYTHON_MAIN ) "
python $PYTHON_MAIN
echo "OCR finished..."

if [ ! -z "$1" ]; then
	echo "Deleting temporary dir copied $OCROPUS_PATH"
	rm -rf $OCROPUS_PATH
fi

rm -rf conversion* tmp*


if [ $? != 0 ]
then
	echo "An error has occured above"
	exit 1
else
	echo "No errors occured"
	exit 0
fi
