/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Maps
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(Maps.class);
    private static final String SUITABLE = "suitable";
    private static final String SUITABLE_2050 = "suitable/2050";
    private static final String NATIVE = "native";
    private static final String NATIVE_2050 = "native/2050";
    private static Common common = Common.get();
    private static final long serialVersionUID = 3628994804078627741L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        InputStream is = null;
        try {
            String scientificName = req.getParameter("species");
            if (scientificName == null) {
                throw new InvalidRequestException();
            }
            scientificName = scientificName.toLowerCase();
            String mapType = req.getPathInfo().substring(1);
            resp.setContentType("image/jpeg");
            if (mapType.equals(SUITABLE)) {
                is = common.getSuitableMap(scientificName);
            } else if (mapType.equals(SUITABLE_2050)) {
                is = common.getSuitable2050Map(scientificName);
            } else if (mapType.equals(NATIVE)) {
                is = common.getNativeMap(scientificName);
            } else if (mapType.equals(NATIVE_2050)) {
                is = common.getNative2050Map(scientificName);
            } else {
                throw new InvalidRequestException();
            }
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (IOException e) {
            is = common.getImageNotFound();
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (ImageNotFoundException e) {
            is = common.getImageNotFound();
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (InvalidRequestException e) {
            resp.setStatus(400);
        }
        catch (Exception e) {
            logger.error("Unexpected error ", (Throwable)e);
            resp.setStatus(500);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
            try {
                IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
    }
}

