/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.DataManagementInterface;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.SpeciesCSVLineProcessor;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpeciesInfoImportThread
extends Thread {
    private static final GCUBELog logger = new GCUBELog(SpeciesInfoImportThread.class);
    private Properties props;

    public SpeciesInfoImportThread(Properties props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Hashtable configuration = (Hashtable)this.props.clone();
            try {
                GCUBEScope scope = GCUBEScope.getScope((String)((String)configuration.get("SCOPE")));
                logger.trace((Object)("Fetching info in scope " + scope));
                AquaMapsServiceInterface as = AquaMapsServiceCall.getCall((GCUBEScope)scope, (String)"", (boolean)true);
                DataManagementInterface dmService = DataManagementCall.getCall((GCUBEScope)scope, (String)"", (boolean)true);
                int hspenID = 0;
                for (Field f : dmService.getDefaultSources()) {
                    if (!f.getName().equals(ResourceType.HSPEN + "")) continue;
                    hspenID = f.getValueAsInteger();
                    logger.debug((Object)("Using hspen id " + hspenID));
                    break;
                }
                File toRead = as.getCSVSpecies(hspenID, null, null);
                CSVReaderProcessor processor = new CSVReaderProcessor();
                processor.setDelimiter(',');
                processor.setHasHeader(true);
                SpeciesCSVLineProcessor lineProcessor = new SpeciesCSVLineProcessor(scope, Integer.parseInt((String)configuration.get("SUITABLE_ID")), Integer.parseInt((String)configuration.get("SUITABLE_2050_ID")), Integer.parseInt((String)configuration.get("NATIVE_ID")), Integer.parseInt((String)configuration.get("NATIVE_2050_ID")));
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(toRead), Charset.defaultCharset());
                processor.processStream((Reader)reader, (CSVLineProcessor)lineProcessor);
                logger.trace((Object)("Fetched " + lineProcessor.getCount()));
                Common.get().setLastCompletedUpdate(Long.valueOf(System.currentTimeMillis()));
                Common.get().setLastConfiguration((Map)configuration);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)"Unexpected Error ", e);
                continue;
            }
            finally {
                try {
                    long minutes = Long.parseLong((String)configuration.get("FETCH_ROUTINE_INTERVAL_MINUTES"));
                    logger.trace((Object)("Going to execute again in " + minutes + " min"));
                    SpeciesInfoImportThread.sleep((long)(minutes * 60L * 1000L));
                }
                catch (InterruptedException e) {
                }
                catch (Throwable t) {
                    logger.fatal((Object)"Unexpected exception ", t);
                }
                continue;
            }
            break;
        }
    }
}

