/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.client;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.WindowResizeListener;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.AquaMapsSpeciesView;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.constants.AquaMapsSpeciesViewConstants;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.maps.MapsResultsPanel;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.AquaMapsSpeciesViewLocalService;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.AquaMapsSpeciesViewLocalServiceAsync;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.search.SpeciesSearchForm;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.species.SpeciesResultsPanel;
import org.gcube.portlets.widgets.guidedtour.client.GCUBEGuidedTour;
import org.gcube.portlets.widgets.guidedtour.client.types.ThemeColor;
import org.gcube.portlets.widgets.guidedtour.client.types.VerticalAlignment;
import org.gcube.portlets.widgets.guidedtour.shared.TourLanguage;

public class AquaMapsSpeciesView
implements EntryPoint {
    public static AquaMapsSpeciesViewLocalServiceAsync localService = (AquaMapsSpeciesViewLocalServiceAsync)GWT.create(AquaMapsSpeciesViewLocalService.class);
    private static AquaMapsSpeciesView singleton;
    private String sessionID = "";
    private static ServiceDefTarget localeEndpoint;
    private static final String tourImagesFolder = "tourImages/";
    public ContentPanel mainPanel;
    public SpeciesSearchForm search;
    public MapsResultsPanel maps;
    public SpeciesResultsPanel speciesResults;
    public BorderLayoutData northData = new BorderLayoutData(Style.LayoutRegion.NORTH);
    BorderLayoutData centerData = new BorderLayoutData(Style.LayoutRegion.CENTER);

    public AquaMapsSpeciesView() {
        this.sessionID = Cookies.getCookie((String)"JSESSIONID");
        AquaMapsSpeciesViewConstants.init((String)this.sessionID);
        localeEndpoint.setServiceEntryPoint((String)AquaMapsSpeciesViewConstants.servletUrl.get("AquaMapsSpeciesViewLocalImpl"));
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public static AquaMapsSpeciesView get() {
        return singleton;
    }

    public void onModuleLoad() {
        singleton = this;
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onModuleLoad2() {
        this.search = new SpeciesSearchForm();
        this.speciesResults = new SpeciesResultsPanel();
        this.mainPanel = new ContentPanel();
        this.mainPanel.setLayout((Layout)new BorderLayout());
        this.mainPanel.setHeaderVisible(false);
        this.northData.setCollapsible(true);
        this.northData.setSize(80.0f);
        this.mainPanel.add((Widget)this.search, (LayoutData)this.northData);
        this.mainPanel.add((Widget)this.speciesResults, (LayoutData)this.centerData);
        localService.getSessionSettings((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get((String)AquaMapsSpeciesViewConstants.COMMONGUIDIV).add((Widget)this.mainPanel);
        Window.addWindowResizeListener((WindowResizeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.updateSize();
        this.showGuidedTour();
        String mapId = Window.Location.getParameter((String)"mapId");
        if (mapId != null) {
            Log.debug((String)("Found map Id " + mapId + ", loading data.."));
            this.mainPanel.mask("Loading map [ID : " + mapId + "]information..");
            localService.loadSpeciesByMapsId(mapId, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateSize() {
        Log.debug((String)"Updating size..");
        RootPanel workspace = RootPanel.get((String)AquaMapsSpeciesViewConstants.COMMONGUIDIV);
        int topBorder = workspace.getAbsoluteTop();
        int leftBorder = workspace.getAbsoluteLeft();
        int rightScrollBar = 17;
        int rootHeight = Window.getClientHeight() - topBorder - 4;
        int rootWidth = Window.getClientWidth() - 2 * leftBorder - rightScrollBar;
        Log.trace((String)("New  dimension Height: " + rootHeight + " Width: " + rootWidth));
        this.mainPanel.setHeight(rootHeight);
        this.mainPanel.setWidth(rootWidth);
        this.mainPanel.layout(true);
        this.printData();
    }

    protected void printData() {
        Log.trace((String)("Client Height: " + Window.getClientHeight()));
        Log.trace((String)("Client Width: " + Window.getClientWidth()));
        Log.trace((String)("Absolute Left: " + RootPanel.get((String)AquaMapsSpeciesViewConstants.COMMONGUIDIV).getAbsoluteLeft()));
        Log.trace((String)("Absolute Top: " + RootPanel.get((String)AquaMapsSpeciesViewConstants.COMMONGUIDIV).getAbsoluteTop()));
        Log.trace((String)("Offset Height: " + RootPanel.get((String)AquaMapsSpeciesViewConstants.COMMONGUIDIV).getOffsetHeight()));
        Log.trace((String)("Offset Width: " + RootPanel.get((String)AquaMapsSpeciesViewConstants.COMMONGUIDIV).getOffsetWidth()));
    }

    public void switchToMapsView(String scientificName) {
        this.mainPanel.mask("Switching to Maps Mode");
        this.search.mask("Displaying maps for species " + scientificName);
        this.search.advanced.collapse();
        if (this.maps == null) {
            this.maps = new MapsResultsPanel();
        }
        this.mainPanel.remove((Widget)this.speciesResults);
        this.mainPanel.add((Widget)this.maps, (LayoutData)this.centerData);
        this.maps.reload();
        this.mainPanel.layout();
        this.mainPanel.unmask();
    }

    public void switchToSpeciesView() {
        this.mainPanel.mask("Switching to Species Mode");
        this.search.unmask();
        if (this.speciesResults == null) {
            this.speciesResults = new SpeciesResultsPanel();
        }
        this.mainPanel.remove((Widget)this.maps);
        this.mainPanel.add((Widget)this.speciesResults, (LayoutData)this.centerData);
        this.speciesResults.reload();
        this.mainPanel.layout();
        this.mainPanel.unmask();
    }

    private void showGuidedTour() {
        GCUBEGuidedTour gt = new GCUBEGuidedTour("Species View", "org.gcube.application.aquamaps.aquamapsspeciesview.client.AquaMapsSpeciesView", "https://gcube.wiki.gcube-system.org/gcube/index.php/AquaMaps", 800, 400, false, ThemeColor.BLUE, new TourLanguage[]{TourLanguage.EN});
        5 introStep = new /* Unavailable Anonymous Inner Class!! */;
        introStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)introStep);
        6 viewsStep = new /* Unavailable Anonymous Inner Class!! */;
        viewsStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)viewsStep);
        7 filtersStep = new /* Unavailable Anonymous Inner Class!! */;
        filtersStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)filtersStep);
        8 mapsStep = new /* Unavailable Anonymous Inner Class!! */;
        mapsStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)mapsStep);
        gt.openTour();
    }

    static {
        localeEndpoint = (ServiceDefTarget)localService;
    }
}

