/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.Analyzer;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalyzerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerManager {
    static final Logger logger = LoggerFactory.getLogger(AnalyzerManager.class);
    private static GenericObjectPool analyzerPool = new GenericObjectPool((PoolableObjectFactory)new AnalyzerFactory());

    public static Analyzer getBatch() throws Exception {
        return (Analyzer)analyzerPool.borrowObject();
    }

    public static void leaveBatch(Analyzer theBatch) throws Exception {
        analyzerPool.returnObject((Object)theBatch);
    }

    static {
        try {
            analyzerPool.setLifo(false);
            analyzerPool.setMaxActive(ServiceContext.getContext().getPropertyAsInteger("ANALYZER_BATCH_POOL_SIZE").intValue());
            analyzerPool.setWhenExhaustedAction((byte)1);
            for (int i = 0; i < analyzerPool.getMaxActive(); ++i) {
                analyzerPool.addObject();
            }
            logger.debug("Added " + analyzerPool.getMaxActive() + " objects to source generator pool");
        }
        catch (Exception e) {
            logger.error("Unable to init batch pool", (Throwable)e);
        }
    }
}

