/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.publisher.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.Servlet;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.PublisherConfiguration;
import org.gcube.application.aquamaps.publisher.ReportDescriptor;
import org.gcube.application.aquamaps.publisher.StoreConfiguration;
import org.gcube.application.aquamaps.publisher.StoreResponse;
import org.gcube.application.aquamaps.publisher.impl.datageneration.ObjectManager;
import org.gcube.application.aquamaps.publisher.impl.model.ContextLayerPair;
import org.gcube.application.aquamaps.publisher.impl.model.CoverageDescriptor;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube.application.aquamaps.publisher.impl.model.Storable;
import org.gcube.application.aquamaps.publisher.impl.model.WMSContext;
import org.gcube.application.aquamaps.publisher.impl.model.searchsupport.FileSetSpeciesIdPair;
import org.gcube.application.aquamaps.publisher.impl.model.searchsupport.LayerSpeciesIdPair;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherImpl
extends Publisher {
    protected static final Logger logger = LoggerFactory.getLogger(PublisherImpl.class);
    private static final int MAX_THREADS = 5;
    private static Hashtable<CoverageDescriptor, Future> futuresMap = new Hashtable();
    private static PublisherImpl instance = null;
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);
    public static String webServerUrl;
    public static File serverPathDir;

    public static PublisherImpl get() {
        if (instance == null) {
            instance = new PublisherImpl();
        }
        return instance;
    }

    @Override
    public ReportDescriptor initialize(PublisherConfiguration configuration) throws Exception {
        logger.info("connecting to db with " + configuration.getDBUser() + " " + configuration.getDBPassword() + " " + configuration.getDBHost());
        DBSession.initialize((String)"org.gcube.dbinterface.postgres", (String)configuration.getDBUser(), (String)configuration.getDBPassword(), (String)configuration.getDBHost());
        logger.info("connecting to jetty with  " + configuration.getPersistenceRoot() + " " + configuration.getHttpServerBasePath() + " " + configuration.getHttpServerPort());
        this.startWebserver(configuration.getPersistenceRoot(), configuration.getHttpServerBasePath(), configuration.getHttpServerPort());
        return new ReportDescriptor();
    }

    private void startWebserver(File persistenceRoot, String httpServerBasePath, int httpServerPort) throws Exception {
        logger.debug("HTTP Server Base path = " + httpServerBasePath);
        serverPathDir = new File(persistenceRoot + File.separator + httpServerBasePath);
        if (!serverPathDir.exists()) {
            serverPathDir.mkdirs();
        }
        logger.debug("HTTP Server port = " + httpServerPort);
        webServerUrl = "http://" + GHNContext.getContext().getHostname() + ":" + httpServerPort + "/";
        logger.debug("WEBSERVER URL: " + webServerUrl);
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(httpServerPort);
        Server server = new Server(httpServerPort);
        server.setConnectors(new Connector[]{connector});
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(serverPathDir.getAbsolutePath());
        try {
            ContextHandlerCollection contexts = new ContextHandlerCollection();
            Context ctxADocs = new Context((HandlerContainer)contexts, "/", 1);
            ctxADocs.setResourceBase(serverPathDir.getAbsolutePath());
            ServletHolder ctxADocHolder = new ServletHolder();
            ctxADocHolder.setInitParameter("dirAllowed", "true");
            ctxADocHolder.setServlet((Servlet)new DefaultServlet());
            ctxADocs.addServlet(ctxADocHolder, "/");
            server.setHandlers(new Handler[]{resourceHandler, contexts});
            server.start();
            contexts.start();
            for (Handler h : server.getHandlers()) {
                logger.trace("Handler : " + h.toString() + " running state : " + h.isRunning() + " startedState : " + h.isStarted());
            }
            logger.trace("server attributes");
            Enumeration attNames = server.getAttributeNames();
            while (attNames.hasMoreElements()) {
                String name = (String)attNames.nextElement();
                logger.trace(name + " : " + server.getAttribute(name));
            }
        }
        catch (Throwable t) {
            logger.error("", t);
        }
    }

    @Override
    public synchronized <T extends CoverageDescriptor> Future<T> get(final Class<T> clazz, final ObjectManager<T> manager, final CoverageDescriptor coverageDescriptor) throws Exception {
        logger.debug("executing get method ");
        Future toReturn = futuresMap.get(coverageDescriptor);
        if (toReturn != null) {
            logger.debug("coverag found in futuresMap, returning it");
            return toReturn;
        }
        logger.debug("futuresMap contains " + futuresMap.size());
        long start = System.currentTimeMillis();
        final HashMap<String, Object> fieldsMap = new HashMap<String, Object>(){
            {
                this.put("tableId", coverageDescriptor.getTableId());
                this.put("parameters", coverageDescriptor.getParameters());
                this.put("customized", false);
            }
        };
        if (ObjectPersistency.get(clazz).existEntryByFields((HashMap)fieldsMap)) {
            logger.debug("the object exists ");
            toReturn = executorService.submit(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    logger.debug("retuning an existing entry");
                    return (CoverageDescriptor)ObjectPersistency.get((Class)clazz).getObjectByFields(fieldsMap).get(0);
                }
            });
            logger.debug("time to execute get without store is " + (System.currentTimeMillis() - start));
            return toReturn;
        }
        logger.debug("the object not exists in the db");
        toReturn = executorService.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                long startGeneration = System.currentTimeMillis();
                logger.debug("generating the object");
                CoverageDescriptor generated = (CoverageDescriptor)manager.generate();
                generated.setCustomized(false);
                generated.setParameters(coverageDescriptor.getParameters());
                generated.setTableId(coverageDescriptor.getTableId());
                ObjectPersistency.get((Class)clazz).insert((Object)generated);
                logger.debug("time took to execute generation and insert is " + (System.currentTimeMillis() - startGeneration));
                logger.debug("futuremaps contains element before removing " + futuresMap.size());
                futuresMap.remove(coverageDescriptor);
                logger.debug("futuremaps contains element after removing " + futuresMap.size());
                return generated;
            }
        });
        futuresMap.put(coverageDescriptor, toReturn);
        logger.debug("coverage added to futuresMap");
        logger.trace("time to execute get with store is " + (System.currentTimeMillis() - start));
        return toReturn;
    }

    @Override
    public <T extends CoverageDescriptor> Iterator<T> getByCoverage(Class<T> clazz, final CoverageDescriptor descriptor) throws Exception {
        HashMap<String, Object> fieldsMap = new HashMap<String, Object>(){
            {
                this.put("tableId", descriptor.getTableId());
                this.put("parameters", descriptor.getParameters());
                if (!descriptor.isCustomized()) {
                    this.put("customized", false);
                }
            }
        };
        return ObjectPersistency.get(clazz).getObjectByFields((HashMap)fieldsMap).iterator();
    }

    @Override
    public Iterator<WMSContext> getWMSContextByLayer(String layerId) throws Exception {
        Iterator pairIt = ObjectPersistency.get(ContextLayerPair.class).getObjectByField("layerId", (Object)layerId).iterator();
        while (pairIt.hasNext()) {
        }
        return null;
    }

    @Override
    public <T extends Storable> StoreResponse<T> store(Class<T> clazz, ObjectManager<T> manager, StoreConfiguration config, final CoverageDescriptor ... descriptor) throws Exception {
        if (descriptor.length > 0 && !descriptor[0].isCustomized() && CoverageDescriptor.class.isAssignableFrom(clazz)) {
            HashMap<String, Object> fieldsMap = new HashMap<String, Object>(){
                {
                    this.put("tableId", descriptor[0].getTableId());
                    this.put("parameters", descriptor[0].getParameters());
                    this.put("customized", false);
                }
            };
            if (ObjectPersistency.get(clazz).existEntryByFields((HashMap)fieldsMap)) {
                if (config.getMode() == StoreConfiguration.StoreMode.USE_EXISTING) {
                    Storable stored = (Storable)ObjectPersistency.get(clazz).getObjectByFields((HashMap)fieldsMap).get(0);
                    return new StoreResponse<Storable>(stored, StoreResponse.PerformedOperation.USED_EXISTING);
                }
                if (config.getMode() == StoreConfiguration.StoreMode.UPDATE_EXISTING) {
                    String oldId = ((Storable)ObjectPersistency.get(clazz).getObjectByFields((HashMap)fieldsMap).get(0)).getId();
                    Storable stored = (Storable)ObjectPersistency.get(clazz).getObjectByFields((HashMap)fieldsMap).get(0);
                    Storable generated = manager.update(stored);
                    generated.setId(oldId);
                    ObjectPersistency.get(clazz).update((Object)generated);
                    return new StoreResponse<Storable>(generated, StoreResponse.PerformedOperation.UPDATED_EXISTING);
                }
                throw new Exception("error storing object");
            }
            Storable generated = (Storable)manager.generate();
            ObjectPersistency.get(clazz).insert((Object)generated);
            return new StoreResponse<Storable>(generated, StoreResponse.PerformedOperation.NEWLY_INSERTED);
        }
        Storable generated = (Storable)manager.generate();
        if (ObjectPersistency.get(clazz).existsKey((Object)generated.getId())) {
            if (config.getMode() == StoreConfiguration.StoreMode.USE_EXISTING) {
                ObjectPersistency.get(clazz).getByKey((Object)generated.getId());
                return new StoreResponse<Storable>(generated, StoreResponse.PerformedOperation.USED_EXISTING);
            }
            if (config.getMode() == StoreConfiguration.StoreMode.UPDATE_EXISTING) {
                ObjectPersistency.get(clazz).update((Object)generated);
                return new StoreResponse<Storable>(generated, StoreResponse.PerformedOperation.UPDATED_EXISTING);
            }
            throw new Exception("error storing object");
        }
        ObjectPersistency.get(clazz).insert((Object)generated);
        return new StoreResponse<Storable>(generated, StoreResponse.PerformedOperation.NEWLY_INSERTED);
    }

    @Override
    public <T extends Storable> void deleteById(Class<T> clazz, ObjectManager<T> manager, String id) throws Exception {
        manager.destroy(ObjectPersistency.get(clazz).getByKey((Object)id));
        ObjectPersistency.get(clazz).deleteByKey((Object)id);
    }

    @Override
    public <T extends Storable> T getById(Class<T> clazz, String id) throws Exception {
        return (T)((Storable)ObjectPersistency.get(clazz).getByKey((Object)id));
    }

    @Override
    public List<Layer> getLayersBySpeciesIds(String speciesId) throws Exception {
        ArrayList<Layer> toReturn = new ArrayList<Layer>();
        Iterator layerSpeciesIdPairIt = ObjectPersistency.get(LayerSpeciesIdPair.class).getObjectByField("speciesId", (Object)speciesId).iterator();
        while (layerSpeciesIdPairIt.hasNext()) {
            toReturn.add((Layer)ObjectPersistency.get(Layer.class).getByKey((Object)((LayerSpeciesIdPair)layerSpeciesIdPairIt.next()).getId()));
        }
        return toReturn;
    }

    @Override
    public List<FileSet> getFileSetsBySpeciesIds(String speciesId) throws Exception {
        ArrayList<FileSet> toReturn = new ArrayList<FileSet>();
        Iterator fileSetSpeciesIdPairIt = ObjectPersistency.get(FileSetSpeciesIdPair.class).getObjectByField("speciesId", (Object)speciesId).iterator();
        while (fileSetSpeciesIdPairIt.hasNext()) {
            toReturn.add((FileSet)ObjectPersistency.get(FileSet.class).getByKey((Object)((FileSetSpeciesIdPair)fileSetSpeciesIdPairIt.next()).getId()));
        }
        return toReturn;
    }

    @Override
    public void shutdown() throws Exception {
    }

    @Override
    public String getWebServerUrl() {
        return webServerUrl;
    }

    @Override
    public File getServerPathDir() {
        return serverPathDir;
    }
}

