/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.common.helper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISClientConnector {
    private static final Logger logger = LoggerFactory.getLogger(ISClientConnector.class);
    private String[] server;
    private String env;
    private String clientId;
    private String backendType;
    private static HashMap<String, String[]> isCache;

    public String[] getServer(String resourceType, String scope) {
        String savedScope = null;
        if (scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
        }
        logger.trace("get server from IS ");
        if (isCache != null) {
            this.server = isCache.get("MongoDBServer");
        }
        if (this.server == null) {
            if (resourceType.equalsIgnoreCase("runtimeResource")) {
                this.getServerRRFws();
            } else if (this.server != null) {
                if (isCache == null) {
                    isCache = new HashMap();
                }
                isCache.put("MongoDBServer", this.server);
                logger.info("ISCACHE: ELEMENT INSERTED ");
            }
        } else {
            logger.info("ISCACHE: ELEMENT EXTRACTED");
        }
        if (scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        return this.server;
    }

    public String getEnvironment(String secondaryType, String field) {
        return this.env;
    }

    public String getClientId(String secondaryType, String field) {
        return this.clientId;
    }

    public String[] getServerRRFws() {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources.size() >= 1) {
            logger.info("found " + resources.size() + " RR ");
            return this.getServers(resources);
        }
        logger.error("RUNTIME RESOURCE NOT FOUND IN THIS SCOPE " + ScopeProvider.instance.get());
        throw new RuntimeException("RUNTIME RESOURCE NOT FOUND IN SCOPE: " + ScopeProvider.instance.get());
    }

    private String[] getServers(List<ServiceEndpoint> resources) {
        ServiceEndpoint defaultResource = null;
        logger.info("search RR with priority ");
        for (ServiceEndpoint res : resources) {
            String priority = this.retrievePropertyValue(res, "priority");
            if (priority == null) continue;
            defaultResource = res;
            logger.info("found a RR with priority: ");
            break;
        }
        if (defaultResource != null) {
            this.server = new String[defaultResource.profile().accessPoints().size()];
            int i = 0;
            for (ServiceEndpoint.AccessPoint ap : defaultResource.profile().accessPoints()) {
                if (!ap.name().equals("server" + (i + 1))) continue;
                this.server[i] = ap.address();
                ++i;
            }
            this.backendType = this.retrievePropertyValue(defaultResource, "type");
            logger.info("Type of backend found in RR is " + this.backendType);
            return this.server;
        }
        throw new IllegalStateException("Runtime Resource found are more than 1 but all without default priority setted");
    }

    public String getBackendType(String scope) {
        if (this.backendType != null) {
            return this.backendType;
        }
        this.backendType = this.retrievePropertyValue("type", scope);
        return this.backendType;
    }

    private String retrievePropertyValue(String name, String scope) {
        String savedScope = null;
        if (scope != null) {
            savedScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope);
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'DataStorage' and $resource/Profile/Name eq 'StorageManager' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        ServiceEndpoint res = (ServiceEndpoint)resources.get(0);
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        String value = type.value();
        if (scope != null) {
            ScopeProvider.instance.set(savedScope);
        }
        return value;
    }

    private String retrievePropertyValue(ServiceEndpoint res, String name) {
        Iterator it = res.profile().accessPoints().iterator();
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)it.next();
        Map map = ap.propertyMap();
        ServiceEndpoint.Property type = (ServiceEndpoint.Property)map.get(name);
        if (type != null) {
            return type.value();
        }
        return null;
    }
}

