/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.gcube.accounting.VersionInfo;
import org.gcube.accounting.common.helper.TimeHelper;

public class VersionHelper {
    private static Logger logger = Logger.getLogger(VersionHelper.class);
    private String resource;
    private Properties properties = new Properties();

    private VersionHelper() {
    }

    public VersionHelper(String resource) {
        this();
        this.resource = resource;
        this.loadProperties();
    }

    public VersionInfo getVersionInfo() {
        VersionInfo vi = new VersionInfo();
        vi.setBuildDate(this.getFormattedBuildDate());
        vi.setBuildId(this.getBuildId());
        vi.setBuildNumber(this.getBuildNumber());
        return vi;
    }

    private void loadProperties() {
        InputStream in = this.getClass().getResourceAsStream(this.resource);
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Calendar getBuildDate() {
        String value = this.properties.getProperty("build.date");
        if (value == null || value.isEmpty()) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        try {
            Date date = formatter.parse(value);
            Calendar out = Calendar.getInstance();
            out.setTime(date);
            return out;
        }
        catch (ParseException e) {
            logger.warn((Object)("unparseable version string: " + value));
            return null;
        }
    }

    public String getFormattedBuildDate() {
        Calendar c = this.getBuildDate();
        if (c != null) {
            return TimeHelper.format(c, true);
        }
        return "unknown";
    }

    public String getBuildNumber() {
        return this.properties.getProperty("build.number", "unknown");
    }

    public String getBuildId() {
        return this.properties.getProperty("build.id", "unknown");
    }

    public static void main(String[] args) {
        VersionHelper vh = new VersionHelper("/org/venusc/mab/usagetracker/version.properties");
        System.out.println(vh.getFormattedBuildDate());
        System.out.println(vh.getBuildNumber());
        System.out.println(vh.getBuildId());
    }
}

