/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.cache;

import com.esotericsoftware.kryo.Kryo;
import com.google.common.base.Stopwatch;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.ForwardingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.directmemory.measures.Ram;
import org.apache.directmemory.memory.MemoryManagerService;
import org.apache.directmemory.memory.MemoryManagerServiceImpl;
import org.apache.directmemory.memory.Pointer;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.CachedNodeDocument;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.cache.ForwardingListener;
import org.apache.jackrabbit.oak.plugins.document.cache.KryoFactory;
import org.apache.jackrabbit.oak.plugins.document.cache.KryoSerializer;
import org.apache.jackrabbit.oak.plugins.document.cache.OffHeapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDocOffHeapCache
extends ForwardingCache.SimpleForwardingCache<CacheValue, NodeDocument>
implements Closeable,
OffHeapCache {
    private final AbstractCache.StatsCounter statsCounter = new AbstractCache.SimpleStatsCounter();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Cache<CacheValue, NodeDocReference> offHeapCache;
    private final CacheStats offHeapCacheStats;
    private final MemoryManagerService<NodeDocument> memoryManager;
    private final KryoSerializer serializer;

    public NodeDocOffHeapCache(Cache<CacheValue, NodeDocument> delegate, ForwardingListener<CacheValue, NodeDocument> forwardingListener, DocumentMK.Builder builder, DocumentStore documentStore) {
        super(delegate);
        forwardingListener.setDelegate(new PrimaryRemovalListener());
        long maxMemory = builder.getOffHeapCacheSize();
        this.offHeapCache = CacheBuilder.newBuilder().weigher(builder.getWeigher()).maximumWeight(maxMemory).removalListener(new SecondaryRemovalListener()).recordStats().build();
        this.offHeapCacheStats = new CacheStats(this.offHeapCache, "DocumentMk-Documents-L2", builder.getWeigher(), builder.getOffHeapCacheSize());
        long bufferSize = Ram.Gb((double)1.0);
        int noOfBuffers = Math.max(1, (int)(maxMemory / bufferSize));
        int buffSize = (int)Math.min(maxMemory, bufferSize);
        this.memoryManager = new MemoryManagerServiceImpl();
        this.memoryManager.init(noOfBuffers, buffSize);
        this.serializer = new KryoSerializer(new OakKryoPool(documentStore));
    }

    @Override
    public NodeDocument getIfPresent(Object key) {
        NodeDocument result = (NodeDocument)super.getIfPresent(key);
        if (result == null) {
            result = this.retrieve(key, false);
        }
        return result;
    }

    @Override
    public NodeDocument get(final CacheValue key, final Callable<? extends NodeDocument> valueLoader) throws ExecutionException {
        return super.get(key, new Callable<NodeDocument>(){

            @Override
            public NodeDocument call() throws Exception {
                NodeDocument result = NodeDocOffHeapCache.this.retrieve(key, true);
                if (result == null) {
                    result = (NodeDocument)valueLoader.call();
                }
                return result;
            }
        });
    }

    @Override
    public ImmutableMap<CacheValue, NodeDocument> getAllPresent(Iterable<?> keys) {
        ArrayList<CacheValue> list = Lists.newArrayList(keys);
        ImmutableMap<CacheValue, NodeDocument> result = super.getAllPresent(list);
        if (result.size() == list.size()) {
            return result;
        }
        HashMap<CacheValue, NodeDocument> r2 = Maps.newHashMap(result);
        for (CacheValue key : list) {
            NodeDocument val2;
            if (result.containsKey(key) || (val2 = this.retrieve(key, false)) == null) continue;
            r2.put(key, val2);
        }
        return ImmutableMap.copyOf(r2);
    }

    @Override
    public void invalidate(Object key) {
        super.invalidate(key);
        this.offHeapCache.invalidate(key);
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        super.invalidateAll(keys);
        this.offHeapCache.invalidateAll(keys);
    }

    @Override
    public void invalidateAll() {
        super.invalidateAll();
        this.offHeapCache.invalidateAll();
    }

    @Override
    public void close() throws IOException {
        this.memoryManager.close();
        this.serializer.close();
    }

    @Override
    public Map<CacheValue, ? extends CachedNodeDocument> offHeapEntriesMap() {
        return Collections.unmodifiableMap(this.offHeapCache.asMap());
    }

    @Override
    public CacheStats getCacheStats() {
        return this.offHeapCacheStats;
    }

    @Override
    @Nullable
    public CachedNodeDocument getCachedDocument(String id) {
        NodeDocument doc = (NodeDocument)super.getIfPresent(id);
        if (doc != null) {
            return doc;
        }
        return this.offHeapCache.getIfPresent(id);
    }

    private NodeDocument retrieve(Object key, boolean invalidateAfterRetrieve) {
        Stopwatch watch = Stopwatch.createStarted();
        NodeDocReference value = this.offHeapCache.getIfPresent(key);
        if (value == null) {
            this.statsCounter.recordMisses(1);
            return null;
        }
        NodeDocument result = value.getDocument();
        if (result != null) {
            this.statsCounter.recordLoadSuccess(watch.elapsed(TimeUnit.NANOSECONDS));
        } else {
            this.statsCounter.recordMisses(1);
        }
        if (invalidateAfterRetrieve) {
            this.offHeapCache.invalidate(key);
        }
        return result;
    }

    private static class OakKryoPool
    extends KryoSerializer.KryoPool {
        private final DocumentStore documentStore;

        public OakKryoPool(DocumentStore documentStore) {
            this.documentStore = documentStore;
        }

        @Override
        protected Kryo createInstance() {
            return KryoFactory.createInstance(this.documentStore);
        }
    }

    private class NodeDocReference
    implements CachedNodeDocument,
    CacheValue {
        private final Number modCount;
        private final long created;
        private final AtomicLong lastCheckTime;
        private final Pointer<NodeDocument> documentPointer;
        private final CacheValue key;
        private final String path;

        public NodeDocReference(CacheValue key, NodeDocument doc) {
            this.modCount = doc.getModCount();
            this.created = doc.getCreated();
            this.lastCheckTime = new AtomicLong(doc.getLastCheckTime());
            this.documentPointer = this.serialize(doc);
            this.key = key;
            this.path = doc.getPath();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Number getModCount() {
            return this.modCount;
        }

        @Override
        public long getCreated() {
            return this.created;
        }

        @Override
        public long getLastCheckTime() {
            return this.lastCheckTime.get();
        }

        @Override
        public void markUpToDate(long checkTime) {
            this.lastCheckTime.set(checkTime);
        }

        @Override
        public boolean isUpToDate(long lastCheckTime) {
            return lastCheckTime <= this.lastCheckTime.get();
        }

        @CheckForNull
        public NodeDocument getDocument() {
            return this.deserialize(this.documentPointer);
        }

        @CheckForNull
        public Pointer<NodeDocument> getPointer() {
            return this.documentPointer;
        }

        @CheckForNull
        private Pointer<NodeDocument> serialize(NodeDocument doc) {
            try {
                byte[] payload = NodeDocOffHeapCache.this.serializer.serialize(doc);
                Pointer ptr = NodeDocOffHeapCache.this.memoryManager.store(payload, 0L);
                ptr.setClazz(NodeDocument.class);
                return ptr;
            }
            catch (IOException e) {
                NodeDocOffHeapCache.this.log.warn("Not able to serialize doc {}", (Object)doc.getId(), (Object)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckForNull
        private NodeDocument deserialize(@CheckForNull Pointer<NodeDocument> pointer) {
            try {
                byte[] value;
                if (pointer == null) {
                    return null;
                }
                Pointer<NodeDocument> pointer2 = pointer;
                synchronized (pointer2) {
                    value = NodeDocOffHeapCache.this.memoryManager.retrieve(pointer);
                }
                NodeDocument doc = (NodeDocument)NodeDocOffHeapCache.this.serializer.deserialize(value, pointer.getClazz());
                doc.markUpToDate(this.getLastCheckTime());
                return doc;
            }
            catch (Exception e) {
                NodeDocOffHeapCache.this.log.warn("Not able to deserialize doc {} with pointer {}", new Object[]{this.key, pointer, e});
                return null;
            }
        }

        @Override
        public int getMemory() {
            int result = 168;
            if (this.documentPointer != null) {
                result += (int)this.documentPointer.getSize();
            }
            return result;
        }
    }

    private class SecondaryRemovalListener
    implements RemovalListener<CacheValue, NodeDocReference> {
        private SecondaryRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<CacheValue, NodeDocReference> notification) {
            NodeDocReference doc = notification.getValue();
            if (doc != null && doc.getPointer() != null) {
                NodeDocOffHeapCache.this.memoryManager.free(doc.getPointer());
            }
        }
    }

    private class PrimaryRemovalListener
    implements RemovalListener<CacheValue, NodeDocument> {
        private PrimaryRemovalListener() {
        }

        @Override
        public void onRemoval(RemovalNotification<CacheValue, NodeDocument> n) {
            NodeDocument doc;
            if (n.getCause() == RemovalCause.EXPLICIT || n.getCause() == RemovalCause.REPLACED) {
                NodeDocOffHeapCache.this.offHeapCache.invalidate(n.getKey());
            }
            if (n.getCause() == RemovalCause.SIZE && (doc = n.getValue()) != NodeDocument.NULL) {
                NodeDocOffHeapCache.this.offHeapCache.put(n.getKey(), new NodeDocReference(n.getKey(), doc));
            }
        }
    }
}

