/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitDiff;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeStoreBranch;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class DocumentNodeStoreBranch
extends AbstractNodeStoreBranch<DocumentNodeStore, DocumentNodeState> {
    private final ReadWriteLock mergeLock;

    DocumentNodeStoreBranch(DocumentNodeStore store, DocumentNodeState base, ReadWriteLock mergeLock) {
        super(store, new ChangeDispatcher(store.getRoot()), mergeLock.readLock(), base, null, DocumentNodeStoreBranch.getMaxBackoffMillis(store));
        this.mergeLock = mergeLock;
    }

    @Override
    protected DocumentNodeState getRoot() {
        return ((DocumentNodeStore)this.store).getRoot();
    }

    @Override
    protected DocumentNodeState createBranch(DocumentNodeState state) {
        return ((DocumentNodeStore)this.store).getRoot(state.getRevision().asBranchRevision());
    }

    @Override
    protected DocumentNodeState rebase(DocumentNodeState branchHead, DocumentNodeState base) {
        return ((DocumentNodeStore)this.store).getRoot(((DocumentNodeStore)this.store).rebase(branchHead.getRevision(), base.getRevision()));
    }

    @Override
    protected DocumentNodeState merge(DocumentNodeState branchHead, CommitInfo info) throws CommitFailedException {
        return ((DocumentNodeStore)this.store).getRoot(((DocumentNodeStore)this.store).merge(branchHead.getRevision(), info));
    }

    @Override
    @Nonnull
    protected DocumentNodeState reset(@Nonnull DocumentNodeState branchHead, @Nonnull DocumentNodeState ancestor) {
        return ((DocumentNodeStore)this.store).getRoot(((DocumentNodeStore)this.store).reset(branchHead.getRevision(), ancestor.getRevision()));
    }

    @Override
    protected DocumentNodeState persist(final NodeState toPersist, final DocumentNodeState base, CommitInfo info) {
        return this.persist(new Changes(){

            @Override
            public void with(Commit c) {
                toPersist.compareAgainstBaseState(base, new CommitDiff((DocumentNodeStore)DocumentNodeStoreBranch.this.store, c, ((DocumentNodeStore)DocumentNodeStoreBranch.this.store).getBlobSerializer()));
            }
        }, base, info);
    }

    @Override
    protected DocumentNodeState copy(String source, final String target, DocumentNodeState base) {
        final DocumentNodeState src = ((DocumentNodeStore)this.store).getNode(source, base.getRevision());
        Preconditions.checkState(src != null, "Source node %s@%s does not exist", source, base.getRevision());
        return this.persist(new Changes(){

            @Override
            public void with(Commit c) {
                ((DocumentNodeStore)DocumentNodeStoreBranch.this.store).copyNode(src, target, c);
            }
        }, base, null);
    }

    @Override
    protected DocumentNodeState move(String source, final String target, DocumentNodeState base) {
        final DocumentNodeState src = ((DocumentNodeStore)this.store).getNode(source, base.getRevision());
        Preconditions.checkState(src != null, "Source node %s@%s does not exist", source, base.getRevision());
        return this.persist(new Changes(){

            @Override
            public void with(Commit c) {
                ((DocumentNodeStore)DocumentNodeStoreBranch.this.store).moveNode(src, target, c);
            }
        }, base, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
        try {
            return super.merge(hook, info);
        }
        catch (CommitFailedException e) {
            if (!e.isOfType("Merge")) {
                throw e;
            }
            this.mergeLock.writeLock().lock();
            try {
                NodeState nodeState = super.merge(hook, info);
                return nodeState;
            }
            finally {
                this.mergeLock.writeLock().unlock();
            }
        }
    }

    private static long getMaxBackoffMillis(DocumentNodeStore store) {
        return Math.max(store.getAsyncDelay(), 1000) * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentNodeState persist(Changes op, DocumentNodeState base, CommitInfo info) {
        Revision rev;
        boolean success = false;
        Commit c = ((DocumentNodeStore)this.store).newCommit(base.getRevision());
        try {
            op.with(c);
            if (c.isEmpty()) {
                DocumentNodeState documentNodeState = base;
                return documentNodeState;
            }
            rev = c.apply();
            success = true;
        }
        finally {
            if (success) {
                ((DocumentNodeStore)this.store).done(c, base.getRevision().isBranch(), info);
            } else {
                ((DocumentNodeStore)this.store).canceled(c);
            }
        }
        return ((DocumentNodeStore)this.store).getRoot(rev);
    }

    @CheckForNull
    static DocumentNodeStoreBranch getCurrentBranch() {
        AbstractNodeStoreBranch b = (AbstractNodeStoreBranch)BRANCHES.get(Thread.currentThread());
        if (b instanceof DocumentNodeStoreBranch) {
            return (DocumentNodeStoreBranch)b;
        }
        return null;
    }

    private static interface Changes {
        public void with(Commit var1);
    }
}

