/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.refresher.AbstractRefresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.kv.GetBucketConfigRequest;
import com.couchbase.client.core.message.kv.GetBucketConfigResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.Buffers;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public class CarrierRefresher
extends AbstractRefresher {
    static final long POLL_FLOOR_NS = TimeUnit.MILLISECONDS.toNanos(10L);
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CarrierRefresher.class);
    private final Set<String> subscriptions = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CoreEnvironment environment;
    private volatile Subscription pollerSubscription;
    private volatile long nodeOffset;
    private volatile long lastPollTimestamp;

    public CarrierRefresher(CoreEnvironment environment, ClusterFacade cluster) {
        super(environment, cluster);
        this.environment = environment;
        this.lastPollTimestamp = 0L;
        this.nodeOffset = 0L;
        long pollInterval = environment.configPollInterval();
        if (pollInterval > 0L) {
            LOGGER.debug("Starting polling with interval {}ms", (Object)pollInterval);
            this.pollerSubscription = Observable.interval(pollInterval, TimeUnit.MILLISECONDS, environment.scheduler()).subscribe(new Action1<Long>(){

                @Override
                public void call(Long aLong) {
                    CarrierRefresher.this.provider().signalOutdated();
                }
            });
        } else {
            LOGGER.info("Proactive config polling disabled based on environment setting.");
        }
    }

    @Override
    public Observable<Boolean> shutdown() {
        LOGGER.debug("Shutting down the CarrierRefresher.");
        return Observable.just(true).doOnNext(new Action1<Boolean>(){

            @Override
            public void call(Boolean ignored) {
                if (CarrierRefresher.this.pollerSubscription != null && !CarrierRefresher.this.pollerSubscription.isUnsubscribed()) {
                    CarrierRefresher.this.pollerSubscription.unsubscribe();
                }
            }
        });
    }

    @Override
    public void markTainted(final BucketConfig config) {
        final String bucketName = config.name();
        if (this.subscriptions.contains(bucketName)) {
            return;
        }
        LOGGER.debug("Config for bucket \"" + bucketName + "\" marked as tainted, starting polling.");
        this.subscriptions.add(bucketName);
        Observable.interval(1L, TimeUnit.SECONDS).takeWhile(new Func1<Long, Boolean>(){

            @Override
            public Boolean call(Long aLong) {
                return CarrierRefresher.this.subscriptions.contains(bucketName);
            }
        }).filter(new Func1<Long, Boolean>(){

            @Override
            public Boolean call(Long aLong) {
                boolean allowed = CarrierRefresher.this.allowedToPoll();
                if (allowed) {
                    CarrierRefresher.this.lastPollTimestamp = System.nanoTime();
                } else {
                    LOGGER.trace("Ignoring tainted polling attempt because poll interval is too small.");
                }
                return allowed;
            }
        }).flatMap(new Func1<Long, Observable<String>>(){

            @Override
            public Observable<String> call(Long aLong) {
                ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(config.nodes());
                if (nodeInfos.isEmpty()) {
                    LOGGER.debug("Cannot poll bucket, because node list contains no nodes.");
                    return Observable.empty();
                }
                CarrierRefresher.this.shiftNodeList(nodeInfos);
                return CarrierRefresher.this.buildRefreshFallbackSequence(nodeInfos, bucketName);
            }
        }).subscribe(new Subscriber<String>(){

            @Override
            public void onCompleted() {
                LOGGER.debug("Completed polling for bucket \"{}\".", (Object)bucketName);
            }

            @Override
            public void onError(Throwable e) {
                LOGGER.debug("Error while polling bucket config, ignoring.", e);
            }

            @Override
            public void onNext(String rawConfig) {
                if (rawConfig.startsWith("{")) {
                    CarrierRefresher.this.provider().proposeBucketConfig(bucketName, rawConfig);
                }
            }
        });
    }

    @Override
    public void markUntainted(BucketConfig config) {
        if (this.subscriptions.contains(config.name())) {
            LOGGER.debug("Config for bucket \"" + config.name() + "\" marked as untainted, stopping polling.");
            this.subscriptions.remove(config.name());
        }
    }

    @Override
    public void refresh(ClusterConfig config) {
        Observable.from(config.bucketConfigs().values()).observeOn(this.environment.scheduler()).filter(new Func1<BucketConfig, Boolean>(){

            @Override
            public Boolean call(BucketConfig config) {
                return CarrierRefresher.this.registrations().containsKey(config.name());
            }
        }).filter(new Func1<BucketConfig, Boolean>(){

            @Override
            public Boolean call(BucketConfig config) {
                boolean allowed = CarrierRefresher.this.allowedToPoll();
                if (allowed) {
                    CarrierRefresher.this.lastPollTimestamp = System.nanoTime();
                } else {
                    LOGGER.trace("Ignoring refresh polling attempt because poll interval is too small.");
                }
                return allowed;
            }
        }).subscribe(new Action1<BucketConfig>(){

            @Override
            public void call(final BucketConfig config) {
                final String bucketName = config.name();
                ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>(config.nodes());
                if (nodeInfos.isEmpty()) {
                    LOGGER.debug("Cannot refresh bucket, because node list contains no nodes.");
                    return;
                }
                CarrierRefresher.this.shiftNodeList(nodeInfos);
                Observable refreshSequence = CarrierRefresher.this.buildRefreshFallbackSequence(nodeInfos, bucketName);
                refreshSequence.subscribe(new Subscriber<String>(){

                    @Override
                    public void onCompleted() {
                        LOGGER.debug("Completed refreshing config for bucket \"{}\"", (Object)bucketName);
                    }

                    @Override
                    public void onError(Throwable e) {
                        LOGGER.debug("Error while refreshing bucket config, ignoring.", e);
                    }

                    @Override
                    public void onNext(String rawConfig) {
                        if (rawConfig.startsWith("{")) {
                            CarrierRefresher.this.provider().proposeBucketConfig(config.name(), rawConfig);
                        }
                    }
                });
            }
        });
    }

    private Observable<String> buildRefreshFallbackSequence(List<NodeInfo> nodeInfos, String bucketName) {
        Observable<String> failbackSequence = null;
        for (NodeInfo nodeInfo : nodeInfos) {
            if (!CarrierRefresher.isValidCarrierNode(this.environment.sslEnabled(), nodeInfo)) continue;
            if (failbackSequence == null) {
                failbackSequence = this.refreshAgainstNode(bucketName, nodeInfo.hostname());
                continue;
            }
            failbackSequence = failbackSequence.onErrorResumeNext(this.refreshAgainstNode(bucketName, nodeInfo.hostname()));
        }
        if (failbackSequence == null) {
            LOGGER.debug("Could not build refresh sequence, node list is empty - ignoring attempt.");
            return Observable.empty();
        }
        return failbackSequence;
    }

    <T> void shiftNodeList(List<T> nodeList) {
        int shiftBy = (int)(this.nodeOffset++ % (long)nodeList.size());
        for (int i = 0; i < shiftBy; ++i) {
            T element = nodeList.remove(0);
            nodeList.add(element);
        }
    }

    private static boolean isValidCarrierNode(boolean sslEnabled, NodeInfo nodeInfo) {
        if (sslEnabled && nodeInfo.sslServices().containsKey((Object)ServiceType.BINARY)) {
            return true;
        }
        return nodeInfo.services().containsKey((Object)ServiceType.BINARY);
    }

    private boolean allowedToPoll() {
        return System.nanoTime() - this.lastPollTimestamp >= POLL_FLOOR_NS;
    }

    private Observable<String> refreshAgainstNode(final String bucketName, final NetworkAddress hostname) {
        return Buffers.wrapColdWithAutoRelease(Observable.defer(new Func0<Observable<GetBucketConfigResponse>>(){

            @Override
            public Observable<GetBucketConfigResponse> call() {
                return CarrierRefresher.this.cluster().send(new GetBucketConfigRequest(bucketName, hostname));
            }
        })).doOnNext(new Action1<GetBucketConfigResponse>(){

            @Override
            public void call(GetBucketConfigResponse response) {
                if (!response.status().isSuccess()) {
                    if (response.content() != null && response.content().refCnt() > 0) {
                        response.content().release();
                    }
                    throw new ConfigurationException("Could not fetch config from node: " + response);
                }
            }
        }).map(new Func1<GetBucketConfigResponse, String>(){

            @Override
            public String call(GetBucketConfigResponse response) {
                String raw = response.content().toString(CharsetUtil.UTF_8).trim();
                if (response.content().refCnt() > 0) {
                    response.content().release();
                }
                return raw.replace("$HOST", response.hostname().address());
            }
        }).doOnError(new Action1<Throwable>(){

            @Override
            public void call(Throwable ex) {
                LOGGER.debug("Could not fetch config from bucket \"" + bucketName + "\" against \"" + hostname + "\".", ex);
            }
        });
    }

    Subscription pollerSubscription() {
        return this.pollerSubscription;
    }
}

