/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.cotrix.action.ResourceType;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.async.TaskContext;
import org.cotrix.common.async.TaskUpdate;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.links.Link;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MAttrDef;
import org.cotrix.domain.memory.MLinkDef;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.User;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.CodelistSummary;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.UpdateAction;
import org.cotrix.repository.impl.memory.MMultiQuery;
import org.cotrix.repository.impl.memory.MemoryRepository;
import org.cotrix.repository.spi.CodelistActionFactory;
import org.cotrix.repository.spi.CodelistQueryFactory;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class MCodelistRepository
extends MemoryRepository<Codelist.Bean>
implements CodelistQueryFactory,
CodelistActionFactory {
    @Inject
    TaskContext context;

    @Override
    public void add(Codelist.Bean list) {
        int total = list.codes().size() + list.attributeDefinitions().size() + list.linkDefinitions().size() + list.attributes().size();
        int progressInterval = Math.min(100, total);
        try {
            for (int i = 0; i < total; i += Math.min(progressInterval, total - i)) {
                int step = Math.min(progressInterval, total - i);
                this.context.save((Object)new TaskUpdate(((float)i + (float)step) / (float)total, "loaded " + i + " of " + total + " elements"));
            }
        }
        catch (Exception e) {
            CommonUtils.rethrowUnchecked((Throwable)e);
        }
        super.add(list);
    }

    @Override
    public void remove(String id) {
        CommonUtils.notNull((String)"identifier", (Object)id);
        for (Codelist.Bean list : this.getAll()) {
            for (LinkDefinition.Bean link : list.linkDefinitions()) {
                if (!link.target().id().equals(id)) continue;
                throw new CodelistRepository.UnremovableCodelistException("cannot remove codelist " + list.id() + ": others depend on it");
            }
        }
        super.remove(id);
    }

    @Override
    public UpdateAction<Codelist> deleteAttrdef(final String definitionId) {
        return new UpdateAction<Codelist>(){

            @Override
            public void performOver(Codelist list) {
                if (!list.attributeDefinitions().contains(definitionId)) {
                    throw new IllegalArgumentException("no attribute definition " + definitionId + " in list " + list.id() + " (" + list.qname() + ")");
                }
                AttributeDefinition def = (AttributeDefinition)list.attributeDefinitions().lookup(definitionId);
                for (Code code : list.codes()) {
                    ArrayList<Attribute> changesets = new ArrayList<Attribute>();
                    for (Attribute a : code.attributes()) {
                        if (!((AttributeDefinition)a.definition()).id().equals(def.id())) continue;
                        changesets.add(Data.delete((Attribute)a));
                    }
                    Data.reveal((Code)code).update(Data.reveal((Code)((Code)((CodeGrammar.SecondClause)Data.modify((Code)code).attributes(changesets)).build())));
                }
                AttributeDefinition.Private changeset = new MAttrDef(def.id(), Status.DELETED).entity();
                Data.reveal((Codelist)list).update(Data.reveal((Codelist)((Codelist)Data.modify((Codelist)list).definitions(new AttributeDefinition[]{changeset}).build())));
            }

            public String toString() {
                return "action [delete definition " + definitionId;
            }
        };
    }

    @Override
    public UpdateAction<Codelist> deleteLinkdef(final String linkId) {
        return new UpdateAction<Codelist>(){

            @Override
            public void performOver(Codelist list) {
                if (!list.linkDefinitions().contains(linkId)) {
                    throw new IllegalArgumentException("no link definition " + linkId + " in list " + list.id() + " (" + list.qname() + ")");
                }
                LinkDefinition type = (LinkDefinition)list.linkDefinitions().lookup(linkId);
                for (Code code : list.codes()) {
                    ArrayList<Link> changesets = new ArrayList<Link>();
                    for (Link l : code.links()) {
                        if (!((LinkDefinition)l.definition()).id().equals(type.id())) continue;
                        changesets.add(Data.delete((Link)l));
                    }
                    Data.reveal((Code)code).update(Data.reveal((Code)((Code)Data.modify((Code)code).links(changesets).build())));
                }
                LinkDefinition.Private changeset = new MLinkDef(type.id(), Status.DELETED).entity();
                Data.reveal((Codelist)list).update(Data.reveal((Codelist)((Codelist)Data.modify((Codelist)list).links(new LinkDefinition[]{changeset}).build())));
            }

            public String toString() {
                return "action [delete definition " + linkId;
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Codelist> allLists() {
        return new MMultiQuery<Codelist, Codelist>(){

            @Override
            Collection<Codelist> executeInMemory() {
                return MCodelistRepository.this.adapt(MCodelistRepository.this.getAll());
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> allCodes(final String codelistId) {
        return new MMultiQuery<Codelist, Code>(){

            @Override
            public Collection<Code> executeInMemory() {
                ArrayList<Code.Bean> codes = new ArrayList<Code.Bean>();
                for (Code.Bean c : ((Codelist.Bean)MCodelistRepository.this.lookup(codelistId)).codes()) {
                    codes.add(c);
                }
                return MCodelistRepository.this.adapt(codes);
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> codesWithAttributes(final String codelistId, final Iterable<QName> names) {
        return new MMultiQuery<Codelist, Code>(){

            @Override
            public Collection<Code> executeInMemory() {
                ArrayList<Code.Bean> codes = new ArrayList<Code.Bean>();
                block0: for (Code.Bean c : ((Codelist.Bean)MCodelistRepository.this.lookup(codelistId)).codes()) {
                    Container.Bean as = c.attributes();
                    for (QName name : names) {
                        if (as.contains(name)) continue;
                        continue block0;
                    }
                    codes.add(c);
                }
                return MCodelistRepository.this.adapt(codes);
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> codesChangedSince(final String codelistId, final Date date) {
        return new MMultiQuery<Codelist, Code>(){

            @Override
            public Collection<Code> executeInMemory() {
                ArrayList<Code.Bean> codes = new ArrayList<Code.Bean>();
                for (Code.Bean c : ((Codelist.Bean)MCodelistRepository.this.lookup(codelistId)).codes()) {
                    Code entity = (Code)c.entity();
                    Date changed = CommonDefinition.LAST_UPDATED.dateOf((Described)entity);
                    if (changed == null) {
                        changed = CommonDefinition.CREATED.dateOf((Described)entity);
                    }
                    if (changed == null || !changed.after(date)) continue;
                    codes.add(c);
                }
                return MCodelistRepository.this.adapt(codes);
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> codesWithCommonAttributes(String id, Iterable<QName> names) {
        return this.codesWithAttributes(id, names);
    }

    @Override
    public MultiQuery<Codelist, CodelistCoordinates> allListCoordinates() {
        return new MMultiQuery<Codelist, CodelistCoordinates>(){

            @Override
            public Collection<CodelistCoordinates> executeInMemory() {
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                for (Codelist.Bean list : MCodelistRepository.this.getAll()) {
                    coordinates.add(CodelistCoordinates.coordsOf(list));
                }
                return coordinates;
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> codes(final Collection<String> ids) {
        return new MMultiQuery<Codelist, Code>(){

            @Override
            public Collection<Code> executeInMemory() {
                ArrayList codes = new ArrayList();
                for (Codelist.Bean list : MCodelistRepository.this.getAll()) {
                    for (String id : ids) {
                        if (!list.codes().contains(id)) continue;
                        codes.add(list.codes().get(Arrays.asList(id)).iterator().next());
                    }
                }
                return MCodelistRepository.this.adapt(codes);
            }
        };
    }

    @Override
    public Query<Codelist, Code> code(final String id) {
        return new Query.Private<Codelist, Code>(){

            @Override
            public Code execute() {
                for (Codelist.Bean list : MCodelistRepository.this.getAll()) {
                    if (!list.codes().contains(id)) continue;
                    return (Code)((Code.Bean)list.codes().get(Arrays.asList(id)).iterator().next()).entity();
                }
                return null;
            }
        };
    }

    @Override
    public MultiQuery<Codelist, CodelistCoordinates> codelistsFor(User u) {
        final FingerPrint fp = u.fingerprint();
        return new MMultiQuery<Codelist, CodelistCoordinates>(){

            @Override
            public Collection<CodelistCoordinates> executeInMemory() {
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                for (Codelist.Bean list : MCodelistRepository.this.getAll()) {
                    if (fp.allRolesOver(list.id(), ResourceType.codelists).isEmpty()) continue;
                    coordinates.add(CodelistCoordinates.coordsOf(list));
                }
                return coordinates;
            }
        };
    }

    @Override
    public Query<Codelist, CodelistSummary> summary(final String id) {
        return new Query.Private<Codelist, CodelistSummary>(){

            @Override
            public CodelistSummary execute() {
                Codelist.Bean state = (Codelist.Bean)MCodelistRepository.this.lookup(id);
                if (state == null) {
                    throw new IllegalStateException("no such codelist: " + id);
                }
                Codelist list = (Codelist)state.entity();
                return new CodelistSummary(list);
            }
        };
    }

    @Override
    public Criterion<Codelist> byCodelistName() {
        return this.byName();
    }

    @Override
    public Criterion<Code> byCodeName() {
        return this.byName();
    }

    @Override
    public Criterion<CodelistCoordinates> byCoordinateName() {
        return this.byName();
    }

    private <T extends Named> Criterion<T> byName() {
        return new MemoryRepository.MCriterion<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.qname().getLocalPart().compareTo(o2.qname().getLocalPart());
            }
        };
    }

    @Override
    public Criterion<Codelist> byVersion() {
        return new MemoryRepository.MCriterion<Codelist>(){

            @Override
            public int compare(Codelist o1, Codelist o2) {
                return o1.version().compareTo(o2.version());
            }
        };
    }

    @Override
    public Criterion<Code> byAttribute(final Attribute template, final int position) {
        CommonUtils.valid((String)"attribute name", (QName)template.qname());
        return new MemoryRepository.MCriterion<Code>(){

            private boolean matches(Attribute a) {
                return template.qname().equals(a.qname()) && (template.language() == null || template.language().equals(a.language()));
            }

            @Override
            public int compare(Code c1, Code c2) {
                int pos = 1;
                String c1Match = null;
                for (Attribute a : c1.attributes()) {
                    if (!this.matches(a)) continue;
                    if (pos == position) {
                        c1Match = a.value();
                        break;
                    }
                    ++pos;
                }
                pos = 1;
                String c2Match = null;
                for (Attribute a : c2.attributes()) {
                    if (!this.matches(a)) continue;
                    if (pos == position) {
                        c2Match = a.value();
                        break;
                    }
                    ++pos;
                }
                if (c1Match == null) {
                    return c2Match == null ? 0 : 1;
                }
                return c2Match == null ? -1 : c1Match.compareTo(c2Match);
            }
        };
    }

    @Override
    public Criterion<Code> byLink(final LinkDefinition template, final int position) {
        CommonUtils.valid((String)"link name", (QName)template.qname());
        return new MemoryRepository.MCriterion<Code>(){

            private boolean matches(Link link) {
                return link.qname().equals(template.qname()) && ((LinkDefinition)link.definition()).equals(template);
            }

            @Override
            public int compare(Code c1, Code c2) {
                int pos = 1;
                List c1Match = null;
                for (Link link : c1.links()) {
                    if (!this.matches(link)) continue;
                    if (pos == position) {
                        c1Match = link.value();
                        break;
                    }
                    ++pos;
                }
                pos = 1;
                List c2Match = null;
                for (Link link : c2.links()) {
                    if (!this.matches(link)) continue;
                    if (pos == position) {
                        c2Match = link.value();
                        break;
                    }
                    ++pos;
                }
                if (c1Match == null) {
                    return c2Match == null ? 0 : 1;
                }
                if (c2Match == null) {
                    return -1;
                }
                for (int i = 0; i < Math.min(c1Match.size(), c2Match.size()); ++i) {
                    int result;
                    Object o1 = c1Match.get(i);
                    Object o2 = c2Match.get(i);
                    if (!(o1 instanceof Comparable) || (result = ((Comparable)Comparable.class.cast(o1)).compareTo(o2)) == 0) continue;
                    return result;
                }
                return c1Match.size() < c2Match.size() ? -1 : 1;
            }
        };
    }

    private static <R> MemoryRepository.MCriterion<R> revealCriterion(Criterion<R> criterion) {
        return (MemoryRepository.MCriterion)CommonUtils.reveal(criterion, MemoryRepository.MCriterion.class);
    }
}

