/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;

public class SharedDefinitionPool
implements Iterable<AttributeDefinition> {
    Map<DefinitionTemplate, AttributeDefinition> defs = new HashMap<DefinitionTemplate, AttributeDefinition>();

    public AttributeDefinition get(String name, String type, String language) {
        return this.get(Data.q((String)name), Data.q((String)type), language);
    }

    public AttributeDefinition get(QName name, QName type) {
        return this.get(name, type, null);
    }

    public AttributeDefinition get(QName name, QName type, String language) {
        DefinitionTemplate key = this.key(name, type, language);
        AttributeDefinition def = this.defs.get(key);
        if (def == null) {
            AttributeDefinitionGrammar.SecondClause clause = (AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(name);
            if (type != null) {
                clause.is(type);
            }
            if (language != null) {
                clause.in(language);
            }
            def = (AttributeDefinition)clause.build();
            this.defs.put(key, def);
        }
        return def;
    }

    public AttributeDefinition get(String name, String type) {
        return this.get(name, type, null);
    }

    @Override
    public Iterator<AttributeDefinition> iterator() {
        return this.defs.values().iterator();
    }

    private DefinitionTemplate key(QName name, QName type, String language) {
        return new DefinitionTemplate(name, type, language);
    }

    private static class DefinitionTemplate {
        private final QName name;
        private final QName type;
        private final String language;

        DefinitionTemplate(QName name, QName type, String language) {
            this.name = name;
            this.type = type;
            this.language = language;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefinitionTemplate other = (DefinitionTemplate)obj;
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

