/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.codelist;

import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Version;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MCodelist;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;

public interface Codelist
extends Identified,
Described,
Named {
    public Containers.Codes codes();

    public Containers.LinkDefinitions linkDefinitions();

    public Containers.AttributeDefinitions attributeDefinitions();

    public String version();

    public static final class Private
    extends Described.Private<Private, Bean>
    implements Codelist {
        public Private(Bean bean) {
            super(bean);
        }

        @Override
        public Containers.Codes codes() {
            return new Containers.Codes((Bean)this.bean());
        }

        @Override
        public Containers.LinkDefinitions linkDefinitions() {
            return new Containers.LinkDefinitions((Bean)this.bean());
        }

        @Override
        public Containers.AttributeDefinitions attributeDefinitions() {
            return new Containers.AttributeDefinitions((Bean)this.bean());
        }

        @Override
        public String version() {
            return ((Bean)this.bean()).version() == null ? null : ((Bean)this.bean()).version().value();
        }

        public Codelist bump(String version) {
            Version newVersion = ((Bean)this.bean()).version().bumpTo(version);
            MCodelist bean = new MCodelist((Bean)this.bean());
            bean.version(newVersion);
            return (Codelist)bean.entity();
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            if (changeset.version() != null && !changeset.version().equals(this.version())) {
                throw new IllegalArgumentException("cannot change the version (" + this.version() + ") of entity " + this.id() + ". Versioning is performed by copy");
            }
            this.attributeDefinitions().update(changeset.attributeDefinitions());
            this.linkDefinitions().update(changeset.linkDefinitions());
            this.codes().update(changeset.codes());
        }

        public String toString() {
            return "Codelist [id=" + this.id() + ", name=" + this.qname() + ", codes=" + this.codes() + ", attributes=" + this.attributes() + ", attrdefs=" + this.attributeDefinitions() + ", linkdefs=" + this.linkDefinitions() + ", version=" + this.version() + (this.status() == null ? "" : " (" + (Object)((Object)this.status()) + ") ") + "]";
        }
    }

    public static interface Bean
    extends Described.Bean,
    BeanOf<Private> {
        public Container.Bean<Code.Bean> codes();

        public Container.Bean<LinkDefinition.Bean> linkDefinitions();

        public Container.Bean<AttributeDefinition.Bean> attributeDefinitions();

        public Version version();

        public void version(Version var1);
    }
}

