/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.configuration.ConfigurationBean;
import org.cotrix.configuration.ConfigurationContext;
import org.cotrix.configuration.ConfigurationLocator;

@Singleton
public class ConfigurationManager {
    private final Map<Class<?>, ConfigurationBean> configurations = new HashMap();

    @Inject
    public ConfigurationManager(ConfigurationLocator locator, ConfigurationContext context) {
        List<ConfigurationBean> list = context.bind(locator.locate());
        for (ConfigurationBean configuration : list) {
            this.configurations.put(configuration.getClass(), configuration);
        }
    }

    public <T extends ConfigurationBean> T get(Class<T> type) throws IllegalStateException {
        ConfigurationBean bean = this.configurations.get(type);
        if (bean == null) {
            throw new IllegalStateException("no configuration for " + type);
        }
        return (T)bean;
    }
}

