/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.app.resources;

import com.fasterxml.jackson.databind.util.JSONPObject;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import gr.cite.repo.auth.app.cookies.CookieFactory;
import gr.cite.repo.auth.app.entities.SAMLResourceHelpers;
import gr.cite.repo.auth.app.entities.SamlAuthRequestFactory;
import gr.cite.repo.auth.app.entities.SamlLogoutResponseFactory;
import gr.cite.repo.auth.app.entities.SamlResponseFactory;
import gr.cite.repo.auth.app.utils.LocationResolver;
import gr.cite.repo.auth.app.utils.UserInfo;
import gr.cite.repo.auth.app.views.HomeView;
import gr.cite.repo.auth.app.views.LoginView;
import gr.cite.repo.auth.saml.messages.SamlAuthRequest;
import gr.cite.repo.auth.saml.messages.SamlIDPMetadata;
import gr.cite.repo.auth.saml.messages.SamlLogoutRequest;
import gr.cite.repo.auth.saml.messages.SamlLogoutResponse;
import gr.cite.repo.auth.saml.messages.SamlResponse;
import gr.cite.repo.auth.saml.messages.SamlSPMetadata;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/saml")
@Produces(value={"application/json"})
public class SAMLResource {
    private static final Logger logger = LoggerFactory.getLogger(SAMLResource.class);
    private final String spHost;
    private final String idpMetadataLocation;
    private final byte[] privateKey;
    private final String certificate;
    private final SamlResponseFactory samlResponseFactory;
    private final SamlAuthRequestFactory samlAuthRequestFactory;
    private final CookieFactory cookieFactory;
    private final boolean invalidateLocalSessionOnSamlError;
    private final boolean tryRenewSessionOnLogout;
    private LocationResolver locationResolver;
    private SamlIDPMetadata idpMetadata;
    private String idpHost;
    private boolean bulkLogout;
    Cache<String, List<HttpSession>> cacheSessions = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public SAMLResource(String spHost, String idpMetadataLocation, String privateKeyFileName, String certificateFilename, SamlResponseFactory samlResponseFactory, SamlAuthRequestFactory samlAuthRequestFactory, LocationResolver locationResolver, CookieFactory cookieFactory, boolean invalidateLocalSessionOnSamlError, boolean tryRenewSessionOnLogout, boolean bulkLogout) throws IOException, ConfigurationException, XMLParserException, UnmarshallingException {
        this.spHost = spHost;
        this.idpMetadataLocation = idpMetadataLocation;
        this.privateKey = SAMLResourceHelpers.readPrivateKey(privateKeyFileName);
        this.certificate = SAMLResourceHelpers.readCertificate(certificateFilename);
        this.samlResponseFactory = samlResponseFactory;
        this.samlAuthRequestFactory = samlAuthRequestFactory;
        this.cookieFactory = cookieFactory;
        this.invalidateLocalSessionOnSamlError = invalidateLocalSessionOnSamlError;
        this.tryRenewSessionOnLogout = tryRenewSessionOnLogout;
        this.bulkLogout = bulkLogout;
        this.locationResolver = locationResolver;
        this.initFromMeta();
    }

    final void initFromMeta() throws MalformedURLException, IOException, ConfigurationException, XMLParserException, UnmarshallingException {
        logger.info("metadata location : " + this.idpMetadataLocation);
        URL metadataUrl = new URL(this.idpMetadataLocation);
        String metadataXML = this.locationResolver.getContents(this.idpMetadataLocation);
        this.idpHost = String.format("%s://%s:%d", metadataUrl.getProtocol(), metadataUrl.getHost(), metadataUrl.getPort());
        this.idpMetadata = new SamlIDPMetadata(metadataXML);
        logger.info("idp host :" + this.idpHost);
        logger.info("SLS HTTP-POST     : " + this.idpMetadata.getSLSHttpPostEndpoint());
        logger.info("SLS SOAP          : " + this.idpMetadata.getSLSSoapEndpoint());
        logger.info("SLS HTTP-Redirect : " + this.idpMetadata.getSLSHttpRedirectEndpoint());
        logger.info("SSO AuthRequest          : " + this.idpMetadata.getSSOAuthRequestLocation());
        logger.info("SSO HTTP-POST            : " + this.idpMetadata.getSSOHttpPostEndpoint());
        logger.info("SSO HTTP-POST SimpleSign : " + this.idpMetadata.getSSOHttpPostSimpleSignEndpoint());
        logger.info("SSO HTTP-Redirect        : " + this.idpMetadata.getSSOHttpRedirectEndpoint());
    }

    @GET
    @Path(value="/simpleLogout")
    public Response simpleLogout(@Context HttpServletRequest httpServletRequest, @QueryParam(value="target") String target) {
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.invalidate();
        if (target != null) {
            String relayStateURL = target;
            logger.info("relaystate was given. redirecting to  : " + relayStateURL);
            return Response.seeOther((URI)URI.create(relayStateURL)).build();
        }
        logger.info("relaystate was not given");
        return Response.ok((Object)"you have logged out!").build();
    }

    @POST
    @Path(value="/logoutConsumer")
    public Response logoutConsumer(@Context HttpServletRequest httpServletRequest, @FormParam(value="SAMLResponse") String samlResponseString, @FormParam(value="RelayState") String relayState) throws UnsupportedEncodingException, MarshallingException, ConfigurationException {
        HttpSession httpSession = httpServletRequest.getSession();
        SamlLogoutResponse samlResponse = null;
        logger.debug("sessionID : + " + httpSession.getId());
        try {
            samlResponse = new SamlLogoutResponseFactory().create(this.privateKey, samlResponseString);
        }
        catch (Exception e) {
            logger.warn("error while reading samlResponse : " + samlResponseString, (Throwable)e);
            return Response.serverError().build();
        }
        boolean validation = false;
        try {
            validation = samlResponse.validate();
        }
        catch (Exception e) {
            logger.warn("saml response validation failed : " + samlResponseString, (Throwable)e);
            return this.checkInvalidateSession(httpSession);
        }
        logger.info("validation : " + validation);
        String nameId = (String)httpSession.getAttribute("samlNameID");
        if (this.bulkLogout) {
            this.invalidateLocalSessions(nameId);
        } else {
            httpSession.invalidate();
        }
        if (relayState != null) {
            String relayStateURL = relayState;
            logger.info("relaystate was given. redirecting to  : " + relayStateURL);
            return Response.seeOther((URI)URI.create(relayStateURL)).build();
        }
        logger.info("relaystate was not given");
        return Response.ok((Object)"you have logged out!").build();
    }

    private void saveIdpSession(String nameId, List<String> samlSessionIds, HttpSession httpSession) {
        List sessions = (List)this.cacheSessions.getIfPresent((Object)nameId);
        if (sessions != null) {
            sessions.add(httpSession);
        } else {
            this.cacheSessions.put((Object)nameId, (Object)Lists.newArrayList((Object[])new HttpSession[]{httpSession}));
        }
    }

    private void invalidateLocalSessions(String nameId) {
        List sessions = (List)this.cacheSessions.getIfPresent((Object)nameId);
        if (sessions == null) {
            return;
        }
        for (HttpSession session : sessions) {
            session.invalidate();
        }
        this.cacheSessions.invalidate((Object)nameId);
    }

    @POST
    @Path(value="/consumer")
    public Response consumer(@Context HttpHeaders headers, @Context HttpServletRequest httpServletRequest, @FormParam(value="SAMLResponse") String samlResponseString, @FormParam(value="RelayState") String relayState) {
        HttpSession httpSession = httpServletRequest.getSession();
        for (Map.Entry c : headers.getCookies().entrySet()) {
            logger.info(" ~> cookie " + (String)c.getKey() + " : " + ((Cookie)c.getValue()).getName() + " : " + ((Cookie)c.getValue()).getValue());
        }
        SamlResponse samlResponse = null;
        logger.info(" consume sessionID : + " + httpSession.getId());
        try {
            samlResponse = this.samlResponseFactory.create(this.privateKey, samlResponseString);
        }
        catch (Exception e) {
            logger.warn("error while reading samlResponse : " + samlResponseString, (Throwable)e);
            return Response.serverError().build();
        }
        try {
            samlResponse.validate();
        }
        catch (Exception e) {
            logger.warn("saml response validation failed : " + samlResponseString, (Throwable)e);
            return Response.serverError().build();
        }
        logger.info("saml response is valid");
        String username = (String)samlResponse.getAttributes().get("cn");
        String email = (String)samlResponse.getAttributes().get("mail");
        String samlNameId = samlResponse.getNameId();
        List<String> samlSessionIds = samlResponse.getSessionIds();
        logger.info(" -> samlSessionIds : " + samlSessionIds);
        logger.info(" -> samlNameID     : " + samlNameId);
        httpSession.setAttribute("samlLoggedIn", (Object)Boolean.TRUE);
        httpSession.setAttribute("samlNameID", (Object)samlNameId);
        httpSession.setAttribute("samlSessionIDs", samlSessionIds);
        httpSession.setAttribute("username", (Object)username);
        httpSession.setAttribute("email", (Object)email);
        if (this.bulkLogout) {
            this.saveIdpSession(samlNameId, samlSessionIds, httpSession);
        }
        Cookie cookie = this.cookieFactory.createCookie(httpSession.getId());
        if (relayState != null) {
            String relayStateURL = relayState;
            logger.info("relaystate was given. redirecting to  : " + relayStateURL);
            return Response.seeOther((URI)URI.create(relayStateURL)).cookie(new NewCookie[]{new NewCookie(cookie)}).build();
        }
        logger.info("relaystate was not given");
        return Response.ok((Object)("Welcome : " + username)).cookie(new NewCookie[]{new NewCookie(cookie)}).build();
    }

    @GET
    @Path(value="/sendLogoutRequest")
    public Response sendLogoutRequest(@Context HttpHeaders headers, @Context HttpServletRequest httpServletRequest, @QueryParam(value="target") String target) throws UnsupportedEncodingException, MarshallingException, ConfigurationException {
        String relayStateValue;
        HttpSession httpSession = httpServletRequest.getSession();
        String issuer = this.spHost + "/saml/metadata";
        SamlLogoutRequest logoutReq = new SamlLogoutRequest(issuer);
        logger.info("creating request");
        List samlSessionIds = (List)httpSession.getAttribute("samlSessionIDs");
        String destinationUrl = this.idpMetadata.getSLSHttpRedirectEndpoint();
        String samlNameID = (String)httpSession.getAttribute("samlNameID");
        logger.info(" ~> samlSessionIds : " + samlSessionIds);
        logger.info(" ~> samlNameID     : " + samlNameID);
        String nameIdNameQualifier = this.idpMetadata.getEntityId();
        String base64 = logoutReq.getLogoutRequest(samlNameID, samlSessionIds, destinationUrl, nameIdNameQualifier);
        logger.info("base 64 : " + base64);
        String relayState = relayStateValue = target;
        StringBuilder reqString = new StringBuilder(this.idpMetadata.getSLSHttpRedirectEndpoint());
        reqString.append("?SAMLRequest=").append(URLEncoder.encode(base64, "UTF-8"));
        if (relayState != null) {
            reqString.append("&RelayState=").append(URLEncoder.encode(relayState, "UTF-8"));
        }
        logger.info("request : " + reqString);
        return Response.seeOther((URI)URI.create(reqString.toString())).build();
    }

    @GET
    @Path(value="/sendLoginRequest")
    public Response sendRequest(@QueryParam(value="target") String target) throws URISyntaxException, MarshallingException, ConfigurationException, UnsupportedEncodingException {
        String relayStateValue;
        String assertionConsumerServiceUrl = this.spHost + "/saml/consumer";
        String issuer = this.spHost + "/saml/metadata";
        SamlAuthRequest authReq = this.samlAuthRequestFactory.create(issuer, assertionConsumerServiceUrl);
        logger.info("creating request");
        String base64 = authReq.getAuthReq();
        logger.info("base 64 : " + base64);
        String relayState = relayStateValue = target;
        StringBuilder reqString = new StringBuilder(this.idpMetadata.getSSOHttpRedirectEndpoint());
        reqString.append("?SAMLRequest=").append(URLEncoder.encode(base64, "UTF-8"));
        if (relayState != null) {
            reqString.append("&RelayState=").append(URLEncoder.encode(relayState, "UTF-8"));
        }
        logger.info("request : " + reqString);
        return Response.seeOther((URI)URI.create(reqString.toString())).build();
    }

    @GET
    @Path(value="/login")
    @Produces(value={"text/html"})
    public LoginView login() throws Exception {
        return new LoginView(this.idpHost, this.spHost, this.spHost + "/saml/metadata");
    }

    @GET
    @Path(value="/home")
    @Produces(value={"text/html"})
    public HomeView home(@Context HttpServletRequest httpServletRequest) throws Exception {
        HttpSession httpSession = httpServletRequest.getSession();
        Boolean logged = (Boolean)httpSession.getAttribute("samlLoggedIn");
        String name = null;
        name = logged != Boolean.TRUE ? "anonymous" : (String)httpSession.getAttribute("username");
        return new HomeView(this.spHost, name);
    }

    @GET
    @Path(value="/metadata")
    @Produces(value={"application/xml"})
    public Response metadata() throws Exception {
        String entityID = this.spHost + "/saml/metadata";
        SamlSPMetadata meta = new SamlSPMetadata(entityID, this.certificate, this.spHost);
        String xml = meta.getMetadata();
        return Response.ok((Object)xml).build();
    }

    @GET
    @Path(value="infoP")
    @Produces(value={"application/x-javascript"})
    public JSONPObject infoP(@Context HttpServletRequest httpServletRequest, @QueryParam(value="callback") String callback) {
        return new JSONPObject(callback, (Object)this.info(httpServletRequest));
    }

    @GET
    @Path(value="info")
    public UserInfo info(@Context HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        String username = (String)httpSession.getAttribute("username");
        String email = (String)httpSession.getAttribute("email");
        UserInfo.USER_ROLE role = httpSession.getAttribute("userRole") != null ? UserInfo.USER_ROLE.valueOf((Integer)httpSession.getAttribute("userRole")) : UserInfo.USER_ROLE.VISITOR;
        UserInfo userInfo = new UserInfo();
        userInfo.setRole(role);
        userInfo.setMail(email);
        userInfo.setUsername(username);
        return userInfo;
    }

    private Response checkInvalidateSession(HttpSession httpsession) {
        if (this.invalidateLocalSessionOnSamlError) {
            httpsession.invalidate();
            return Response.ok().entity((Object)"local logout ok. saml logout error").build();
        }
        return Response.serverError().entity((Object)"SAML logout error").build();
    }
}

