/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.repo.auth.app;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.hubspot.dropwizard.guice.GuiceBundle;
import gr.cite.repo.auth.app.config.SamlSecurityConfiguration;
import gr.cite.repo.auth.app.utils.LocationResolver;
import gr.cite.repo.auth.app.utils.UrlLocationResolver;
import gr.cite.repo.auth.dropwizard.bundles.SAMLBundle;
import io.dropwizard.Application;
import io.dropwizard.setup.Bootstrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SAMLSecureApp<T extends SamlSecurityConfiguration>
extends Application<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SAMLSecureApp.class);
    private boolean isSecure = false;
    private Module defaultModule = new AbstractModule(){

        protected void configure() {
            this.bind(LocationResolver.class).to(UrlLocationResolver.class);
        }
    };

    public boolean isSecure() {
        return this.isSecure;
    }

    public void runSec(String[] args) throws Exception {
        this.isSecure = this.checkIfSecurityDeclared(args);
        LOGGER.info("is application running in secure mode ? " + this.isSecure);
        this.run(args);
    }

    public void initialize(Bootstrap<T> bootstrap) {
        if (this.isSecure()) {
            bootstrap.addBundle(this.createSAMLBundle());
        } else {
            bootstrap.addBundle(this.createSimpleBundle());
        }
    }

    public boolean checkIfSecurityDeclared(String[] args) {
        return args[0].equals("secureserver");
    }

    public abstract Class<T> getClazz();

    public abstract Module module();

    public abstract Module moduleWithSession();

    public SAMLBundle<T> createSAMLBundle() {
        SAMLBundle<T> samlBundle = new SAMLBundle<T>(this, this.getClazz(), Modules.override((Module[])new Module[]{this.defaultModule}).with(new Module[]{this.moduleWithSession()}));
        return samlBundle;
    }

    public GuiceBundle<T> createSimpleBundle() {
        GuiceBundle guiceBundle = GuiceBundle.newBuilder().addModule(Modules.override((Module[])new Module[]{this.defaultModule}).with(new Module[]{this.module()})).setConfigClass(this.getClazz()).build();
        return guiceBundle;
    }
}

