/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.client;

import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.gos.client.ShapeManagement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.Function;

public class Mapper
implements Function<List<ShapeMessenger>, Set<Boolean>> {
    private static final long serialVersionUID = -8923332794337126038L;
    private String layerID;
    private String creatorID;
    private String authStr;
    private String gosEndpoint;

    public Mapper(String layerID, String creatorID, String authStr, String gosEndpoint) {
        this.layerID = layerID;
        this.creatorID = creatorID;
        this.authStr = authStr;
        this.gosEndpoint = gosEndpoint;
    }

    public Set<Boolean> call(List<ShapeMessenger> shapeMessengers) throws Exception {
        if (shapeMessengers == null) {
            return new HashSet<Boolean>(Arrays.asList(new Boolean(true)));
        }
        List<Shape> shapes = shapeMessengers.stream().map(shapeMessenger -> {
            try {
                Shape shape = shapeMessenger.toShape();
                shape.setLayerID(UUID.fromString(this.layerID));
                shape.setCreatorID(UUID.fromString(this.creatorID));
                return shape;
            }
            catch (Exception e) {
                System.out.println("AN error occured: " + e.getMessage());
                return null;
            }
        }).collect(Collectors.toList());
        ShapeManagement shapeManagement = new ShapeManagement(this.authStr);
        boolean status = false;
        try {
            status = shapeManagement.insertShapes(this.gosEndpoint, shapes);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return new HashSet<Boolean>(Arrays.asList(new Boolean(false)));
        }
        return new HashSet<Boolean>(Arrays.asList(new Boolean(status)));
    }
}

