/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gos.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import gr.cite.gaap.datatransferobjects.StyleMessenger;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.layer.LayerConfig;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.presentation.SystemPresentationConfig;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.DataStore;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.FeatureType;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.elements.GeoserverLayer;
import gr.cite.gos.client.GosManagement;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class GeoserverManagement
extends GosManagement {
    public GeoserverManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public boolean initializeEnvironment(String gosEndpoint, List<LayerConfig> layerConfigs, SystemPresentationConfig systemPresentationConfig, List<StyleMessenger> styles) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerConfigsJSON", (Object)this.getMapper().writeValueAsString(layerConfigs));
        formData.add((Object)"systemPresentationConfigJSON", (Object)this.getMapper().writeValueAsString((Object)systemPresentationConfig));
        formData.add((Object)"stylesJSON", (Object)this.getMapper().writeValueAsString(styles));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/initializeEnvironment").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 200;
    }

    public List<GeoserverLayer> getGeoserverLayers(String gosEndpoint) throws IOException {
        String geoserverLayersJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getGeoserverLayers").accept(new String[]{"application/json"}).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr)).get(String.class);
        TypeReference<List<GeoserverLayer>> mappingType = new TypeReference<List<GeoserverLayer>>(){};
        return (List)this.getMapper().readValue(geoserverLayersJSON, (TypeReference)mappingType);
    }

    public boolean deleteGeoserverLayer(String gosEndpoint, String layerID) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/deleteGeoserverLayer/" + layerID).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).delete(ClientResponse.class);
        return resp.getStatus() == 200;
    }

    public boolean addDataStore(String gosEndpoint, DataStore datastore) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"dataStoreJSON", (Object)this.getMapper().writeValueAsString((Object)datastore));
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/addDataStore").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 201;
    }

    public boolean addGeoserverLayer(String gosEndpoint, LayerConfig layerConfig, Map<String, String> slds, String crs, String style) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerConfigJSON", (Object)this.getMapper().writeValueAsString((Object)layerConfig));
        formData.add((Object)"slds", (Object)this.getMapper().writeValueAsString(slds));
        formData.add((Object)"crs", (Object)crs);
        formData.add((Object)"style", (Object)style);
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/addGeoserverLayerFromConfig").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 201;
    }

    public boolean addGeoserverLayer(String gosEndpoint, GeoserverLayer geoserverLayer, FeatureType ft, Map<String, String> slds, Integer minScale, Integer maxScale) throws IOException {
        ClientResponse resp;
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"geoserverLayer", (Object)this.getMapper().writeValueAsString((Object)geoserverLayer));
        formData.add((Object)"ft", (Object)this.getMapper().writeValueAsString((Object)ft));
        formData.add((Object)"slds", (Object)this.getMapper().writeValueAsString(slds));
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)minScale);
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)maxScale);
        }
        return (resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/addGeoserverLayer").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData)).getStatus() == 201;
    }

    public boolean addGeoserverLayer(String gosEndpoint, GeoserverLayer geoserverLayer, FeatureType ft, Map<String, String> slds) throws IOException {
        return this.addGeoserverLayer(gosEndpoint, geoserverLayer, ft, slds, null, null);
    }

    public boolean addLayerStyle(String gosEndpoint, String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws IOException {
        ClientResponse resp;
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerName", (Object)layerName);
        formData.add((Object)"styleName", (Object)styleName);
        formData.add((Object)"sld", (Object)sld);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)minScale);
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)maxScale);
        }
        return (resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/addLayerStyle").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData)).getStatus() == 201;
    }

    public boolean addLayerStyle(String gosEndpoint, String layerName, String styleName, String sld) throws IOException {
        return this.addLayerStyle(gosEndpoint, layerName, styleName, sld, null, null);
    }

    public boolean addStyle(String gosEndpoint, String styleName, String sld, Integer minScale, Integer maxScale) throws IOException {
        ClientResponse resp;
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"styleName", (Object)styleName);
        formData.add((Object)"sld", (Object)sld);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)minScale);
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)maxScale);
        }
        return (resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/addStyle").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData)).getStatus() == 201;
    }

    public boolean addStyle(String gosEndpoint, String styleName, String sld) throws IOException {
        return this.addStyle(gosEndpoint, styleName, sld, null, null);
    }

    public boolean addWorkspace(String gosEndpoint, String name, String uri) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"styleName", (Object)name);
        formData.add((Object)"sld", (Object)uri);
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/addWorkspace").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 201;
    }

    public boolean dataStoreExists(String gosEndpoint, String workspaceName, String dataStoreName) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"workspaceName", (Object)workspaceName);
        formData.add((Object)"dataStoreName", (Object)dataStoreName);
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/dataStoreExists").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return resp.getStatus() == 200;
    }

    public DataStore getDataStore(String gosEndpoint, String dataStoreName) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getDataStore/" + dataStoreName).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).get(ClientResponse.class);
        return (DataStore)this.getMapper().readValue((String)resp.getEntity(String.class), DataStore.class);
    }

    public FeatureType getFeatureType(String gosEndpoint, String name) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getFeatureType/" + name).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).get(ClientResponse.class);
        return (FeatureType)this.getMapper().readValue((String)resp.getEntity(String.class), FeatureType.class);
    }

    public GeoserverLayer getGeoserverLayer(String gosEndpoint, String name) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getGeoserverLayer/" + name).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).get(ClientResponse.class);
        return (GeoserverLayer)this.getMapper().readValue((String)resp.getEntity(String.class), GeoserverLayer.class);
    }

    public List<GeoserverLayer> getGeoserverLayers(String gosEndpoint, String datastoreName) throws IOException {
        String geoserverLayersJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getGeoserverLayers/" + datastoreName).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        TypeReference<List<GeoserverLayer>> mappingType = new TypeReference<List<GeoserverLayer>>(){};
        return (List)this.getMapper().readValue(geoserverLayersJSON, (TypeReference)mappingType);
    }

    public String getStyle(String gosEndpoint, String name) throws IOException {
        ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getStyle/" + name).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).get(ClientResponse.class);
        return (String)resp.getEntity(String.class);
    }

    public List<String> getAllStyles(String gosEndpoint) throws IOException {
        String stylesJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/getAllStyles").header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        return (List)this.getMapper().readValue(stylesJSON, (TypeReference)mappingType);
    }

    public List<String> listDataStores(String gosEndpoint) throws IOException {
        String datastoresJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/listDataStores").header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        TypeReference<List<String>> mappingType = new TypeReference<List<String>>(){};
        return (List)this.getMapper().readValue(datastoresJSON, (TypeReference)mappingType);
    }

    public List<GeoserverLayer> listLayersOfDataStore(String gosEndpoint, String datastoreName) throws IOException {
        String geoserverLayersJSON = (String)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/listLayersOfDataStore/" + datastoreName).header(this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr).accept(new String[]{"application/json"})).get(String.class);
        TypeReference<List<GeoserverLayer>> mappingType = new TypeReference<List<GeoserverLayer>>(){};
        return (List)this.getMapper().readValue(geoserverLayersJSON, (TypeReference)mappingType);
    }

    public boolean removeLayerStyle(String gosEndpoint, String layerName, String styleName, Integer minScale, Integer maxScale) throws IOException {
        ClientResponse resp;
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerName", (Object)layerName);
        formData.add((Object)"styleName", (Object)styleName);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)minScale);
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)maxScale);
        }
        return (resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/removeLayerStyle").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData)).getStatus() == 201;
    }

    public boolean removeStyle(String gosEndpoint, String styleName, Integer minScale, Integer maxScale) throws IOException {
        ClientResponse resp;
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"styleName", (Object)styleName);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)minScale);
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)maxScale);
        }
        return (resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/removeStyle").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData)).getStatus() == 201;
    }

    public boolean removeStyle(String gosEndpoint, String styleName) throws IOException {
        return this.removeStyle(gosEndpoint, styleName, null, null);
    }

    public boolean setDefaultLayerStyle(String gosEndpoint, String layerName, String styleName, String sld, Integer minScale, Integer maxScale) throws IOException {
        ClientResponse resp;
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"layerName", (Object)layerName);
        formData.add((Object)"styleName", (Object)styleName);
        formData.add((Object)"sld", (Object)sld);
        if (minScale != null) {
            formData.add((Object)"minScale", (Object)minScale);
        }
        if (maxScale != null) {
            formData.add((Object)"maxScale", (Object)maxScale);
        }
        return (resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/setDefaultLayerStyle").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData)).getStatus() == 201;
    }

    public boolean workspaceExists(String gosEndpoint, String workspaceName) throws IOException {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        formData.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        formData.add((Object)"workspaceName", (Object)workspaceName);
        ClientResponse resp = (ClientResponse)((WebResource.Builder)this.getJerseyClient().resource(gosEndpoint).path("/GeoserverManagement/workspaceExists").accept(new String[]{"application/json"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
        return (Boolean)resp.getEntity(Boolean.class);
    }
}

