/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.client;

import gr.cite.gaap.datatransferobjects.ShapeMessenger;
import gr.cite.geoanalytics.client.GeoanalyticsManagement;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.gos.client.ShapeManagement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.springframework.http.HttpEntity;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class GeoanalyticsImportManagement
extends GeoanalyticsManagement
implements Serializable {
    public GeoanalyticsImportManagement() {
    }

    public GeoanalyticsImportManagement(String authenticationStr) {
        super(authenticationStr);
    }

    public void importLayerFromRDD(String geoanalyticsEndpoint, String gosEndpoint, String layerName, JavaRDD<List<ShapeMessenger>> featuresRDD, String srid) throws Exception {
        JavaSparkContext jsc = new JavaSparkContext(featuresRDD.context());
        if (geoanalyticsEndpoint == null || geoanalyticsEndpoint.isEmpty() || gosEndpoint == null || gosEndpoint.isEmpty()) {
            throw new Exception("No gos or geoanalytics endpoint were correct: geoanalyticsEP=" + geoanalyticsEndpoint + " gosEP=" + gosEndpoint);
        }
        Layer layer = new Layer();
        layer.setIsTemplate((short)0);
        layer.setDescription("This layer is generated by geoanalytics functions");
        layer.setReplicationFactor(Integer.valueOf(1));
        String layerID = this.createLayer(geoanalyticsEndpoint, layer);
        if (layerID == null || layerID.isEmpty()) {
            return;
        }
        layer.setId(UUID.fromString(layerID));
        Broadcast sridBC = jsc.broadcast((Object)srid);
        final Broadcast layerIdBC = jsc.broadcast((Object)layerID);
        final Broadcast authStrBC = jsc.broadcast((Object)this.authenticationStr);
        final Broadcast gosEndpointBC = jsc.broadcast((Object)gosEndpoint);
        Set results = (Set)featuresRDD.map((Function)new Function<List<ShapeMessenger>, Set<Boolean>>(){
            private static final long serialVersionUID = -8923332794337126038L;

            public Set<Boolean> call(List<ShapeMessenger> shapeMessengers) throws Exception {
                List<Shape> shapes = shapeMessengers.stream().map(shapeMessenger -> {
                    try {
                        Shape shape = shapeMessenger.toShape();
                        shape.setLayerID(UUID.fromString((String)layerIdBC.value()));
                        System.out.println(shape.getId().toString());
                        return shape;
                    }
                    catch (Exception e) {
                        System.out.println("AN error occured: " + e.getMessage());
                        return null;
                    }
                }).collect(Collectors.toList());
                ShapeManagement shapeManagement = new ShapeManagement((String)authStrBC.getValue());
                boolean status = false;
                try {
                    status = shapeManagement.insertShapes((String)gosEndpointBC.getValue(), shapes);
                }
                catch (Exception ex) {
                    return new HashSet<Boolean>(Arrays.asList(new Boolean(false)));
                }
                return new HashSet<Boolean>(Arrays.asList(new Boolean(status)));
            }
        }).reduce((Function2 & Serializable)(resultsL, resultsR) -> {
            HashSet merged = new HashSet();
            merged.addAll(resultsL);
            merged.addAll(resultsR);
            return merged;
        });
        if (results.contains(new Boolean(false))) {
            ShapeManagement shapeManagement = new ShapeManagement(this.authenticationStr);
            shapeManagement.deleteShapesOfLayer(gosEndpoint, layerID);
            this.deleteLayer(geoanalyticsEndpoint, layer);
        }
    }

    public String createLayer(String geoanalyticsEndpoint, Layer layer) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        headers.add((Object)"Content-Type", (Object)"application/json");
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        HttpEntity request = new HttpEntity((Object)layer, (MultiValueMap)headers);
        return (String)restTemplate.postForObject(geoanalyticsEndpoint + "/createLayerSpark", (Object)request, String.class, new Object[0]);
    }

    public String deleteLayer(String geoanalyticsEndpoint, Layer layer) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)this.HEADER_AUTHENTICATION_PARAM_NAME, (Object)this.authenticationStr);
        headers.add((Object)"Content-Type", (Object)"application/json");
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().add(new MappingJackson2HttpMessageConverter());
        HttpEntity request = new HttpEntity((Object)layer, (MultiValueMap)headers);
        return (String)restTemplate.postForObject(geoanalyticsEndpoint + "/deleteLayerSpark", (Object)request, String.class, new Object[0]);
    }
}

