/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.style.ShapeMarkFactory;
import org.geotools.renderer.style.WellKnownMarkFactory;
import org.geotools.renderer.style.shape.ExplicitBoundsShape;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class QGISMarkFactory
implements MarkFactory {
    private static final String PREFIX = "qgis://";
    private static final Logger LOGGER = Logging.getLogger("org.geotools.rendering");
    private static Shape star = QGISMarkFactory.star();
    private static Shape triangle = QGISMarkFactory.triangle();
    private static final Shape arrow = QGISMarkFactory.arrow();
    private static Shape arrowhead = QGISMarkFactory.arrowHead();
    private static Shape filled_arrowhead = QGISMarkFactory.filledArrowHead();
    private static Shape diamond;
    private static Shape pentagon;
    private static Shape crossFill;
    private static Shape diagonalHalfSquare;
    private static Shape halfSquare;
    private static Shape hexagon;
    private static Shape leftHalfTriangle;
    private static Shape rightHalfTriangle;
    private static Shape quarterCricle;
    private static Shape semiCircle;
    private static Shape thirdCircle;
    private static Shape quarterSquare;

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        if (symbolUrl == null) {
            return null;
        }
        String wellKnownName = symbolUrl.evaluate(feature, String.class);
        LOGGER.finer("fetching mark of name " + wellKnownName);
        if (wellKnownName.equalsIgnoreCase("qgis://cross")) {
            LOGGER.finer("returning qgis cross");
            return ShapeMarkFactory.shapes.get("plus");
        }
        if (wellKnownName.equalsIgnoreCase("qgis://circle")) {
            LOGGER.finer("returning qgis circle");
            return WellKnownMarkFactory.circle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://triangle")) {
            LOGGER.finer("returning qgis triangle");
            return triangle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://equilateral_triangle") || wellKnownName.equalsIgnoreCase("equilateral_triangle")) {
            LOGGER.finer("returning qgis triangle");
            return WellKnownMarkFactory.triangle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://star")) {
            LOGGER.finer("returning qgis star");
            return star;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://cross2") || wellKnownName.equalsIgnoreCase("cross2")) {
            LOGGER.finer("returning qgis cross2");
            return ShapeMarkFactory.shapes.get("times");
        }
        if (wellKnownName.equalsIgnoreCase("qgis://arrow")) {
            LOGGER.finer("returning qgis arrow");
            return arrow;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://diamond") || wellKnownName.equalsIgnoreCase("diamond")) {
            LOGGER.finer("returning qgis diamond");
            return diamond;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://pentagon") || wellKnownName.equalsIgnoreCase("pentagon")) {
            LOGGER.finer("returning qgis pentagon");
            return pentagon;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://rectangle") || wellKnownName.equalsIgnoreCase("rectangle")) {
            LOGGER.finer("returning qgis rectangle");
            return WellKnownMarkFactory.square;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://regular_star") || wellKnownName.equalsIgnoreCase("regular_star")) {
            LOGGER.finer("returning qgis regular_star");
            return WellKnownMarkFactory.star;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://line") || wellKnownName.equalsIgnoreCase("line")) {
            LOGGER.finer("returning qgis line");
            return ShapeMarkFactory.shapes.get("vertline");
        }
        if (wellKnownName.equalsIgnoreCase("qgis://arrowhead") || wellKnownName.equalsIgnoreCase("arrowhead")) {
            LOGGER.finer("returning qgis arrowhead");
            return arrowhead;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://filled_arrowhead") || wellKnownName.equalsIgnoreCase("filled_arrowhead")) {
            LOGGER.finer("returning qgis filled_arrowhead");
            return filled_arrowhead;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://crossfill") || wellKnownName.equalsIgnoreCase("crossfill")) {
            LOGGER.finer("returning qgis filled cross");
            return crossFill;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://diagonalhalfsquare") || wellKnownName.equalsIgnoreCase("diagonalhalfsquare")) {
            LOGGER.finer("returning qgis diagonal half square");
            return diagonalHalfSquare;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://HalfSquare") || wellKnownName.equalsIgnoreCase("HalfSquare")) {
            LOGGER.finer("returning qgis half square");
            return halfSquare;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://hexagon") || wellKnownName.equalsIgnoreCase("hexagon")) {
            LOGGER.finer("returning qgis hexagon");
            return hexagon;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://lefthalftriangle") || wellKnownName.equalsIgnoreCase("lefthalftriangle")) {
            LOGGER.finer("returning qgis lefthalftriangle");
            return leftHalfTriangle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://righthalftriangle") || wellKnownName.equalsIgnoreCase("righthalftriangle")) {
            LOGGER.finer("returning qgis righthalftriangle");
            return rightHalfTriangle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://quartercircle") || wellKnownName.equalsIgnoreCase("quartercircle")) {
            LOGGER.finer("returning qgis quartercircle");
            return quarterCricle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://semicircle") || wellKnownName.equalsIgnoreCase("semicircle")) {
            LOGGER.finer("returning qgis semicircle");
            return semiCircle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://thirdcircle") || wellKnownName.equalsIgnoreCase("thirdcircle")) {
            LOGGER.finer("returning qgis thirdcircle");
            return thirdCircle;
        }
        if (wellKnownName.equalsIgnoreCase("qgis://quartersquare") || wellKnownName.equalsIgnoreCase("quartersquare")) {
            LOGGER.finer("returning qgis quartersquare");
            return quarterSquare;
        }
        return null;
    }

    private static Shape arrow() {
        GeneralPath arrowPath = new GeneralPath(0);
        arrowPath.moveTo(0.3f, -0.3f);
        arrowPath.lineTo(0.5f, 0.0f);
        arrowPath.lineTo(0.3f, 0.3f);
        arrowPath.lineTo(0.3f, 0.1f);
        arrowPath.lineTo(-0.5f, 0.1f);
        arrowPath.lineTo(-0.5f, -0.1f);
        arrowPath.lineTo(0.3f, -0.1f);
        arrowPath.lineTo(0.3f, -0.3f);
        AffineTransform at = new AffineTransform();
        at.rotate(1.5707963267948966);
        arrowPath.transform(at);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(arrowPath);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape star() {
        GeneralPath starPath = new GeneralPath(0);
        starPath.moveTo(0.0f, 0.5f);
        starPath.lineTo(0.2f, 0.1f);
        starPath.lineTo(0.5f, 0.1f);
        starPath.lineTo(0.2f, -0.1f);
        starPath.lineTo(0.5f, -0.5f);
        starPath.lineTo(0.0f, -0.2f);
        starPath.lineTo(-0.5f, -0.5f);
        starPath.lineTo(-0.2f, -0.1f);
        starPath.lineTo(-0.5f, 0.1f);
        starPath.lineTo(-0.2f, 0.1f);
        starPath.lineTo(0.0f, 0.5f);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(starPath);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape arrowHead() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.4f);
        gp.lineTo(0.0f, 0.0f);
        gp.lineTo(-0.5f, -0.4f);
        ExplicitBoundsShape arrowHead = new ExplicitBoundsShape(gp);
        arrowHead.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        return arrowHead;
    }

    private static Shape filledArrowHead() {
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.4f);
        gp.lineTo(0.0f, 0.0f);
        gp.lineTo(-0.5f, -0.4f);
        gp.closePath();
        ExplicitBoundsShape filledArrowHead = new ExplicitBoundsShape(gp);
        filledArrowHead.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        return filledArrowHead;
    }

    private static Shape triangle() {
        GeneralPath trianglePath = new GeneralPath(0);
        trianglePath.moveTo(0.0f, 1.0f);
        trianglePath.lineTo(0.866f, -0.8f);
        trianglePath.lineTo(-0.866f, -0.8f);
        trianglePath.lineTo(0.0f, 1.0f);
        AffineTransform at = new AffineTransform();
        at.translate(0.0, -0.1);
        at.scale(0.5, 0.5);
        trianglePath.transform(at);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(trianglePath);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape crossFill() {
        GeneralPath path = new GeneralPath(0);
        path.moveTo(-0.5f, -0.1f);
        path.lineTo(-0.5f, -0.1f);
        path.lineTo(-0.5f, 0.1f);
        path.lineTo(-0.1f, 0.1f);
        path.lineTo(-0.1f, 0.5f);
        path.lineTo(0.1f, 0.5f);
        path.lineTo(0.1f, 0.1f);
        path.lineTo(0.5f, 0.1f);
        path.lineTo(0.5f, -0.1f);
        path.lineTo(0.1f, -0.1f);
        path.lineTo(0.1f, -0.5f);
        path.lineTo(-0.1f, -0.5f);
        path.lineTo(-0.1f, -0.1f);
        path.lineTo(-0.5f, -0.1f);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(path);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape diagonalHalfSquare() {
        GeneralPath path = new GeneralPath(0);
        path.moveTo(-0.5f, -0.5f);
        path.lineTo(0.5f, -0.5f);
        path.lineTo(-0.5f, 0.5f);
        path.lineTo(-0.5f, -0.5f);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(path);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape hexagon() {
        GeneralPath path = new GeneralPath(0);
        path.moveTo(-0.433f, -0.25f);
        path.lineTo(-0.433f, 0.25f);
        path.lineTo(0.0f, 0.5f);
        path.lineTo(0.433f, 0.25f);
        path.lineTo(0.433f, -0.25f);
        path.lineTo(0.0f, -0.5f);
        path.lineTo(-0.433f, -0.25f);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(path);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape leftHalfTriangle() {
        GeneralPath path = new GeneralPath(0);
        path.moveTo(0.0f, -0.5f);
        path.lineTo(0.0f, 0.5f);
        path.lineTo(0.5f, -0.5f);
        path.lineTo(0.0f, -0.5f);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(path);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape rightHalfTriangle() {
        GeneralPath path = new GeneralPath(0);
        path.moveTo(0.0f, -0.5f);
        path.lineTo(0.0f, 0.5f);
        path.lineTo(-0.5f, -0.5f);
        path.lineTo(0.0f, -0.5f);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(path);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape quarterCircle() {
        Arc2D.Double d = new Arc2D.Double(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0), 180.0, 90.0, 2);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(d);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape semiCircle() {
        Arc2D.Double d = new Arc2D.Double(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0), 180.0, 180.0, 2);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(d);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape thirdCircle() {
        Arc2D.Double d = new Arc2D.Double(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0), 150.0, 120.0, 2);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(d);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape halfSquare() {
        Rectangle2D.Double s = new Rectangle2D.Double(-0.5, -0.5, 0.5, 1.0);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(s);
        shape.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        return shape;
    }

    private static Shape quarterSquare() {
        Rectangle2D.Double s = new Rectangle2D.Double(-0.5, 0.0, 0.5, 0.5);
        ExplicitBoundsShape shape = new ExplicitBoundsShape(s);
        shape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        return shape;
    }

    static {
        crossFill = QGISMarkFactory.crossFill();
        diagonalHalfSquare = QGISMarkFactory.diagonalHalfSquare();
        halfSquare = QGISMarkFactory.halfSquare();
        hexagon = QGISMarkFactory.hexagon();
        leftHalfTriangle = QGISMarkFactory.leftHalfTriangle();
        rightHalfTriangle = QGISMarkFactory.rightHalfTriangle();
        quarterCricle = QGISMarkFactory.quarterCircle();
        semiCircle = QGISMarkFactory.semiCircle();
        thirdCircle = QGISMarkFactory.thirdCircle();
        quarterSquare = QGISMarkFactory.quarterSquare();
        GeneralPath diamondPath = new GeneralPath(0);
        diamondPath.moveTo(0.0f, 1.0f);
        diamondPath.lineTo(1.0f, 0.0f);
        diamondPath.lineTo(0.0f, -1.0f);
        diamondPath.lineTo(-1.0f, 0.0f);
        diamondPath.lineTo(0.0f, 1.0f);
        AffineTransform at = new AffineTransform();
        at.scale(0.5, 0.5);
        diamondPath.transform(at);
        diamond = new ExplicitBoundsShape(diamondPath);
        ((ExplicitBoundsShape)diamond).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        GeneralPath pentagonPath = new GeneralPath(0);
        pentagonPath.moveTo(0.0f, 1.0f);
        pentagonPath.lineTo(0.9511f, 0.309f);
        pentagonPath.lineTo(0.5878f, -0.809f);
        pentagonPath.lineTo(-0.5878f, -0.809f);
        pentagonPath.lineTo(-0.9511f, 0.309f);
        pentagonPath.lineTo(0.0f, 1.0f);
        at = new AffineTransform();
        at.scale(0.5, 0.5);
        pentagonPath.transform(at);
        pentagon = new ExplicitBoundsShape(pentagonPath);
        ((ExplicitBoundsShape)pentagon).setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
    }
}

