/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.bindings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import net.opengis.wfs20.FeatureCollectionType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.wfs.CompositeFeatureCollection;
import org.geotools.xml.EMFUtils;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeature;

public class WFSParsingUtils {
    public static EObject FeatureCollectionType_parse(EObject fct, ElementInstance instance, Node node) {
        SimpleFeature[] featureMembers;
        SimpleFeatureCollection fc = null;
        fc = (SimpleFeatureCollection)node.getChildValue(FeatureCollection.class);
        if (fc == null) {
            fc = new DefaultFeatureCollection(null, null);
        }
        if ((featureMembers = (SimpleFeature[])node.getChildValue(SimpleFeature[].class)) != null) {
            Collection<SimpleFeature> collection = DataUtilities.collectionCast(fc);
            for (int i = 0; i < featureMembers.length; ++i) {
                collection.add(featureMembers[i]);
            }
        } else {
            Collection<SimpleFeature> collection = DataUtilities.collectionCast(fc);
            List featureMember = node.getChildValues(SimpleFeature.class);
            for (SimpleFeature f : featureMember) {
                collection.add(f);
            }
        }
        if (!fc.isEmpty()) {
            if (EMFUtils.has(fct, "feature")) {
                EMFUtils.add(fct, "feature", (Object)fc);
            } else {
                EMFUtils.add(fct, "member", (Object)fc);
            }
        }
        return fct;
    }

    public static Object FeatureCollectionType_getProperty(EObject fc, QName name) {
        List<FeatureCollection> features = WFSParsingUtils.features(fc);
        FeatureCollection first = features.get(0);
        if ("boundedBy".equals(name.getLocalPart())) {
            ReferencedEnvelope bounds = null;
            if (features.size() == 1) {
                bounds = first.getBounds();
            } else {
                bounds = new ReferencedEnvelope(first.getBounds());
                for (int i = 1; i < features.size(); ++i) {
                    bounds.expandToInclude(features.get(i).getBounds());
                }
            }
            if ((bounds == null || bounds.isNull()) && "http://www.opengis.net/wfs/2.0".equals(name.getNamespaceURI())) {
                return null;
            }
            return bounds;
        }
        if ("featureMember".equals(name.getLocalPart()) || "member".equals(name.getLocalPart())) {
            Number n;
            if (features.size() == 1) {
                return first;
            }
            if ("featureMember".equals(name.getLocalPart())) {
                return new CompositeFeatureCollection(features);
            }
            int numberMatched = -1;
            if (EMFUtils.has(fc, "numberMatched")) {
                n = (Number)EMFUtils.get(fc, "numberMatched");
                numberMatched = n != null ? n.intValue() : -1;
            } else if (EMFUtils.has(fc, "numberOfFeatures")) {
                n = (Number)EMFUtils.get(fc, "numberOfFeatures");
                numberMatched = n != null ? n.intValue() : -1;
            }
            ArrayList<FeatureCollectionType> members = new ArrayList<FeatureCollectionType>(features.size());
            Iterator<FeatureCollection> it = features.iterator();
            while (it.hasNext()) {
                FeatureCollection featureCollection = it.next();
                FeatureCollectionType member = Wfs20Factory.eINSTANCE.createFeatureCollectionType();
                member.setTimeStamp((Calendar)EMFUtils.get(fc, "timeStamp"));
                member.getMember().add(featureCollection);
                members.add(member);
                if (numberMatched == -1) continue;
                int size = featureCollection.size();
                member.setNumberReturned(BigInteger.valueOf(size));
                if (it.hasNext()) {
                    numberMatched -= size;
                    member.setNumberMatched(BigInteger.valueOf(size));
                    continue;
                }
                member.setNumberMatched(BigInteger.valueOf(numberMatched));
            }
            return members;
        }
        return null;
    }

    public static List<FeatureCollection> features(EObject obj) {
        return (List)(EMFUtils.has(obj, "feature") ? EMFUtils.get(obj, "feature") : EMFUtils.get(obj, "member"));
    }
}

