/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.util.Converters;
import org.geotools.xlink.XLINK;
import org.geotools.xml.Schemas;
import org.geotools.xs.XS;
import org.geotools.xs.bindings.XSAnyTypeBinding;
import org.opengis.feature.Attribute;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.Identifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class ComplexSupportXSAnyTypeBinding
extends XSAnyTypeBinding {
    private XSDIdRegistry idSet;

    public ComplexSupportXSAnyTypeBinding(XSDIdRegistry idRegistry) {
        this.idSet = idRegistry;
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if (object instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)object;
            Property property = complex.getProperty(ComplexSupportXSAnyTypeBinding.toTypeName(name));
            if (property != null && !(property instanceof ComplexAttribute)) {
                return property.getValue();
            }
            if ("id".equals(name.getLocalPart())) {
                return complex.getIdentifier();
            }
        }
        return null;
    }

    private static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return new NameImpl(name.getLocalPart());
        }
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List getProperties(Object object, XSDElementDeclaration element) throws Exception {
        ArrayList<Object[]> properties;
        block25: {
            ArrayList anyElementParticles;
            XSDElementDeclaration wrapper;
            XSDParticle substitutedChildParticle;
            boolean isAnyType;
            if (object == null) {
                return null;
            }
            properties = new ArrayList<Object[]>();
            XSDTypeDefinition typeDef = element.getTypeDefinition();
            boolean bl = isAnyType = typeDef.getName() != null && typeDef.getTargetNamespace() != null && typeDef.getName().equals(XS.ANYTYPE.getLocalPart()) && typeDef.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema");
            if (isAnyType) {
                Collection<Property> complexAtts;
                if (object instanceof Collection) {
                    complexAtts = (Collection<Property>)object;
                } else if (object instanceof ComplexAttribute) {
                    complexAtts = ((ComplexAttribute)object).getProperties();
                } else {
                    return null;
                }
                for (Object e : complexAtts) {
                    Object propertyElement;
                    AttributeDescriptor attributeDescriptor;
                    if (!(e instanceof ComplexAttribute) || (attributeDescriptor = ((Attribute)e).getDescriptor()).getUserData() == null || (propertyElement = attributeDescriptor.getUserData().get(XSDElementDeclaration.class)) == null || !(propertyElement instanceof XSDElementDeclaration)) continue;
                    XSDParticle substitutedChildParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
                    substitutedChildParticle2.setMaxOccurs(attributeDescriptor.getMaxOccurs());
                    substitutedChildParticle2.setMinOccurs(attributeDescriptor.getMinOccurs());
                    XSDElementDeclaration wrapper2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper2.setResolvedElementDeclaration((XSDElementDeclaration)propertyElement);
                    substitutedChildParticle2.setContent(wrapper2);
                    properties.add(new Object[]{substitutedChildParticle2, e});
                }
                return properties;
            }
            if (object instanceof ComplexAttribute) {
                ComplexAttribute complex = (ComplexAttribute)object;
                for (XSDParticle xSDParticle : Schemas.getChildElementParticles(element.getTypeDefinition(), true)) {
                    void var9_15;
                    XSDElementDeclaration xSDElementDeclaration = (XSDElementDeclaration)xSDParticle.getContent();
                    if (xSDElementDeclaration.isElementDeclarationReference()) {
                        XSDElementDeclaration xSDElementDeclaration2 = xSDElementDeclaration.getResolvedElementDeclaration();
                    }
                    for (XSDElementDeclaration e : var9_15.getSubstitutionGroup()) {
                        NameImpl name = new NameImpl(e.getTargetNamespace(), e.getName());
                        Collection<Property> nameProperties = complex.getProperties(name);
                        if (nameProperties.isEmpty()) continue;
                        substitutedChildParticle = XSDFactory.eINSTANCE.createXSDParticle();
                        substitutedChildParticle.setMaxOccurs(xSDParticle.getMaxOccurs());
                        substitutedChildParticle.setMinOccurs(xSDParticle.getMinOccurs());
                        wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                        wrapper.setResolvedElementDeclaration(e);
                        substitutedChildParticle.setContent(wrapper);
                        for (Property property : nameProperties) {
                            if (property instanceof ComplexAttribute) {
                                properties.add(new Object[]{substitutedChildParticle, property});
                                continue;
                            }
                            if (!(property instanceof GeometryAttribute)) continue;
                            Object attType = complex.getType().getUserData().get(XSDTypeDefinition.class);
                            boolean duplicate = false;
                            if (attType != null && attType instanceof XSDTypeDefinition) {
                                XSDTypeDefinition attTypeDef = (XSDTypeDefinition)attType;
                                for (XSDParticle attChild : Schemas.getChildElementParticles(attTypeDef, true)) {
                                    XSDElementDeclaration childEl = (XSDElementDeclaration)attChild.getContent();
                                    if (childEl.isElementDeclarationReference()) {
                                        childEl = childEl.getResolvedElementDeclaration();
                                    }
                                    if (!childEl.equals(e)) continue;
                                    duplicate = true;
                                    break;
                                }
                            }
                            if (duplicate) continue;
                            properties.add(new Object[]{substitutedChildParticle, property.getValue()});
                        }
                    }
                }
            }
            if ((anyElementParticles = new ArrayList(Schemas.getAnyElementParticles(element.getTypeDefinition()))).size() <= 0) break block25;
            Collection<Property> complexAtts = null;
            if (object instanceof Collection) {
                complexAtts = (Collection<Property>)object;
            } else if (object instanceof ComplexAttribute) {
                complexAtts = ((ComplexAttribute)object).getProperties();
            }
            if (properties.isEmpty()) {
                for (Property property : complexAtts) {
                    Object propertyElement;
                    ComplexAttribute newComplexAtt;
                    AttributeDescriptor descriptor;
                    if (!(property instanceof ComplexAttribute) || (descriptor = (newComplexAtt = (ComplexAttribute)property).getDescriptor()).getUserData() == null || (propertyElement = descriptor.getUserData().get(XSDElementDeclaration.class)) == null || !(propertyElement instanceof XSDElementDeclaration)) continue;
                    XSDParticle substitutedChildParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
                    substitutedChildParticle3.setMaxOccurs(descriptor.getMaxOccurs());
                    substitutedChildParticle3.setMinOccurs(descriptor.getMinOccurs());
                    XSDElementDeclaration wrapper3 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper3.setResolvedElementDeclaration((XSDElementDeclaration)propertyElement);
                    substitutedChildParticle3.setContent(wrapper3);
                    properties.add(new Object[]{substitutedChildParticle3, newComplexAtt});
                }
            } else {
                ArrayList arrayList = new ArrayList(Schemas.getChildElementParticles(element.getTypeDefinition(), false));
                for (Property complex : complexAtts) {
                    Object propertyElement;
                    if (!(complex instanceof ComplexAttribute)) continue;
                    ComplexAttribute newComplexAtt = (ComplexAttribute)complex;
                    AttributeDescriptor descriptor = ((Attribute)complex).getDescriptor();
                    if (descriptor.getUserData() == null || (propertyElement = descriptor.getUserData().get(XSDElementDeclaration.class)) == null || !(propertyElement instanceof XSDElementDeclaration)) continue;
                    substitutedChildParticle = XSDFactory.eINSTANCE.createXSDParticle();
                    substitutedChildParticle.setMaxOccurs(descriptor.getMaxOccurs());
                    substitutedChildParticle.setMinOccurs(descriptor.getMinOccurs());
                    wrapper = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    wrapper.setResolvedElementDeclaration((XSDElementDeclaration)propertyElement);
                    substitutedChildParticle.setContent(wrapper);
                    boolean propertyExist = false;
                    for (XSDParticle childParticle : arrayList) {
                        String newName;
                        String existingName;
                        XSDElementDeclaration childElement = (XSDElementDeclaration)childParticle.getContent();
                        if (childElement.isElementDeclarationReference()) {
                            childElement = childElement.getResolvedElementDeclaration();
                        }
                        if (!(existingName = childElement.getName()).equals(newName = newComplexAtt.getDescriptor().getName().getLocalPart())) continue;
                        propertyExist = true;
                        break;
                    }
                    if (propertyExist) continue;
                    properties.add(new Object[]{substitutedChildParticle, newComplexAtt});
                }
            }
        }
        return properties;
    }

    private void checkXlinkHref(Object value, ComplexAttribute att) {
        if (value != null && value instanceof ComplexAttribute) {
            ComplexAttribute object = (ComplexAttribute)value;
            if (!(object.getType() instanceof FeatureTypeImpl)) {
                return;
            }
            Identifier ident = object.getIdentifier();
            if (ident == null) {
                return;
            }
            String id = Converters.convert(ident.getID(), String.class);
            if (this.idSet.idExists(id)) {
                Object clientProperties = att.getUserData().get(Attributes.class);
                HashMap<Name, String> map = null;
                if (clientProperties == null) {
                    map = new HashMap<Name, String>();
                    att.getUserData().put(Attributes.class, map);
                } else {
                    map = (HashMap<Name, String>)clientProperties;
                }
                map.put(ComplexSupportXSAnyTypeBinding.toTypeName(XLINK.HREF), "#" + id.toString());
                att.setValue(Collections.emptyList());
            }
        }
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        if (object instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)object;
            if (complex.getProperties().size() == 1) {
                Property prop = complex.getProperties().iterator().next();
                this.checkXlinkHref(prop, complex);
            }
            GML3EncodingUtils.encodeClientProperties(complex, value);
            GML3EncodingUtils.encodeSimpleContent(complex, document, value);
        } else if (!this.isPlaceholderObject(object)) {
            GML3EncodingUtils.encodeAsText(document, value, object);
        }
        return value;
    }

    private boolean isPlaceholderObject(Object object) {
        return object != null && object.getClass().isAssignableFrom(Object.class);
    }
}

