/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements;

import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.elements.MetaDataForm;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.GcubeISOmetadata;
import gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.wrappers.MetaDataImpL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.spatial.data.geonetwork.iso.EnvironmentConfiguration;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.identification.TopicCategory;
import org.opengis.metadata.spatial.GeometricObjectType;
import org.opengis.metadata.spatial.TopologyLevel;
import org.opengis.util.InternationalString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaData {
    private static Logger log = LoggerFactory.getLogger(MetaData.class);
    private GcubeISOmetadata gcubeMetadata;
    private EnvironmentConfiguration configuration;
    private Locale Language;

    public MetaData(String tenantName) throws Exception {
        log.debug("Initialize MetaData in scope: " + tenantName);
        ScopeProvider.instance.set(tenantName);
        this.gcubeMetadata = new GcubeISOmetadata();
        this.configuration = this.gcubeMetadata.getConfig();
        this.configuration.setHttpProtocolDeclaration(null);
        this.configuration.setProviderEMail(null);
        this.configuration.setDistributorEMail(null);
        this.Language = Locale.ENGLISH;
    }

    public MetaDataImpL getMetadata() {
        MetaDataImpL meta = null;
        meta = this.gcubeMetadata.getMetadata();
        meta.setLanguage(this.Language);
        return meta;
    }

    public void setProjectName(String projectName) {
        log.trace("Setting project name: " + projectName);
        this.configuration.setProjectName(projectName);
    }

    public String getProjectName() {
        return this.configuration.getProjectName();
    }

    public Locale getLanguage() {
        return this.Language;
    }

    public void setLanguage(MetaDataForm.Language lang) {
        log.trace("Setting language: " + (Object)((Object)lang));
        switch (lang) {
            case ENGLISH: {
                this.Language = Locale.ENGLISH;
                break;
            }
            case FRENCH: {
                this.Language = Locale.FRENCH;
                break;
            }
            case GERMAN: {
                this.Language = Locale.GERMAN;
                break;
            }
            case ITALIAN: {
                this.Language = Locale.ITALIAN;
                break;
            }
            case JAPANESE: {
                this.Language = Locale.JAPANESE;
                break;
            }
            case KOREAN: {
                this.Language = Locale.KOREAN;
                break;
            }
            case CHINESE: {
                this.Language = Locale.CHINESE;
                break;
            }
            case SIMPLIFIED_CHINESE: {
                this.Language = Locale.SIMPLIFIED_CHINESE;
                break;
            }
            case TRADITIONAL_CHINESE: {
                this.Language = Locale.TRADITIONAL_CHINESE;
                break;
            }
            default: {
                this.Language = Locale.ENGLISH;
            }
        }
    }

    public String getProviderSite() {
        return this.configuration.getProviderSite();
    }

    public void setProviderSite(String providerSite) {
        if (providerSite != null) {
            log.trace("Setting provider site: " + providerSite);
            this.configuration.setProviderSite(providerSite);
        }
    }

    public String getProviderOrganisationName() {
        return this.configuration.getProviderOrganisationName();
    }

    public void setProviderOrganisationName(String providerOrganisationName) {
        if (providerOrganisationName != null) {
            log.trace("Setting provider organisation name: " + providerOrganisationName);
            this.configuration.setProviderOrganisationName(providerOrganisationName);
        }
    }

    public String getProviderIndividualName() {
        return this.configuration.getProviderIndividualName();
    }

    public void setProviderIndividualName(String providerIndividualName) {
        if (providerIndividualName != null) {
            log.trace("Setting provider individual name: " + providerIndividualName);
            this.configuration.setProviderIndividualName(providerIndividualName);
        }
    }

    public String getUserLimitation() {
        return this.configuration.getLicense();
    }

    public void setUserLimitation(String licence) {
        log.trace("Setting user limitation: " + licence);
        this.configuration.setLicense(licence);
    }

    public String getDistributorSite() {
        return this.configuration.getDistributorSite();
    }

    public void setDistributorSite(String distributorSite) {
        if (distributorSite != null) {
            log.trace("Setting distributor site: " + distributorSite);
            this.configuration.setDistributorSite(distributorSite);
        }
    }

    public String getDistributorOrganisationName() {
        return this.configuration.getDistributorOrganisationName();
    }

    public void setDistributorOrganisationName(String distributorOrganisationName) {
        if (distributorOrganisationName != null) {
            log.trace("Setting distributor organisation name: " + distributorOrganisationName);
            this.configuration.setDistributorOrganisationName(distributorOrganisationName);
        }
    }

    public String getDistributorIndividualName() {
        return this.configuration.getDistributorIndividualName();
    }

    public void setDistributorIndividualName(String distributorIndividualName) {
        if (distributorIndividualName != null) {
            log.trace("Setting distributor individual name: " + distributorIndividualName);
            this.configuration.setDistributorIndividualName(distributorIndividualName);
        }
    }

    public String getUser() {
        return this.gcubeMetadata.getUser();
    }

    public void setUser(String user) {
        log.trace("Setting user name: " + user);
        this.gcubeMetadata.setUser(user);
    }

    public String getTitle() {
        return this.gcubeMetadata.getTitle();
    }

    public void setTitle(String title) {
        log.trace("Setting title: " + title);
        this.gcubeMetadata.setTitle(title);
    }

    public Date getDate() {
        return this.gcubeMetadata.getCreationDate();
    }

    public void setDate(Date date) {
        log.trace("Setting date: " + date);
        this.gcubeMetadata.setCreationDate(date);
    }

    public PresentationForm getPresentationForm() {
        return this.gcubeMetadata.getPresentationForm();
    }

    public void setPresentationForm(PresentationForm presentationForm) {
        log.trace("Setting presentation form: " + presentationForm);
        this.gcubeMetadata.setPresentationForm(presentationForm);
    }

    public String getMetadataAbstract() {
        return this.gcubeMetadata.getAbstractField();
    }

    public void setMetadataAbstract(String metadataAbstract) {
        log.trace("Setting abstract: " + metadataAbstract);
        this.gcubeMetadata.setAbstractField(metadataAbstract);
    }

    public String getMetadataPurpose() {
        return this.gcubeMetadata.getPurpose();
    }

    public void setMetadataPurpose(String metadataPurpose) {
        log.trace("Setting purpose: " + metadataPurpose);
        this.gcubeMetadata.setPurpose(metadataPurpose);
    }

    public List<String> getCredits() {
        return this.gcubeMetadata.getCredits();
    }

    public void setCredits(List<String> credits) {
        log.trace("Setting list of credits: " + credits);
        for (String credit : credits) {
            this.gcubeMetadata.addCredits(credit);
        }
    }

    public void addCredit(String credit) {
        this.gcubeMetadata.addCredits(credit);
    }

    public HashMap<Thesaurus, HashSet<String>> getKeywords() {
        return this.gcubeMetadata.getDescriptiveKeywords();
    }

    public void setKeywords(List<String> keywords) {
        log.trace("Setting list of keywords: " + keywords);
        for (String keyword : keywords) {
            this.gcubeMetadata.addKeyword(keyword, (Thesaurus)this.gcubeMetadata.getConfig().getThesauri().get("General"));
        }
    }

    public void addKeyword(String keyword) {
        log.trace("Adding keyword to list: " + keyword);
        this.gcubeMetadata.addKeyword(keyword, (Thesaurus)this.gcubeMetadata.getConfig().getThesauri().get("General"));
    }

    public List<TopicCategory> getTopicCategory() {
        return this.gcubeMetadata.getTopicCategories();
    }

    public void setTopicCategory(List<TopicCategory> topicCategory) {
        log.trace("Setting list of topic category: " + topicCategory);
        for (TopicCategory topic : topicCategory) {
            this.gcubeMetadata.addTopicCategory(topic);
        }
    }

    public void addTopicCategory(TopicCategory topicCategory) {
        log.trace("Adding topic category to list: " + topicCategory);
        this.gcubeMetadata.addTopicCategory(topicCategory);
    }

    public ExtentImpl getExtent() {
        return this.gcubeMetadata.getExtent();
    }

    public void setExtent(double west, double east, double south, double north) {
        log.trace("Setting bounding box: [west=" + west + " ,east=" + east + " ,south=" + south + " ,north=" + north);
        ExtentImpl extent = new ExtentImpl();
        extent.setGeographicElements(Collections.singleton(new GeographicBoundingBoxImpl(west, east, south, north)));
        extent.setDescription((InternationalString)new SimpleInternationalString("Bounding box"));
    }

    public void setExtent(ExtentImpl extent) {
        log.trace("Setting bounding box: " + extent);
        this.gcubeMetadata.setExtent(extent);
    }

    public GeometricObjectType getGeometricObjectType() {
        return this.gcubeMetadata.getGeometricObjectType();
    }

    public void setGeometricObjectType(GeometricObjectType geometricObjectType) {
        log.trace("Setting geometric object: " + geometricObjectType);
        this.gcubeMetadata.setGeometricObjectType(geometricObjectType);
    }

    public TopologyLevel getTopologyLevel() {
        return this.gcubeMetadata.getTopologyLevel();
    }

    public void setTopologyLevel(TopologyLevel topologyLevel) {
        log.trace("Setting topology level: " + topologyLevel);
        this.gcubeMetadata.setTopologyLevel(topologyLevel);
    }

    public int getGeometryCount() {
        return this.gcubeMetadata.getGeometryCount();
    }

    public void setGeometryCount(int geometryCount) {
        log.trace("Setting geometry count: " + geometryCount);
        this.gcubeMetadata.setGeometryCount(geometryCount);
    }

    public double getResolution() {
        return this.gcubeMetadata.getResolution();
    }

    public void setResolution(double resolution) {
        log.trace("Setting resolution: " + resolution);
        this.gcubeMetadata.setResolution(resolution);
    }

    public List<String> getGraphicOverview() {
        return this.gcubeMetadata.getGraphicOverviewsURI();
    }

    public void setGraphicOverview(Collection<String> graphicOverview) {
        if (graphicOverview != null) {
            graphicOverview.forEach(grO -> {
                log.trace("Setting graphic iverview: " + grO);
                this.gcubeMetadata.addGraphicOverview((String)grO);
            });
        } else {
            log.warn("graphicOverview is null");
        }
    }
}

