/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.clustermanager.actuators.functions;

import gr.cite.clustermanager.actuators.ClientBase;
import gr.cite.clustermanager.model.functions.ExecutionDetails;
import java.io.Serializable;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionNotifier
extends ClientBase
implements Serializable {
    private static final long serialVersionUID = -3409922355958327265L;
    static final Logger log = LoggerFactory.getLogger(ExecutionNotifier.class);
    private PathChildrenCache cache = null;

    public ExecutionNotifier(String zkConnStr) throws Exception {
        super(zkConnStr);
    }

    public void notifyAbout(ExecutionDetails executionDetails) throws Exception {
        byte[] executionDetailsBytes = this.getObjectMapper().writeValueAsString((Object)executionDetails).getBytes();
        String objectPathZK = ZKPaths.makePath((String)"/functions", (String)executionDetails.getId());
        try {
            if (this.getClient().checkExists().forPath(objectPathZK) == null) {
                ((ACLBackgroundPathAndBytesable)this.getClient().create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(objectPathZK, executionDetailsBytes);
            }
            this.getClient().setData().forPath(objectPathZK, executionDetailsBytes);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            boolean ok = false;
            while (!ok) {
                try {
                    if (this.getClient().checkExists().forPath(objectPathZK) == null) {
                        ((ACLBackgroundPathAndBytesable)this.getClient().create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(objectPathZK, executionDetailsBytes);
                    }
                    this.getClient().setData().forPath(objectPathZK, executionDetailsBytes);
                    ok = true;
                }
                catch (Exception e2) {
                    log.warn("Could not upload current execution information. Will try again in a while...");
                    Thread.sleep(3000L);
                }
            }
        }
    }
}

